.\"**********************************************************************
.\"*									*
.\"*	Copyright 1993 by Motorola Wireless Data Group,			*
.\"*			  Bothell, WA					*
.\"*									*
.\"*	Motorola hereby grants permission to use, copy, modify and	*
.\"*	distribute  this software and its documentation for any		*
.\"*	purpose and without fee, provided that you retain this		*
.\"*	copyright notice in all copies.  Motorola makes no		*
.\"*	representations about the suitability of this software for any	*
.\"*	purpose.  Motorola provides this software ``as is'' without	*
.\"*	express or implied warranty.					*
.\"*									*
.\"**********************************************************************
.\"
.\" $Header: /usr/local/source/coda_source/Tcl/src7.4/svipc/man/shm.n,v 1.1.1.1 1996/08/21 19:30:10 heyes Exp $
.\"
.TH "Tcl_shared_memory" TCL "" "Tcl"
.SH NAME
shmat, shmdt, shmget, shmread, shmrmid, shmset, shmstat, shmwrite -
Tcl interface to shared memory IPC control functions.

.SH SYNOPSIS
.nf
\fBshmat \fIshmid\fR

\fBshmdt \fIaddr\fR

\fBshmget \fIkey ?mode? ?create? ?excl?\fR

\fBshmread \fIaddr fileId ?numBytes?\fR

\fBshmrmid \fIshmid\fR

\fBshmset \fIshmid {uid gid mode}\fR

\fBshmstat \fIshmid ?varName?\fR

\fBshmwrite \fIaddr fileId numBytes\fR
.fi

.SH DESCRIPTION
These commands allow access to the System V IPC shared memory segments
from Tcl applications.  They generally allow the same functionality as
the shmop(2), shmget(2) and shmctl(2) system calls.  These commands
manipulate the shared memory segment using the standard IPC control
functions.  To access data in the shared memory segment, see the
\fBget\fItype\fR and \fBset\fItype\fR commands.
'
.SS shmat
Attaches the shared memory segment specified by \fIshmid\fR to the Tcl
process at an address selected by the system.  The command returns the
address to at which the system attached the shared memory segment.
(Essentially calls shmat(2), specifying a \fIshmaddr\fR of zero.)
.SS shmdt
Detaches the shared memory segment previously attached to the
address given by the \fIaddr\fR parameter.
.SS shmget
Create or connect to a shared memory segment set.  The \fImode\fR optional
parameter sets the shared memory segment permissions if the shared
memory segment does not yet exist.  The \fIcreate\fR and \fIexcl\fR
optional parameters set the IPC_CREAT and IPC_PRIVATE flags in the
semget(2) system call.
'
.SS shmread
Reads data from \fIfileId\fR into the specified address.  If you do
not specify \fInumBytes\fR, the command reads the entire file.  The
command returns the actual number of bytes read.
'
.SS shmrmid
Removes the shared memory segment specified by the \fIshmid\fR
parameter by calling shmctl(2) with the IPC_RMID command.
'
.SS shmset
Modify the owner, group, or permissions of a shared memory segment, by using
the shmctl(2) system call with the IPC_SET command.
'
.SS shmstat
Return all known status about the shared memory segment, placing the returned
status into the named array or returning a structured list value.  If
you pass a variable name, the command places the IPC_STAT values into
the array elements \fBcuid\fR, \fBcgid\fR, \fBuid\fR, \fBgid\fR,
\fBmode\fR, \fBseq\fR, \fBkey\fR, \fBsegsz\fR, \fBcpid\fR, \fBlpid\fR,
\fBnattch\fR, \fBatime\fR, \fBdtime\fR, and \fBctime\fR.
This command also returns a structured list containing the values:
.sp
.in 0.5i
.nf
{{cuid cgid uid gid mode seq key} segsz cpid lpid nattch atime dtime ctime}
.fi
.in
'
.SS shmwrite
Writes \fInumBytes\fR starting at \fIaddr\fR to the specified
\fIfileId\fR.
'
.SH SEE ALSO
shmat(2), shmctl(2), shmdt(2), shmget(2), shmop(2)

.SH AUTHOR
.nf
Joe Kelsey
Motorola Wireless Data Group
19807 NorthCreek Parkway N.
Bothell, WA  98011
206.489.5746
kelsey@mdd.comm.mot.com
