/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	strdup routine, Dec does not have it
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: str_util.c,v $
 *   Revision 1.1.1.1  1996/08/21 19:20:53  heyes
 *   Imported sources
 *
*	  Revision 1.1  94/03/16  10:01:52  10:01:52  heyes (Graham Heyes)
*	  Initial revision
*	  
*	  Revision 1.1  93/10/27  09:29:28  09:29:28  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  
 */
#include <stdio.h>
#include <ctype.h>
#include <string.h>

char *strdup(s)
     char *s;
{
  char *p;

  p = (char *)malloc((strlen(s)+1)*sizeof(char));
  if(p == NULL){
    fprintf(stderr, "Cannot allocate space inside strdup routine\n");
    exit(1);
  }
  strcpy(p, s);
  return(p);
}

char *strToLower (s)
     char *s;
{
  char *p = s;
  while (*p != '\0'){
    *p = tolower (*p);
    p++;
  }
  return s;
}
