/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, *
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *       heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363         *
 *----------------------------------------------------------------------------*
 * Description: follows this header.
 *
 * Author:
 *	David Abbott
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *	  Initial revision
 *
 *
 *----------------------------------------------------------------------------*/

 /* tir_trigLib.c -- Primitive trigger control for VME CPUs using the TJNAF 
                     Trigger Supervisor interface card

 File : tir_trigLib.h

 Routines:
	   void tirtriglink();       link in trigger isr
	   void tirtenable();        enable trigger
	   void tirtdisable();       disable trigger
           void tirtack();           Acknowledge/Reset trigger
	   char tirttype();          read trigger type
	   int  tirttest();          test for trigger (POLL)

------------------------------------------------------------------------------*/


#define mem32(a) (*(unsigned long *) (a))

#define TIR_VEC 0xec
#define TIR_LEVEL 5

#ifdef VXWORKSPPC
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) (intNum))
#else
#define INUM_TO_IVEC(intNum)    ((VOIDFUNCPTR *) (intNum<<2))
#endif


static inline void 
tirtriglink(isr)
     VOIDFUNCPTR isr;
{
  static FUNCPTR handlerPtr = (FUNCPTR) 0;
  
  if (handlerPtr)
    free(handlerPtr);

/* Reset tir and Write interrupt vector into tir register*/
  tir[1]->tir_csr = 0x80;
  tir[1]->tir_vec = TIR_VEC;

#ifndef VXWORKSPPC
  handlerPtr = intHandlerCreate(isr,0);
  intVecSet((VOIDFUNCPTR *) (INUM_TO_IVEC(TIR_VEC)),(VOIDFUNCPTR) handlerPtr);
#else
  if((intDisconnect(INUM_TO_IVEC(TIR_VEC)) !=0))
     printf("Error disconnecting Interrupt\n");
  intConnect(INUM_TO_IVEC(TIR_VEC),isr,0);
#endif

}

static inline void 
tirtenable(intMask)
 unsigned long intMask;
{
 int lock_key;

#ifndef POLLING_MODE
  lock_key = intLock();

  sysIntEnable(TIR_LEVEL);       /* Enable VME Level 5 interrupts on CPU*/
#ifdef VXWORKSPPC
  intEnable(11);         /* Enable VME Interrupts on IBC chip */
#endif

#ifdef TRIG_SUPV
/*Set TIR to accept Trigger Supervisor triggers*/
  tir[1]->tir_csr = 0x6;
#else
/*Set TIR for External triggers*/
  tir[1]->tir_csr = 0x7;
#endif
  intUnlock(lock_key);

#else

#ifdef TRIG_SUPV
/*Set TIR for Trigger Supervisor triggers*/
  tir[1]->tir_csr = 0x2;
#else
/*Set TIR for External triggers*/
  tir[1]->tir_csr = 0x3;
#endif

#endif
}

static inline void 
tirtdisable(intMask)
 unsigned long intMask;
{
  tir[1]->tir_csr = 0x80;
}

static inline void 
tirtack(intMask)
 unsigned long intMask;
{
  tir[1]->tir_dat = 0x8000;
}

static inline unsigned long 
tirttype()
{
 unsigned long tt;
#ifdef TRIG_SUPV
/* Read Trigger type from TIR data register */
  tt = (((tir[1]->tir_dat)&0x3c)>>2);
  syncFlag = (tir[1]->tir_dat)&0x01;
  lateFail = ((tir[1]->tir_dat)&0x02)>>1;
#else
/* Set default trigger type to 1 */
  tt=1;
#endif
  return(tt);
}

static inline int 
tirttest()
{
  int ii=0;
  /* NOTE: See that internal VME IRQ is set on the SFI*/
  ii = (((tir[1]->tir_csr) & 0x8000) != 0);
  return(ii);
}

