
#define _DADEFINED

typedef void (*VOIDFUNCPTR) ();
typedef unsigned long (*FUNCPTR) ();

extern int setjmp();
extern int longjmp();

typedef struct configStruct *configS;
typedef struct semaphore *SEM_ID;

void download ();
void prestart ();
void end ();
void pause ();
void go ();
void trigger ();
void done ();
void status ();

VOIDFUNCPTR onDownload = download;
VOIDFUNCPTR onPrestart = prestart;
VOIDFUNCPTR onEnd = end;
VOIDFUNCPTR onPause = pause;
VOIDFUNCPTR onGo = go;
VOIDFUNCPTR onTrigger = trigger;
VOIDFUNCPTR readDone = done;
VOIDFUNCPTR onStatus = status;

VOIDFUNCPTR sigRoc = 0;
VOIDFUNCPTR daLogMsg = 0;

unsigned long **dabufp = 0;
unsigned long *rocID = 0;
unsigned long *hiWater = 0;
unsigned long *evnb = 0;
unsigned long *readout = 0;
unsigned long *sleep = 0;
unsigned long *magic = 0;

#ifdef FASTBUS
unsigned long reqFastbus = 2;
#endif

#ifdef CAMAC
unsigned long reqCamac = 1;
FUNCPTR caopen = 0;
FUNCPTR cdreg = 0;
FUNCPTR cfsa = 0;
FUNCPTR cccz = 0;
FUNCPTR cccc = 0;
FUNCPTR ccci = 0;
FUNCPTR ctci = 0;
FUNCPTR cccd = 0;
FUNCPTR ctcd = 0;
FUNCPTR ccgl = 0;
FUNCPTR ctgl = 0;
FUNCPTR cdlam = 0;
FUNCPTR cclm = 0;
FUNCPTR cclc = 0;
FUNCPTR ctlm = 0;
FUNCPTR cclwt = 0;
FUNCPTR ccinit = 0;
FUNCPTR cclnk = 0;
FUNCPTR cssa = 0;
FUNCPTR ccrgl = 0;
#else
unsigned long reqCamac = 0;
#endif

extern int global_env[];
extern long global_env_depth;
extern char *global_routine[100];

#define DATAPTR32 ((long  *) (*dabufp))
#define DATAPTR16 ((short *) (*dabufp))
#define DATAPTR8  ((char  *) (*dabufp))
#define MAX_BLENGTH 2048
#define TCP_ON 1
#define LOCK_STEP 2

#define DA_TRIGGER_PROC 5
#define DA_DONE_PROC    6

#define EV_SYNC     16
#define EV_PRESTART 17
#define EV_GO       18
#define EV_PAUSE    19
#define EV_END      20
#define EV_DONE     21
#define EV_TRIGGER  22

#define EV_BANK_HDR  0x00000100
#define EV_MBANK_HDR 0x00001000
#define EV_BAD       0x10000000

#define PHYS_BANK_HDR(t,e) (unsigned long)((((t)&0xffff)<<16) | \
					((e)&0xff) | \
					EV_BANK_HDR)

#define PHYS_MBANK_HDR(t,e) (unsigned long)((((t)&0xffff)<<16) | \
					((e)&0xff) | \
					EV_MBANK_HDR)

#define CTL_BANK_HDR(t) (unsigned long)((((t)&0xffff)<<16) | \
					0x000001CC)

#define IS_BANK(b) (((unsigned long) (b) && EV_BANK_HDR)==EV_BANK_HDR)

#define DECODE_BANK_HEADER(b,t,e) { t = (ntohl(b[1])>>16)&0xffff;\
					 e = ntohl(b[1])&0xff;}

#define EV_BANK_ID 0xc0010100
#define EV_HDR_LEN 4

typedef struct dataBuffer *daBuffer;
extern int tEvSz;
extern int dodone;
extern long recPermis;
extern long data_tx_mode;
extern int async_roc_flag;
extern struct configStruct config;

typedef struct dataBuffer
  {
    daBuffer previous;
    daBuffer next;
    unsigned long length;
    unsigned long data;
  } datbs;

typedef struct configStruct
  {
    char *readOutFn;
    char *runName;
    int runType;
    int runNumber;
    int hardwareMask;
    int triggerMask;
    int configurationMask;
    int maxEvents;
    int priority;
    int lockMode;
    unsigned long magic;
    unsigned long text;
    unsigned long data;
    unsigned long bss;
    char *dacode[3];
    VOIDFUNCPTR *daprocs;
    long *dabufp;
    long *dabuf;		/* current transmit buffer */
    long *outBuf;		/* current transmit buffer */
    long *dabufs[2];	        /* pointers to data buffers */
    char whichbuf;		/* current buffer index */
    unsigned long recNb;
    int ctableS;
    char ctableN[80];
    unsigned long *ctable;
    int eventTask;
    int ourID;			/* ID of this roc */
    SEM_ID eventMsgQ;		/* isr synchronization semaphore */
    char *usrString;    
  } configStructS;


#define eventnumber evnb
#define ZERO 0

unsigned long *startOfEvent;

static int trig_type,sync_bit,late_fail;
static long sync_evnb = 0;
static int triglam,trigMask,trigTest;
static int defaultAm = 0x0d;	/* default AM ext sup data */
static long *localA;
static int padr,sadr;
static char *fb_rtn;

