/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, *
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *      heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * Discription: follows this header.
 *
 * Author:
 *	Graham Heyes
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *      $Log: rol_old.h,v $
 *      Revision 1.1.1.1  1996/08/21 19:21:00  heyes
 *      Imported sources
 *
*	  Revision 1.4  93/12/01  13:58:39  13:58:39  abbottd (David Abbott)
*	  Improved speed for fpbrf() routine using embedded asm commands
*	  
*	  Revision 1.3  93/11/22  09:14:46  09:14:46  abbottd (David Abbott)
*	  Fixed fast block read routine fpbrf()
*	  
*	  Revision 1.2  93/11/09  11:24:26  11:24:26  heyes (Graham Heyes)
*	  enable processor fifo copy.
*	  
*	  Revision 1.1  93/10/27  09:29:26  09:29:26  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  Revision 1.22  1993/05/25  17:37:57  heyes
 *	  limit status
 *
 *	  Revision 1.21  1993/05/24  20:28:01  heyes
 *	  fb_proto_1.h
 *
 *	  Revision 1.20  1993/05/18  17:59:45  heyes
 *	  fix camac output
 *
 *	  Revision 1.19  1993/05/18  17:36:48  heyes
 *	  block length for fpbr
 *
 *	  Revision 1.18  1993/05/17  18:42:23  heyes
 *	  add MAX_BLENGTH
 *
 *	  Revision 1.17  1993/05/05  12:25:41  heyes
 *	  fbr length was in bytes not words
 *
 *	  Revision 1.16  1993/05/04  20:16:56  watson
 *	  fix cdowrite
 *
 *	  Revision 1.15  1993/04/29  14:32:20  heyes
 *	  fix alpha test problems
 *
 *	  Revision 1.14  1993/03/29  20:45:49  heyes
 *	  inline -> macro
 *
 *	  Revision 1.13  1993/03/29  14:43:53  heyes
 *	  remove referneces to VxWorks.h
 *
 *	  Revision 1.12  1993/03/26  16:36:07  heyes
 *	  ERROR-> 3 args
 *
 *
 *	  Revision 1.10  1993/03/25  15:24:52  heyes
 *	  buffer limit 8800 -> 8192
 *
 *	  Revision 1.9  1993/03/24  15:19:11  heyes
 *	  remove roc from header
 *
 *	  Revision 1.8  1993/03/16  14:04:49  heyes
 *	  reinsert for coda 1.2
 *
 *	  Revision 1.7  1992/11/03  21:14:11  heyes
 *	  fixed output
 *
 *	  Revision 1.6  1992/10/23  18:19:45  heyes
 *	  chk vxworks readout
 *
 *	  Revision 1.5  1992/08/14  15:31:22  heyes
 *	  1.1.2 release- support for VME
 *
 *	  Revision 1.4  1992/08/03  12:55:42  heyes
 *	  beta test Fastbus
 *
 *	  Revision 1.3  1992/07/21  17:52:22  heyes
 *	  run time debug on vxworks
 *
 *	  Revision 1.2  1992/06/25  19:01:32  heyes
 *	  insert into RCS for first time
 *
 *	  Revision 1.1  1992/06/25  18:30:44  heyes
 *	  Initial revision
 *
 *
 *----------------------------------------------------------------------------*/

#define _DADEFINED

typedef void (*VOIDFUNCPTR) ();
typedef unsigned long (*FUNCPTR) ();

extern int setjmp();
extern int longjmp();

typedef struct configStruct *configS;
typedef struct semaphore *SEM_ID;

void download ();
void prestart ();
void end ();
void pause ();
void go ();
void trigger ();
void done ();
void status ();

VOIDFUNCPTR onDownload = download;
VOIDFUNCPTR onPrestart = prestart;
VOIDFUNCPTR onEnd = end;
VOIDFUNCPTR onPause = pause;
VOIDFUNCPTR onGo = go;
VOIDFUNCPTR onTrigger = trigger;
VOIDFUNCPTR readDone = done;
VOIDFUNCPTR onStatus = status;

VOIDFUNCPTR sigRoc = 0;
VOIDFUNCPTR daLogMsg = 0;

unsigned long **dabufp = 0;
unsigned long *rocID = 0;
unsigned long *hiWater = 0;
unsigned long *evnb = 0;
unsigned long *readout = 0;
unsigned long *sleep = 0;
unsigned long *magic = 0;

#ifdef FASTBUS
unsigned long reqFastbus = 2;
#endif

#ifdef CAMAC
unsigned long reqCamac = 1;
FUNCPTR caopen = 0;
FUNCPTR cdreg = 0;
FUNCPTR cfsa = 0;
FUNCPTR cccz = 0;
FUNCPTR cccc = 0;
FUNCPTR ccci = 0;
FUNCPTR ctci = 0;
FUNCPTR cccd = 0;
FUNCPTR ctcd = 0;
FUNCPTR ccgl = 0;
FUNCPTR ctgl = 0;
FUNCPTR cdlam = 0;
FUNCPTR cclm = 0;
FUNCPTR cclc = 0;
FUNCPTR ctlm = 0;
FUNCPTR cclwt = 0;
FUNCPTR ccinit = 0;
FUNCPTR cclnk = 0;
FUNCPTR cssa = 0;
FUNCPTR ccrgl = 0;
#else
unsigned long reqCamac = 0;
#endif

#ifdef FASTBUS
#include "trigLib.h"
#include "fb_types.h"
#include "fb_fscc_macro.h"

#ifdef FB_BUILD_INLINE
#include "fb_status_macros.h"
#include "fb_fscc_inline.h"
#else
#include "fb_proto_1.h"
#endif

#ifndef FB_LIMITED_STATUS
  char	*FB_ERRTXT[FB_ERROR_MAX+1] =
	{
	"",
	"ERROR: 0x%X %s,%s - address release timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - AK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - block data - SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data parity error, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - data SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=3, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=4, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=5, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=6, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=7, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - DK release timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - DK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - long timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=2, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=3, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=4, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=5, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=6, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=7, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - s.addr cycle DK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=3, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=4, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=5, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=6, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=7, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - software timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - wait timeout, PAD %d, SAD %d\n",

	"ERROR: 0x%X %s,%s - normal successful completion\n",
	"ERROR: 0x%X %s,%s - error accessing data buffer\n",
	"ERROR: 0x%X %s,%s - abort action\n",
	"ERROR: 0x%X %s,%s - already connected\n",
	"ERROR: 0x%X %s,%s - bad parameter value\n",
	"ERROR: 0x%X %s,%s - buffer overflow\n",
	"ERROR: 0x%X %s,%s - session closed, no actions possible\n",
	"ERROR: 0x%X %s,%s - routine connection failed\n",
	"ERROR: 0x%X %s,%s - routine disconnect failed\n",
	"ERROR: 0x%X %s,%s - environment active\n",
	"ERROR: 0x%X %s,%s - environment id overflow\n",
	"ERROR: 0x%X %s,%s - environment overflow\n",
	"ERROR: 0x%X %s,%s - environment release\n",
	"ERROR: 0x%X %s,%s - generic error\n",
	"ERROR: 0x%X %s,%s - generic fatal\n",
	"ERROR: 0x%X %s,%s - hardware error\n",
	"ERROR: 0x%X %s,%s - hardware warning\n",
	"ERROR: 0x%X %s,%s - holding address\n",
	"ERROR: 0x%X %s,%s - holding bus\n",
	"ERROR: 0x%X %s,%s - error was ignored\n",
	"ERROR: 0x%X %s,%s - illegal parameter value\n",
	"ERROR: 0x%X %s,%s - illegal sequential buffer id\n",
	"ERROR: 0x%X %s,%s - unexpected implementation error\n",
	"ERROR: 0x%X %s,%s - generic informational\n",
	"ERROR: 0x%X %s,%s - invalid environment id\n",
	"ERROR: 0x%X %s,%s - invalid list pointer\n",
	"ERROR: 0x%X %s,%s - invalid port id\n",
	"ERROR: 0x%X %s,%s - invalid sequential buffer id\n",
	"ERROR: 0x%X %s,%s - last pad\n",
	"ERROR: 0x%X %s,%s - last secondary address\n",
	"ERROR: 0x%X %s,%s - last list pointer\n",
	"ERROR: 0x%X %s,%s - list overflow\n",
	"ERROR: 0x%X %s,%s - long timer on\n",
	"ERROR: 0x%X %s,%s - no address connection\n",
	"ERROR: 0x%X %s,%s - no more status\n",
	"ERROR: 0x%X %s,%s - no privilege\n",
	"ERROR: 0x%X %s,%s - no supplementary status\n",
	"ERROR: 0x%X %s,%s - not connected\n",
	"ERROR: 0x%X %s,%s - not holding mastership\n",
	"ERROR: 0x%X %s,%s - not master\n",
	"ERROR: 0x%X %s,%s - session already open\n",
	"ERROR: 0x%X %s,%s - operation pending\n",
	"ERROR: 0x%X %s,%s - pipeline transfer\n",
	"ERROR: 0x%X %s,%s - pointer overflow\n",
	"ERROR: 0x%X %s,%s - port active\n",
	"ERROR: 0x%X %s,%s - port already allocated\n",
	"ERROR: 0x%X %s,%s - port not allocated\n",
	"ERROR: 0x%X %s,%s - port not available\n",
	"ERROR: 0x%X %s,%s - port owned\n",
	"ERROR: 0x%X %s,%s - read only parameter\n",
	"ERROR: 0x%X %s,%s - operation successfully retried\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer active\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer exists\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer id overflow\n",
	"ERROR: 0x%X %s,%s - software timer on\n",
	"ERROR: 0x%X %s,%s - status not found\n",
	"ERROR: 0x%X %s,%s - status overflow\n",
	"ERROR: 0x%X %s,%s - successful operation\n",
	"ERROR: 0x%X %s,%s - unknown error\n",
	"ERROR: 0x%X %s,%s - unknown parameter\n",
	"ERROR: 0x%X %s,%s - unsupported port operation\n",
	"ERROR: 0x%X %s,%s - unsupported paramter\n",
	"ERROR: 0x%X %s,%s - unsupported routine\n",
	"ERROR: 0x%X %s,%s - user array overflow\n",
	"ERROR: 0x%X %s,%s - generic warning\n",
	"ERROR: 0x%X %s,%s - fscc FIFO error\n",
	};
#endif
#endif

extern int global_env[];
extern long global_env_depth;
extern char *global_routine[100];

#define DATAPTR32 ((long  *) (*dabufp))
#define DATAPTR16 ((short *) (*dabufp))
#define DATAPTR8  ((char  *) (*dabufp))
#define MAX_BLENGTH 2048
#define TCP_ON 1
#define LOCK_STEP 2

#define DA_TRIGGER_PROC 5
#define DA_DONE_PROC    6

#define EV_SYNC     16
#define EV_PRESTART 17
#define EV_GO       18
#define EV_PAUSE    19
#define EV_END      20
#define EV_DONE     21
#define EV_TRIGGER  22

#define EV_BANK_HDR  0x00000100
#define EV_MBANK_HDR 0x00001000
#define EV_BAD       0x10000000

#define PHYS_BANK_HDR(t,e) (unsigned long)((((t)&0xffff)<<16) | \
					((e)&0xff) | \
					EV_BANK_HDR)

#define PHYS_MBANK_HDR(t,e) (unsigned long)((((t)&0xffff)<<16) | \
					((e)&0xff) | \
					EV_MBANK_HDR)

#define CTL_BANK_HDR(t) (unsigned long)((((t)&0xffff)<<16) | \
					0x000001CC)

#define IS_BANK(b) (((unsigned long) (b) && EV_BANK_HDR)==EV_BANK_HDR)

#define DECODE_BANK_HEADER(b,t,e) { t = (ntohl(b[1])>>16)&0xffff;\
					 e = ntohl(b[1])&0xff;}

#define EV_BANK_ID 0xc0010100
#define EV_HDR_LEN 4

typedef struct dataBuffer *daBuffer;
extern int tEvSz;
extern int dodone;
extern long recPermis;
extern long data_tx_mode;
extern int async_roc_flag;
extern struct configStruct config;

typedef struct dataBuffer
  {
    daBuffer previous;
    daBuffer next;
    unsigned long length;
    unsigned long data;
  } datbs;

typedef struct configStruct
  {
    char *readOutFn;
    char *runName;
    int runType;
    int runNumber;
    int hardwareMask;
    int triggerMask;
    int configurationMask;
    int maxEvents;
    int priority;
    int lockMode;
    unsigned long magic;
    unsigned long text;
    unsigned long data;
    unsigned long bss;
    char *dacode[3];
    VOIDFUNCPTR *daprocs;
    long *dabufp;
    long *dabuf;		/* current transmit buffer */
    long *outBuf;		/* current transmit buffer */
    long *dabufs[2];	        /* pointers to data buffers */
    char whichbuf;		/* current buffer index */
    unsigned long recNb;
    int ctableS;
    char ctableN[80];
    unsigned long *ctable;
    int eventTask;
    int ourID;			/* ID of this roc */
    SEM_ID eventMsgQ;		/* isr synchronization semaphore */
    char *usrString;    
  } configStructS;


#define eventnumber evnb
#define ZERO 0

unsigned long *startOfEvent;

static int trig_type,sync_bit,late_fail;
static long sync_evnb = 0;
static int triglam,trigMask,trigTest;
static int defaultAm = 0x0d;	/* default AM ext sup data */
static long *localA;
static int padr,sadr;
static char *fb_rtn;

#ifdef FASTBUS

static char *aux_par;  /* Auxillary Parallel Port */

#define CRESET(c)  {fptdisable();fptriglink(trigger);fb_init_1 ();}
#define READIN(c)  {fb_frd_1(0,0,&c,0,1,1,1,0,1,1);IFERROR("fb_frd_1");}

#define IFERROR(str) \
  if (fb_errno!=FB_ERR_NORMAL) {\
    fb_rtn = str;\
    goto fooy;\
  }

#ifdef FB_LIMITED_STATUS
#define FB_REPORT_ERROR  daLogMsg("ERROR: FB %0X\n",fb_errno);
#else
#define FB_REPORT_ERROR  daLogMsg(FB_ERRTXT[FB_GET_ERROR_VALUE(fb_errno)],\
	   fb_errno, \
	   global_routine[global_env_depth],  \
	   fb_rtn,\
	   padr,sadr);
#endif

#define fpfwr(c) (*(*dabufp)++ = (c))

#define fparb() {fb_frd_1(0,0,0,0,0,1,1,1,1,1);IFERROR("fparb",padr,sadr);}

#define fpad(pa) {padr = (pa);fb_frd_1((pa),0,0,0,1,0,1,1,1,1);IFERROR("fpad");}

#define fpac(pa) {padr = (pa);fb_frc_1((pa),0,0,0,1,0,1,1,1,1);IFERROR("fpac");}

#define fpgad(pa) {padr = (pa);fb_frd_1((pa),0,0,1,1,0,1,1,1,1);IFERROR("fpgad");}

#define fpgac(pa) {padr = (pa);fb_frc_1((pa),0,0,1,1,0,1,1,1,1);IFERROR("fpgac");}

#define fpsaw(sa) {sadr = (sa);fb_frd_1(0,sa,0,0,1,1,0,1,1,1);IFERROR("fpsaw");}

#define fpr() {fb_frd_1(0,0,*dabufp,0,1,1,1,0,1,1);IFERROR("fpr");*dabufp++;}

#define fpw(data) {fb_fwd_1(0,0,(data),0,1,1,1,0,1,1);IFERROR("fpw");}

#define fpwb(data,len) {fb_fwdb_1(0,0,(data),(len),0,1,1,1,0,0,1,1,0);IFERROR("fpwb");}

#define fparel() {fb_frd_1(0,0,0,1,1,1,1,1,0,1);IFERROR("fparel");}

#define fprel() {fb_frd_1(0,0,0,1,1,1,1,1,0,0);IFERROR("fprel");}

#define triggertype   fpttype()
#define wordcount     fpwcr()

inline void 
  fpbr(long len) 
{
  int i;
  if ((len>2000)||(len<1)) len = 2000;
  fb_frdb_1(0,0,*dabufp,(len<<2),0,1,1,1,0,0,1,1,0);
  IFERROR("fprb data");
  fb_frlen_1(&i);
  IFERROR("fprb");
  *dabufp += (i>>2);
  return;
  
 fooy:
  FB_REPORT_ERROR;
  return;
}

static inline void 
  fpbrf(long len) 
{
  int i, ix;
#ifdef PARALLEL_LINK
  len=4095;
#else
  if ((len>512)||(len<1)) len = 512;
  FSCC_DATARS;
  FSCC_COPYRS;
  FSCC_COPYEN;
#endif
  fb_frdb_1(0,0,FB_DATA_PATH_ADDR,(len<<2),0,1,1,1,0,0,1,1,0);
  IFERROR("fpbrf data");
#ifndef PARALLEL_LINK
  fb_frlen_1(&i);
  if((ix = (i>>2) - 1)>=0) {   /* # of longwords - 1*/

  asm("movel #6815744,a2");                 /* address of fifo                  */
  asm("movel %0,d1":/*none*/:"g" (ix));     /* word count - 1                   */
  asm("movel _dabufp,a0");                  /* get pointer to dabufp            */
  asm("movel a0@,a1");                      /* a1= *dabufp                      */
  asm("movel a2@,a1@+");                    /* move from fifo to *((*dabufp)++) */
  asm(".long 1472856060");                  /* asm("dbf d1,-4")                 */
  asm("movel a1,a0@");                      /* put a1 back into *dabufp         */
  }

  FSCC_COPYDIS;
  IFERROR("fpbrf buffer");
#endif
  return;
  
 fooy:
  FB_REPORT_ERROR;
  return;
}

#endif

#ifdef CAMAC
#include "z8536.h"
#define UTINY   char

#define CRESET(c) ccinit((c));
static int ext, dumstat;
static int inta[2];

#define fpfwr(c) (*(*dabufp)++ = (c))

#define cdofiforead(b,c,n,a,f) cdreg(&ext,b,c,n,a);cfsa(f,ext,*dabufp,&dumstat);*dabufp += 1;


#define cdoread(b, c, n, a, f, x) cdreg (&ext, b, c, n, a);cfsa (f, ext, &x, &dumstat);


#define cdowrite(x, b, c, n, a, f) {\
	int cdowritetemp = x; \
	cdreg (&ext, b, c, n, a);cfsa (f, ext, &cdowritetemp, &dumstat);}

#define cdotriglink(b,c,n,a) cdlam(&triglam,b,c,n,a,inta);cclnk(triglam,(VOIDFUNCPTR)trigger);

#define cdocontrol(b, c, n, a, f) cdreg(&ext, b, c, n, a);cssa(f, ext, &dumstat, &dumstat);

#define cdoinhibit(c) cdreg(&ext,0,c,0,0);ccci(ext,1);

#define cdouninhibit(c) cdreg(&ext,0,c,0,0);ccci(ext,0);

#endif

#ifdef VME

#define VME_STD_SUP_ASC    	0x3f
#define VME_STD_SUP_PGM		0x3e
#define VME_STD_SUP_DAT		0x3d

#define VME_STD_USR_ASC	        0x3b
#define VME_STD_USR_PGM		0x3a
#define VME_STD_USR_DAT		0x39

#define VME_SHR_SUP_IO		0x2d
#define VME_SHR_USR_IO		0x29

#define VME_EXT_SUP_ASC	        0x0f
#define VME_EXT_SUP_PGM		0x0e
#define VME_EXT_SUP_DAT 	0x0d

#define VME_EXT_USR_ASC    	0x0b
#define VME_EXT_USR_PGM		0x0a
#define VME_EXT_USR_DAT		0x09

#define CRESET(c) 

#define fpfwr(c) (*dabufp++ = (c))
#define HSM_MEMSIZE             0x20000

extern void sysBusToLocalAdrs(int space,long *localA,long **busA);

struct vme_ts {
    long csr;       
    long trig;
    long roc;
    long sync;
    long test;
    long state;
    long blank_1;           /* no register */
    long blank_2;           /* no register */
    long prescale[8];
    long timer[5];
    long blank_3;           /* no register */
    long blank_4;           /* no register */
    long blank_5;           /* no register */
    long sc_as;
    long scale_0a;
    long scale_1a;
    long blank_6;           /* no register */
    long blank_7;           /* no register */
    long scale_0b;
    long scale_1b;
  };

struct vme_tir {
    short tir_csr;
    short tir_vec;
    short tir_dat;
    short tir_oport;
    short tir_iport;
  };

struct vme_hsm {
    long hsm_mem[131072];
    long hsm_blank[131072];
    long hsm_intr;
    long hsm_csr;
    long hsm_addr;
    long hsm_free;
  };

struct vme_dpm {
    long dpm_mem[32768];
    short dpm_addr;
    short dpm_mode;
  };

struct vme_scal {
    unsigned short reset;
    unsigned short blank1[7];
    unsigned short bim[8];
    unsigned short blank2[16];
    unsigned long preset[16];
    unsigned long scaler[16];
    unsigned short blank3[29];
    unsigned short id[3];
  };

struct vme_ts  *ts;
struct vme_tir *tir[2];
struct vme_hsm *hsm;
struct vme_dpm *dpm;
struct vme_dpm *dpml;
struct vme_scal *vscal[32];
struct vme_scal *vlscal[32];

long *tsmem;
long ts_memory[4096];
long preset_count;

long *vme2_ir;
long *hsmMemAdd;
long memleft;
short scal_id;

void
vdummy(c)
     int c;     
{
}

#define vdofiforead(mode, addr)  sysBusToLocalAdrs(mode, addr, &localA);\
  **dabufp = *localA;\
  *dabufp += 1;

#define vdoread(mode, addr, x) sysBusToLocalAdrs(mode, addr, &localA);x = *localA;

#define vdowrite(x,mode,addr) sysBusToLocalAdrs(mode, addr, &localA); *localA = x;

#define vdotrig(mode,addr,mask,test) sysBusToLocalAdrs(mode, addr, &localA);\
triglam = (long) localA;trigMask = mask;trigTest = test;

#endif
