/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, *
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *      heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * Discription: follows this header.
 *
 * Author:
 *	Graham Heyes
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *      $Log: rol.h,v $
 *      Revision 1.1.1.1  1996/08/21 19:21:00  heyes
 *      Imported sources
 *
*	  Revision 1.2  94/03/16  11:00:33  11:00:33  heyes (Graham Heyes)
*	  auto replace
*	  
*	  Revision 1.1  94/03/16  10:01:10  10:01:10  heyes (Graham Heyes)
*	  Initial revision
*	  
 *
 *----------------------------------------------------------------------------*/
#ifndef _ROLDEFINED
#define _ROLDEFINED

typedef void (*VOIDFUNCPTR) ();
typedef unsigned long (*FUNCPTR) ();

typedef struct semaphore *SEM_ID;
typedef unsigned long time_t;

static void __download ();
static void __prestart ();
static void __end ();
static void __pause ();
static void __go ();
static void __done ();
static void __status ();

static int theIntHandler ();

/* Include the memory partition structures and routine */

#include "libpart.h"

/* The following structure is used per readout list to store it's global data */
     
typedef struct rolParameters *rolParam;
     
typedef struct rolParameters
  {
    char          *name;	     /* name of parent process */
    char          *listName;	     /* name of this list */
    int            runType;	     /* run type */
    int            runNumber;	     /* run number */
    VOIDFUNCPTR    doit;	     /* init procedure */
    int            daproc;	     /* list of function pointers */
    void          *id;		     /* ID of storage used during load */
    char          *dacode[3];	     /* can't be unloaded */
    int            inited;	     /* we have been initialised */
    long          *dabufp;	     /* output  write pointer */
    long          *dabufpi;	     /* input   read  pointer */
    ROL_MEM_PART  *pool;             /* our freememory pool */
    ROL_MEM_PART  *output;	     /* our output */
    ROL_MEM_PART  *input;            /* our input */
    ROL_MEM_PART  *dispatch;         /* used by dispatcher to delay triggers */
    volatile ROL_MEM_PART  *dispQ;   /* dispatcher queue */
    unsigned long  recNb;	     /* count of output buffers processed */
    char          *usrString;	     /* string passed in download */
    void          *private;	     /* private storage */
    int            pid;              /* ROC ID */
  } ROLPARAMS;

extern ROLPARAMS rolP;
static rolParam rol;
static long *bufp;

#include "services.h"

     /* READOUT LIST PROCEDURES  */
#define DA_INIT_PROC        0
#define DA_DOWNLOAD_PROC    1
#define DA_PRESTART_PROC    2
#define DA_END_PROC         3
#define DA_PAUSE_PROC       4
#define DA_GO_PROC          5
#define DA_POLL_PROC        6
#define DA_DONE_PROC        7
#define DA_REPORT_PROC      8
#define DA_FREE_PROC        9


     /* Event types */
#define EV_SYNC     16
#define EV_PRESTART 17
#define EV_GO       18
#define EV_PAUSE    19
#define EV_END      20


#define EV_BANK_HDR  0x00000100
#define EV_BAD       0x10000000

#define PHYS_BANK_HDR(t,e) (unsigned long)((((t)&0xf)<<16) | \
					     ((e)&0xff) | \
					     EV_BANK_HDR)

#define CTL_BANK_HDR(t) (unsigned long)((((t)&0xffff)<<16) | \
					0x000001CC)
     
#define IS_BANK(b) (((unsigned long) (b) && EV_BANK_HDR)==EV_BANK_HDR)
     
#define DECODE_BANK_HEADER(b,t,e) { t = (b[1]>>16)&0xffff;\
				      e = b[1]&0xff;}    
     
#define EV_BANK_ID 0xc0010100
#define EV_HDR_LEN 4


/* Event type source */

static int EVENT_type;
static int stream_fd__;

/* Identify external variables from rocSvc and VxWorks kernel */

extern int global_env[];
extern long global_env_depth;
extern char *global_routine[100];

extern long evnb;
extern long recPermis;
extern long magic;
extern int doDone;
extern long readout;
extern long data_tx_mode;
extern int async_roc_flag;
extern int rcConnect_mode;
long theIntCount;

#include "BankTools.h"

/* Disable Readout List error Recovery for Now */
/*#define RECOVER {if (global_env_depth>=0) global_env_depth--; \
  longjmp(global_env[global_env_depth+1],global_code);} */
#define RECOVER  return

#include "trigger_dispatch.h"

/* Maximum Event Length in bytes */
#ifndef MAX_EVENT_LENGTH
#define MAX_EVENT_LENGTH 512
#endif
/* Maximum number of buffers in the Pool */
#ifndef MAX_EVENT_POOL
#define MAX_EVENT_POOL 100
#endif
#ifndef ROL_NAME__
#define ROL_NAME__ "Un-named"
#endif

static char rol_name__[40];
static char temp_string__[132];

static unsigned long address___;

static void __poll()
{
    CDOPOLL;
}

void INIT_NAME(rolp)
     rolParam rolp;
{
      if ((rolp->daproc != DA_DONE_PROC)&&(rolp->daproc != DA_POLL_PROC)) 
	printf("rolp->daproc = %d\n",rolp->daproc);
      switch(rolp->daproc) {
      case DA_INIT_PROC:
	{
	  char name[40];
	  printf("__init__ - Initializing new rol structures \n");
	  rol = rolp;
	  stream_fd__ = 0;
	  rolp->inited = 1;
	  printf("rolp->inited %d\n",rolp->inited);
	  
	  strcpy(rol_name__, ROL_NAME__);
	  rolp->listName = rol_name__;

	  strcpy(name, rolp->listName);
	  strcat(name, ":pool");
	  rolp->pool  = partCreate(name, MAX_EVENT_LENGTH ,MAX_EVENT_POOL ,0);

	  strcpy(name, rolp->listName);
	  strcat(name, ":output");
	  rolp->output = partCreate(name, 0, 0, 0);

	  strcpy(name, rolp->listName);
	  strcat(name, ":input");
	  rolp->input = partCreate(name, 0, 0, 0);

	  strcpy(name, rolp->listName);
	  strcat(name, ":dispatch");
	  rolp->dispatch  = partCreate(name, 0, 32, 0);

	  strcpy(name, rolp->listName);
	  strcat(name, ":dispQ");
	  rolp->dispQ = partCreate(name, 0, 0, 0);

	  printf("INFO: __init__ from %s\n",rolp->listName);
	  printf("INFO: done init\n");  
	  break;
	}
      case DA_FREE_PROC:
	  printf("__init__ - Free readout list memory partitions \n");
	  rolp->inited = 0;
	  partFreeAll();
	break;
      case DA_DOWNLOAD_PROC:
	__download();
	break;
      case DA_PRESTART_PROC:
	__prestart();
	break;
      case DA_PAUSE_PROC:
	__pause();
	break;
      case DA_END_PROC:
	__end();
	break;
      case DA_GO_PROC:
	__go();
	break;
      case DA_POLL_PROC:
	__poll();
	break;
      case DA_DONE_PROC:
	__done();
	break;
      default:
	printf("WARN: unsupported action\n");
	break;
      }
}

#endif

