/****************************************************************
*
* header file for use of Struck SFI 340 with CODA crl
*
*                                DJA   March 1996
*
*****************************************************************/


extern int printf();

#ifdef VXWORKS
extern int logMsg();
#endif

struct sfiStruct sfi;         /* global parameter block */

/* constants for fast access to fastbus functions */
/* all these addresses are found in the write-to-vme2seq-address-space */
unsigned long *fastPrimDsr;
unsigned long *fastPrimCsr;
unsigned long *fastPrimDsrM;
unsigned long *fastPrimCsrM;
unsigned long *fastPrimHmDsr;
unsigned long *fastPrimHmCsr;
unsigned long *fastPrimHmDsrM;
unsigned long *fastPrimHmCsrM;
unsigned long *fastSecadR;
unsigned long *fastSecadW;
unsigned long *fastSecadRDis;
unsigned long *fastSecadWDis;
unsigned long *fastRndmR;
unsigned long *fastRndmW;
unsigned long *fastRndmRDis;
unsigned long *fastRndmWDis;
unsigned long *fastDiscon;
unsigned long *fastDisconRm;
unsigned long *fastStartFrdbWithClearWc;
unsigned long *fastStoreFrdbWc;
unsigned long *fastStoreFrdbAp;
unsigned long *fastLoadDmaAddressPointer;
unsigned long *fastDisableRamMode;
unsigned long *fastEnableRamSequencer;


/*======================================================================*/
/*
   Function     : SFI_ShowStatusReg

   In           : -
   Out          : -

   Description  : displays sfi sequencer/FASTBUS status register set

*/
/*======================================================================*/

void SFI_ShowStatusReg()
{
   printf("Sequencer Status Register = %08lX\n",*sfi.sequencerStatusReg);
   printf("Last Sequencer KeyAddress = %08lX\n",*sfi.lastSequencerProtocolReg);
   printf("Fastbus Status Register1  = %08lX\n",*sfi.FastbusStatusReg1);
   printf("Fastbus Status Register2  = %08lX\n",*sfi.FastbusStatusReg2);
   printf("Fastbus Last Primary Addr = %08lX\n",*sfi.fastbusreadback);
}

/*======================================================================*/
/*
   Funktion     : GetFastbusPtr

   In           : keyAddress - function key address on SFI
   Out          : returns    - absolute memory address of this function

   Bemerkungen  :
*/
/*======================================================================*/

unsigned long *GetFastbusPtr(keyAddress)
unsigned long keyAddress;
{
    unsigned long address;

    address = (unsigned long) sfi.writeVme2SeqFifoBase;
    address += keyAddress;

/*       printf("generated address %08lX\n",address); */

    return ((unsigned long*) (address));
}

/*======================================================================*/
/*
   Funktion     : InitSFI

   In           : 32 bit Base address for SFI board
   Out          : -

   Bemerkungen  : initializes program parameters
*/
/*======================================================================*/


void InitSFI(SFIBaseAddr)
   unsigned long SFIBaseAddr;
{

  /* configure standard mode */
  if (SFIBaseAddr <= 0)
    sfi.VMESlaveAddress = SFI_VME_BASE_ADDR; /* standard in test system */
  else
    sfi.VMESlaveAddress = SFIBaseAddr;

  sfi.writeVme2SeqFifoBase = (unsigned long *)
    ( sfi.VMESlaveAddress + SFI_WRITE_VME2SEQ_FIFO_BASE);
  
  sfi.readSeq2VmeFifoBase = (unsigned long *)
    ( sfi.VMESlaveAddress + SFI_READ_SEQ2VME_FIFO_BASE);
  
  
  sfi.sequencerOutputFifoSize = 1024;
  
  sfi.sequencerReset = (unsigned long*) 
    ( sfi.VMESlaveAddress + SFI_SEQUENCER_RESET);
  
  sfi.sequencerEnable = (unsigned long*) 
    ( sfi.VMESlaveAddress + SFI_SEQUENCER_ENABLE);
  
  sfi.sequencerDisable = (unsigned long*) 
    ( sfi.VMESlaveAddress + SFI_SEQUENCER_DISABLE);
  
  sfi.sequencerRamLoadEnable = (unsigned long*) 
    ( sfi.VMESlaveAddress + SFI_SEQUENCER_RAM_LOAD_ENABLE);
  
  sfi.sequencerRamLoadDisable = (unsigned long*) 
    ( sfi.VMESlaveAddress + SFI_SEQUENCER_RAM_LOAD_DISABLE);
  
  sfi.sequencerTryAgain = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_SEQUENCER_TRY_AGAIN);
  
  sfi.readLocalFbAdBus = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_READ_LOCAL_FB_AD_BUS);
  
  sfi.readVme2SeqDataFifo = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_READ_VME2SEQ_DATA_FIFO);
  
  sfi.readSeqFifoFlags = (unsigned long *)
    ( sfi.VMESlaveAddress + SFI_SEQUENCER_FIFO_FLAG_AND_ECL_NIM_INPUT_REGISTER);
  
  
  sfi.writeAuxReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_WRITE_AUX_REGISTER);
  
  sfi.generateAuxB40Pulse = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_GENERATE_AUX_B40_PULSE);
  
  sfi.writeVmeOutSignalReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_WRITE_VME_OUT_SIGNAL_REGISTER);
  
  sfi.clearBothLca1TestReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_CLEAR_BOTH_LCA1_TEST_REGISTER);
  
  sfi.writeVmeTestReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_WRITE_VME_TEST_REGISTER);
  
  sfi.FastbusArbitrationLevelReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_FASTBUS_ARBITRATION_LEVEL_REGISTER);
  
  sfi.FastbusProtocolInlineReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_FASTBUS_PROTOCOL_INLINE_REGISTER);
  
  sfi.sequencerFifoFlagAndEclNimInputReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_SEQUENCER_FIFO_FLAG_AND_ECL_NIM_INPUT_REGISTER);
  
  sfi.nextSequencerRamAddressReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_NEXT_SEQUENCER_RAM_ADDRESS_REGISTER);
  
  sfi.lastSequencerProtocolReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_LAST_SEQUENCER_PROTOCOL_REGISTER);
  
  sfi.sequencerStatusReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_SEQUENCER_STATUS_REGISTER);
  
  sfi.FastbusStatusReg1 = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_FASTBUS_STATUS_REGISTER1);
  
  sfi.FastbusStatusReg2 = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_FASTBUS_STATUS_REGISTER2);
  
  sfi.fastbusreadback = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_READ_LAST_FB_PRIM_ADDR_REGISTER);

  sfi.FastbusTimeoutReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_FASTBUS_TIMEOUT_REGISTER);
  
  sfi.FastbusArbitrationLevelReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_FASTBUS_ARBITRATION_LEVEL_REGISTER);
  
  sfi.VmeIrqLevelAndVectorReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_VME_IRQ_LEVEL_AND_VECTOR_REGISTER);
  
  sfi.VmeIrqMaskReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_VME_IRQ_MASK_REGISTER);
  
  sfi.sequencerRamAddressReg = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_SEQUENCER_RAM_ADDRESS_REGISTER);
  
  sfi.resetRegisterGroupLca2 = (unsigned long *)
    (sfi.VMESlaveAddress + SFI_RESET_REGISTER_GROUP_LCA2);
  
  printf("resetRegisterGroupLca2 = %08lX\n",(unsigned long)
	 sfi.resetRegisterGroupLca2 );
  printf("FastbusTimeoutRegister = %08lX\n",(unsigned long)
	 sfi.FastbusTimeoutReg );
  printf("FastbusdArbitrationLevelReg = %08lX\n",(unsigned long)
	 sfi.FastbusArbitrationLevelReg);
  
  
  
  /* intialize global variables for fast FASTBUS access */
  fastPrimDsr     = GetFastbusPtr(PRIM_DSR);
  printf("fastPrimDsr = %08lX\n", (unsigned long) fastPrimDsr);
  fastPrimCsr     = GetFastbusPtr(PRIM_CSR);
  fastPrimDsrM    = GetFastbusPtr(PRIM_DSRM);
  fastPrimCsrM    = GetFastbusPtr(PRIM_CSRM);
  fastPrimHmDsr   = GetFastbusPtr(PRIM_HM_DSR);
  fastPrimHmCsr   = GetFastbusPtr(PRIM_HM_CSR);
  fastPrimHmDsrM  = GetFastbusPtr(PRIM_HM_DSRM);
  fastPrimHmCsrM  = GetFastbusPtr(PRIM_HM_CSRM);
  fastSecadR      = GetFastbusPtr(SECAD_R);
  fastSecadW      = GetFastbusPtr(SECAD_W);
  fastSecadRDis   = GetFastbusPtr(SECAD_R_DIS);
  fastSecadWDis   = GetFastbusPtr(SECAD_W_DIS);
  fastRndmR       = GetFastbusPtr(RNDM_R);
  fastRndmW       = GetFastbusPtr(RNDM_W);
  fastRndmRDis    = GetFastbusPtr(RNDM_R_DIS);
  fastRndmWDis    = GetFastbusPtr(RNDM_W_DIS);
  fastDiscon      = GetFastbusPtr(DISCON);
  fastDisconRm    = GetFastbusPtr(DISCON_RM);
  fastStartFrdbWithClearWc = GetFastbusPtr(START_FRDB_WITH_CLEAR_WORD_COUNTER);
  fastStoreFrdbWc = GetFastbusPtr(STORE_FRDB_WC);
  fastStoreFrdbAp = GetFastbusPtr(STORE_FRDB_AP);
  fastLoadDmaAddressPointer = GetFastbusPtr(LOAD_DMA_ADDRESS_POINTER);
  fastDisableRamMode = GetFastbusPtr(DISABLE_RAM_MODE);
  fastEnableRamSequencer = GetFastbusPtr(ENABLE_RAM_SEQUENCER);
  
}


/*======================================================================*/
/*
   Funktion     : InitFastbus

   In           :       arbReg - value for arbitration level register
            timReg - value for arbitration timeout register
   Out          : -

   Bemerkungen  : reset fastbus sequencer and prepare for new action
*/
/*======================================================================*/

void InitFastbus(arbReg, timReg)
unsigned long arbReg, timReg;
{
   unsigned long val32out;

   /* reset sequencer */ 
   val32out = 0L;
   *sfi.sequencerReset = val32out; 

   /* set arbitration level */
   *sfi.FastbusArbitrationLevelReg = arbReg;

   /* set timeout register  */
   *sfi.FastbusTimeoutReg = timReg;

   /* enable sequencer */
   *sfi.sequencerEnable=val32out;

}

/*======================================================================*/
/*
   Function     : sfi_error_decode

   In           : -

   Out          : -

   Description  : Decode error from last sequencer failure , reset the
                  sequencer and pend a message to LogMsg in VxWorks.
*/
/*======================================================================*/

void sfi_error_decode()
{
   unsigned long seqStatus, seqKeyAddr;
   unsigned long fbStatus1=0, fbStatus2=0, paddr=-1;
   int ss,fb1=0,fb2=0;
   int reset = 0;
   int enable = 0;

/* First check Sequencer Status Register for error type */
   seqKeyAddr = *sfi.lastSequencerProtocolReg;
   seqStatus  = *sfi.sequencerStatusReg & 0xffff;
   switch(seqStatus) {
   case 0x8001:
   case 0xA001:
     logMsg("Sequencer OK\n",0,0,0,0,0,0);
     return;
   case 0x8000:
   case 0xA000:
     logMsg("ERROR: Sequencer not Enabled\n",0,0,0,0,0,0);
     return;
   case 0x8011:
   case 0xA011:
     logMsg("ERROR: Invalid Sequencer KeyAddress %x\n",seqKeyAddr,0,0,0,0,0);
     reset = 1;
     enable = 1;
     break;
   case 0xc020:
     fb1=1;
     fbStatus1 = *sfi.FastbusStatusReg1 & 0xfff;
     paddr = *sfi.fastbusreadback;
     break;
   case 0xc040:
     fb2=1;
     fbStatus2 = *sfi.FastbusStatusReg2 & 0xffff;
     paddr = *sfi.fastbusreadback;
     break;
   case 0xc080:
     fb2=1;
     fbStatus2 = *sfi.FastbusStatusReg2 & 0xffff;
     paddr = *sfi.fastbusreadback;
     break;
   default:
     logMsg("ERROR: Unknown Sequencer error: status=0x%x\n",seqStatus,0,0,0,0,0);
     return;
   }

/* Now Determine if this is an Addressing Error or Data error */
   if(fb1) {           /* Addressing Error */
     switch((fbStatus1 & 0x28F)) {
     case 0x200:
       logMsg("ERROR: Fastbus AK timout paddr=%d \n",paddr,0,0,0,0,0);
       break;
     case 0x002:
       logMsg("ERROR: Fastbus Arbitration timeout \n",0,0,0,0,0,0);
       break;
     case 0x001:
       logMsg("ERROR: Fastbus AS-AK lock already exists\n",0,0,0,0,0,0);
       break;
     case 0x004:
       logMsg("ERROR: Fastbus Master long timout\n",0,0,0,0,0,0);
       break;
     case 0x008:
       logMsg("ERROR: Fastbus Set AS timeout (WT High)\n",0,0,0,0,0,0);
       break;
     case 0x080:
       ss = (fbStatus1&0x70)>>4;
       logMsg("ERROR: Fastbus SS!=0 paddr=%d SS=%d\n",paddr,ss,0,0,0,0);
       break;
     default:
       logMsg("ERROR: Fastbus Address Error status=%x \n",fbStatus1,0,0,0,0,0);
     }
     reset = 1;
     enable = 1;
   }
   else if(fb2) {      /* Data Error       */
     logMsg("ERROR: Fastbus Data error paddr=%d, status=0x%x\n",paddr,fbStatus2,0,0,0,0);
     reset = 1;
     enable = 1;
   }


   /* reset sequencer */ 
   if(reset) *sfi.sequencerReset = 1; 

   /* enable sequencer */
   if(enable) *sfi.sequencerEnable = 1;

  return;
}

