/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, * 
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *      heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * Discription: follows this header.
 *
 * Author:
 *	Graham Heyes
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *      $Log: rc.h,v $
 *      Revision 1.1.1.1  1996/08/21 19:21:02  heyes
 *      Imported sources
 *
*	  Revision 1.1  94/03/16  09:55:02  09:55:02  heyes (Graham Heyes)
*	  Initial revision
*	  
 *
 *----------------------------------------------------------------------------*/
#ifndef _RC_INCLUDED_
#define _RC_INCLUDED_

#define MAXCLNT 30

#define DANULLPROC     ((u_long)0)
#define DACREATE       ((u_long)1)
#define DAREMOVE       ((u_long)2)
#define DADOWNLOAD     ((u_long)3)
#define DAPRESTART     ((u_long)4)
#define DAEND          ((u_long)5)
#define DAPAUSE        ((u_long)6)
#define DAGO           ((u_long)7)
#define DATERMINATE    ((u_long)8)
#define DAREPORT       ((u_long)9)
#define DAREADINT      ((u_long)10)
#define DAREADSTRING   ((u_long)11)
#define DAREADREAL     ((u_long)12)
#define DAWRITEINT     ((u_long)13)
#define DAWRITESTRING  ((u_long)14)
#define DAWRITEREAL    ((u_long)15)

#define DAMODIFYINT    ((u_long)16)
#define DAMODIFYSTRING ((u_long)17)
#define DAMODIFYREAL   ((u_long)18)
#define DAWRITEEVENT   ((u_long)19)
#define DACONFIGURE    ((u_long)20)
#define DARESET        ((u_long)21)
#define DABECOMEMASTER ((u_long)22)
#define DACANCELMASTER ((u_long)23)
#define DAISMASTER     ((u_long)24)
#define DASYNC         ((u_long)25)
#define DAREADMESSAGES ((u_long)26)
#define DAINSERTEVENT  ((u_long)27)
#define DABCREPLY      ((u_long)28)
#define DAREQEVENT     ((u_long)29)
#define DADUMP         ((u_long)30)
#define DAZAP          ((u_long)-1)

#define DA_ACTIONS       30

/* define states possible... */

#define DA_BOOTING        1
#define DA_BOOTED         2
#define DA_CONFIGURING    3
#define DA_CONFIGURED     4
#define DA_DOWNLOADING    5
#define DA_DOWNLOADED     6
#define DA_PRESTARTING    7

#define DA_PAUSING        9
#define DA_PAUSED         8

#define DA_ACTIVATING     10
#define DA_ACTIVE         11
#define DA_ENDING         12
#define DA_VERIFYING      13
#define DA_VERIFIED       14
#define DA_TERMINATING    15
#define DA_PRESTARTED     16
#define DA_RESUMING       17
#define DA_STATES         18


/* define possible state actions for historical reasons */

#define DA_CONFIGURE     DACONFIGURE
#define DA_DOWNLOAD      DADOWNLOAD
#define DA_PRESTART      DAPRESTART
#define DA_END           DAEND
#define DA_PAUSE         DAPAUSE
#define DA_GO            DAGO
#define DA_TERMINATE     DATERMINATE
#define DA_RESET         DARESET
#define DA_REPORT        DAREPORT
#define DA_BECOMEMASTER  DABECOMEMASTER
#define DA_CANCELMASTER  DACANCELMASTER
#define DA_ISMASTER      DAISMASTER
#define DA_READMESSAGES  DAREADMESSAGES

/* Error Codes */

#define RC__SUCCESS         0
#define RC__RPC_FAILURE    -1
#define RC__NOT_REGISTERED -3
#define RC__NOT_MASTER     -4

typedef struct rp {
  int a ;
  int b ;
} rpStruct;

typedef struct rp *runparameters;
typedef struct rp rp;

typedef struct reti {
  int a;
  int b;
} retiStruct;

typedef struct arg_rs *retrs;

struct arg_rs {
	int value;
	char *name;
} arg_rsStruct;

typedef struct arg_rs arg_rs;

typedef struct retr {
  int a;
  float b;
} retrStruct;

typedef struct argw_f {
  char *name;
  float value;
} argw_fStruct;

typedef struct argw_i {
  char *name;
  int value;
} argw_iStruct;

typedef struct argw_s {
  char *name;
  char *value;
} argw_sStruct;

extern int xdr_record();
extern int xdr_event();
extern int xdr_rp();
extern int xdr_ri();
extern int xdr_arg_rs();
extern int xdr_retrs();
extern int xdr_rr();
extern int xdr_wf();
extern int xdr_wi();
extern int xdr_ws();

extern int *dacreate();
extern int *daremove();
extern int *dadownload();
extern int *daprestart();
extern int *daend();
extern int *dapause();
extern int *dago();
extern int *daterminate();
extern int *dareport();
extern int daWriteEvent();
extern int rcConnect();
extern struct reti *dareadint();
extern retrs *dareadstring();
extern int daSync();
extern char *rcStates();
extern int *dareqevent();
extern int lastContext();
extern int restoreContext();
extern int daHandleSpy();
#endif
