/* header file for the memory allocation system */
#ifndef  __ROM_MEM_PART__
#define __ROM_MEM_PART__

typedef struct node			      /* Node of a linked list. */
    {
    struct node           *n;	              /* Points at the next node in the list. */
    struct node           *p;	              /* Points at the previous node in the list. */
    struct rol_mem_part   *part;	      /* Which partition "owns" this node. */    
    int                    fd;		      /* File descriptor associated with this node. */
    char                  *current;	      /* Current data mark */
    unsigned long          left;	      /* data left to process (bytes) */
    unsigned char          type;              /* data type */
    unsigned char          source;            /* data source */
    void                   (*reader)();       /* routine to read data if data segment is empty */
    unsigned long          length;	      /* Length of data to follow (bytes). */
    unsigned long          data[1];	      /* Node data. */
    } NODE;

typedef struct alist			      /* Header for a linked list. */
    {
    NODE        *f;		              /* head */
    NODE        *l;		              /* tail */
    int          c;			      /* Number of nodes in list */
    } LIST;


typedef struct rol_mem_part *ROL_MEM_ID;

typedef struct rol_mem_part{
    NODE	 node;		/* global partition list */
    LIST	 list;		/* free item list */
    char	 name[40];	/* part name */
    int		 size;		/* size of a single item */
    int		 incr;		/* # of items to add when expanding part */
    int		 total;		/* total items allocated so far */
    long         part[1];	/* pointer to memory pool */
} ROL_MEM_PART;

extern int nodeInUse__[32];

#define nodesInUse(id) nodeInUse__[id]

#define listGet(li,no) {(no) = 0;if((li)->c){(li)->c--;(no) = (li)->f;(li)->f = (li)->f->n;};if (!(li)->c) (li)->l = 0;}

#define listAdd(li,no) {if(! (li)->c ){(li)->f = (li)->l = (no);(no)->p = 0;} else {(no)->p = (li)->l;(li)->l->n = (no);(li)->l = (no);} (no)->n = 0;(li)->c++;}

#define listSnip(li,no) {if ((no)->p) {(no)->p->n =(no)->n;} else {(li)->f = (no);} if ((no)->n)(no)->n->p = (no)->p; \
			   (li)->c--;if ((li)->c==0) (li)->f = (li)->l = (NODE *)0;(no)->p=(no)->n= (NODE *)0;}
			   
#define listCount(li) ((li)->c)

#define listFirst(li) ((li)->f)
#define listLast(li) ((li)->l)

#define listNext(no) ((no)->n)

#define listInit(li) {bzero((char *) (li), sizeof(LIST));}

#define partFreeItem(pItem) {nodeInUse__[pItem->fd]--; listAdd (&pItem->part->list, pItem);}

#define partEmpty(pPart) (part->list.c == 0)

#define partGetItem(p,i) {listGet(&(p->list),i);}


extern ROL_MEM_ID  partCreate();	      /* (name,size,initial_qty,incr_qty) */
extern ROL_MEM_ID  partFindByName();
extern int	   partStats();		      /* (pPart) */
extern int	   partStatsAll();	      /* () */
extern void        partIncr ();
#endif
