/* CEOPEN    not yet implemented */
/* CECLOSE   not yet implemented */
/* CBOPEN */
/* CBCLOSE */
/* ENABLE_FPP */
/* DISABLE_FPP */
/* RESET_1190 */
/* VMEREAD_1190 */
/* CAMREAD */
/* BQSTOP */
/* BQSCAN */
/* COPY */
/* RAISE_I     not yet implemented (should already exist) */
/* LOWER_I     not yet implemented (should already exist) */
/* - rol.h ---------------------------------------------------------- */
#ifndef _chaosTools_h 
#define _chaosTools_h 

typedef unsigned short UI2_var;
typedef unsigned long  UI4_var;
typedef char           UB1_var;

typedef unsigned long  uint_32;
typedef unsigned short uint_16;
	
/* Param : */
#define BANK_ty 10
#define UB1_ty 7
#define UI2_ty 5
#define UI4_ty 1

/* Globals : */
unsigned long *GblTopBp, *GblTopEp;
unsigned long GblCnt;
unsigned long **dabufp;
uint_16       u16dummy;
uint_32       u32dummy;

/* Macro : */
#define VMEREAD_1190(vme_add,mxblen,btype) btype##_vmeread_1190(vme_add, mxblen)
#define BQSTOP(b,c,n,a,f,btype,r)       btype##_BQSTOP(b,c,n,a,f,r)
#define BQSCAN(b,c,n,a,f,btype,r)       btype##_BQSCAN(b,c,n,a,f,r)
#define CAMREAD(b,c,n,a,f,btype)        btype##_CAMREAD(b,c,n,a,f)
#define COPY(v,btype)                   btype##_COPY(v)

/* -------------------------------------------------------------------- */
/* - RAISE_I/LOWER_I -------------------------------------------------- */
/*.crl  : raise_i b c  <data_type> repeat*/
/*example : raise_i 0 3 */
/*          lower_i 0 3 */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#define RAISE_I(b,c) {\
        cdreg(&ext,b,c,1,0);\
        ccci (&ext,1);}

#define LOWER_I(b,c) {\
        cdreg(&ext,b,c,1,0);\
        ccci (&ext,0);}

/* -------------------------------------------------------------------- */
/* - UI2/4_bqstop --------------------------------------------------------- */
/*.crl  : bqstop b c n a f of <data_type> for repeat*/
/**/
/**/
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#define UI2_BQSTOP(b,c,n,a,f,r) {\
        cfqstop (b,c,n,a,f,&localA,r);\
        *(++((UI2_var*) (*dabufp))) = *((UI2_var*)localA);}

#define UI4_BQSTOP(b,c,n,a,f,r){\
        cfqstop (b,c,n,a,f,&localA,r);\
/* >>>>>>> missing code check the camac function D16/D24 <<<<<<<<<<<<<< */

/* -------------------------------------------------------------------- */
/* - UI2/4_bqscan --------------------------------------------------------- */
/*.crl  : bqscan b c n a f of <data_type> for repeat*/
/**/
/**/
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#define UI2_BQSCAN(b,c,n,a,f,r) {\
        cfscan (b,c,n,a,f,&localA,r);\
        *(++((UI2_var*) (*dabufp))) = *((UI2_var*)localA);}

#define UI4_BQSCAN(b,c,n,a,f,r){\
        cfscan (b,c,n,a,f,&localA,r);\
/* >>>>>>> missing code check the camac function D16/D24 <<<<<<<<<<<<<< */

/* -------------------------------------------------------------------- */
/* - UI2/4_read ------------------------------------------------------- */
/*.crl  : camread b c n a f of <data_type> */
/**/
/**/
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#define UI2_CAMREAD(b,c,n,a,f) {\
        cdreg (&ext,b,c,n,a);\
	cfsa  (f,ext,&localA,&dumstat);\
        *(++((UI2_var*) (*dabufp))) = *((UI2_var*)localA);}

#define UI4_CAMREAD(b,c,n,a,f) {\
        cdreg (&ext,b,c,n,a);\
	cssa  (f,ext,&localA,&dumstat);\
        *(++(*dabufp)) = *(localA); }

/* -------------------------------------------------------------------- */
/* - UI2/4_copy ------------------------------------------------------- */
/*.crl  : copy <var> of <data_type>  */
/**/
/**/
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#define UI2_COPY(localA) {\
        *(++((UI2_var*) (*dabufp))) = *((UI2_var*)localA);}

#define UI4_COPY(localA) {\
        *(++(*dabufp)) = *(localA);}

/* -------------------------------------------------------------------*/
/* - reset_1190 ----------------------------------------------------- */

/*.crl	: reset_1190 <vme_add> */
/*	  - <vme_add> : VME address of the fpp register */

/*example: reset_1190 PCOS    <- FPP_PCOS = 0x7c0000 */

/*Function: */
/* read first memory location for setting the address pointer */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#define RESET_1190(vme_add){\
  sysBusToLocalAdrs(mode, addr, &localA);\
  u32dummy = *(uint_16*)localA;}\

/* -------------------------------------------------------------------*/
/* - enable_fpp ------------------------------------------------------ */

/*.crl	: enable_fpp <vme_add> */
/*	  - <vme_add> : VME address of the fpp register */

/*example: enable_fpp FPP_PCOS    <- FPP_PCOS = 0x7f0002 */

/*Function: */
/* write 1 into the Write_ONLY register for Front_Panel_Port operation */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#define ENABLE_FPP(vme_add){\
  sysBusToLocalAdrs(mode, addr, &localA);\
  *(uint_16*)localA = 1;}\

/* - disable_1190 ------------------------------------------------------ */

/*.crl	: disable_fpp <vme_add> */
/*	  - <vme_add> : VME address of the fpp register

/*example: disable_fpp FPP_PCOS    <- FPP_PCOS = 0x7f0002 */

/*Function: */
/* write 0 into the Write_ONLY register for VME_bus access */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#define DISABLE_FPP(vme_add){\
  sysBusToLocalAdrs(mode, addr, &localA);\
  *(uint_16*)localA = 0;}\

/* -------------------------------------------------------------------*/
/* - ceopen ---------------------------------------------------------- */

/*.crl	: open event type <ev_type> of <bank_type> */

/*	  - <ev_type>   : Event type 1-15 Physics, 21-... others */
/*	  - <bank_type> : UI2 , UI4, UB1, BANK */

/*example	: open event type 41 of bank  */

/*Function: */
/* open a CODA event with ROC data bank format */
/* leaves dabufp pointing to next long */
/* keep pointer to length of bank in GblTopEp for length adjustment */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#define CEOPEN(etype, btype) {\
	GblTopEp = *dabufp;\
        *(++(*dabufp)) = (((etype) << 16) | (btype##_ty) << 8);}
	(*dabufp)++;}

/* -------------------------------------------------------------------*/
/* - ceclose --------------------------------------------------------- */

/*.crl	: close event */

/*Function: */
/* Close a CODA event created by "ceopen" */
/* leaves the dabufp pointing to next empty long after event */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#define CECLOSE() {\
         *GblTopEp  = *dabufp - *GblTopEp  ;\
	 *dabufp = 0;}

/* - cbopen ---------------------------------------------------------- */

/*.crl	: open bank <bank_name> of <bank_type> */

/*	  - <bank_name> : converted in bnum through Bank_Dic_ID */
/*	  - <bank_type> : UI2 , UI4, UB1 */

/*example	: open bank FBUS of UI2 */

/*call	: cbopen (long bnum, long btype); */

/*Function: */
/* open a CODA bank with CODA Bank Header Format */
/* leaves dabufp pointing to ready next address */
/* keep pointer to length of bank in GblTopBp for length adjustment */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#define CBOPEN(bnum, btype) {\
	GblTopBp = *dabufp;\
        *(++(*dabufp)) = (((bnum) << 16) | (btype##_ty) << 8);\
	(*dabufp)++;}
      
/* -------------------------------------------------------------------*/
/* - cbclose --------------------------------------------------------- */

/*.crl	: close bank <buff_len> of <bank_type> */
/*	  - <bank_type> : UI2 , UI4, UB1 */
/*	  - <buff_len>  : number of "bank_type" word written */

/*example	: close bank bank_len of UI2 */

/*Call	: cbclose (btype, &buflen); */

/*Function: */
/* Close a CODA bank created by "cbopen" */
/* leaves the dabufp pointing to next empty long after bank */
/* returns the actual length of that bank */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#define CBCLOSE(buflen,btype) {\
         *buflen = (unsigned long) (((char *) *dabufp) - ((char *) GblTopBp));\
	 if (*buflen&1 != 0) {\
                        *dabufp = ((unsigned long *)((char *) *dabufp)+1);\
                        *buflen += 1;\
                      };\
         if (*buflen&2 !=0) {\
                        *buflen = *buflen + 2;\
                        ((unsigned short *) *dabufp)++;\
                      };\
	 *buflen = (*buflen>>2) - 1;\
	 *GblTopBp = *buflen;}

			       
/* -------------------------------------------------------------------*/
/* - UI2/UI4_read_1190 ----------------------------------------------- */
/* .crl	: VMREAD_1190 <vme_add> of <bank_type> max <max_buff_len>*/
/*      - <bank_type>    : UI2 , UI4, UB1 */
/*      - <vme_add>      : VME address of the top_add of the data buffer */
/*                         expect counter register offset by +0x8000 */
/*      - <max_buff_len> : maximum number of "bank_type" word to be readout*/
/* example: vmeread_1190 from hex 0x7f0000 max 120 of UI2 */
/* call	: UI2_read_1190 (long vme_add, long mxblen); */
/* Function: - am : address modifier : frozen to 0x3d from caller*/
/* UI2 */
/* Performs a equivalent block transfer of up to mxblen lower words */
/* from the vme_1190 into a 16bit arrangement of dabuf */
/* b1190p should be the number of long words */
/**/
/*  to retrieve the upper word of the 1190                   */
/*    *(((UI2_var*) (*dabufp))++) = *(((UI2_var*)b1190p)++); */
/**/
/* UI4 */
/* Performs a equivalent block transfer of up to mxblen long words */
/* from the vme_1190 into dabuf */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

uint_32 dummyCount[122]={1,2,2*32769,4,5,6,7,8,9,10,11,12,13,14,15,16};/* GH */
uint_16 dylen = 10;
				
void UI2_vmeread_1190 ( uint_32 vme_add, uint_32 mxblen)
{
uint_32 *b1190p;
uint_16 *l1190p;
/*  sysBusToLocalAdrs ( 0x2d, (vme_add+0x8000), &l1190p); */
  l1190p = &dylen;                                   /* GH */

  if (*l1190p <= mxblen) mxblen = *l1190p;
  GblCnt = mxblen;

/*  sysBusToLocalAdrs ( 0x3d, vme_add, &b1190p); */
  b1190p = dummyCount;                                          /* GH */

  while ( mxblen--)
  {
/* read buffer lowD16 increment A32, increment dabuf in A16 */
/*  to retrieve the lower word */
    *(((UI2_var*) (*dabufp))++) = *(++((UI2_var*)b1190p));
    ((UI2_var*)b1190p)++;

/* read buffer highD16 increment A32, increment dabuf in A16 */
/*  to retrieve the upper word */
/*    *(++((UI2_var*)(*dabufp)))=*((UI2_var*)b1190p); */
/*    b1190p++; */
  }
}
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

uint_32 dummiCount[122]={1,3*32769,3,4,5,6,7,8,9,10,11,12,13,14,15,16};/* GH */
uint_16 dilen = 14;

void UI4_vmeread_1190 ( uint_32 vme_add , uint_32 mxblen)
{
  uint_32 *b1190p;
  uint_16 *l1190p;  
/* get the number of words to be readout D16*/
/*  sysBusToLocalAdrs (0x2d , (vme_add+0x8000) , &l1190p); */
  l1190p = &dilen;                                 /* GH */

  if ( *l1190p <= mxblen) mxblen = *l1190p;
  GblCnt = mxblen;
/* read buffer D32 increment A24, increment dabuf in A32 */  
/*  sysBusToLocalAdrs ( 0x3d, vme_add, &b1190p); */
  b1190p = dummiCount;                                        /* GH */

  while (mxblen--)
  {
    *((*dabufp)++) = *(b1190p++);
  }
}
/* -------------------------------------------------------------------- */
/* - name --------------------------------------------------------- */
/**/
/**/
/**/
/**/
/**/
/**/
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
#endif


