#ifndef __CAMAC_LAM__

#define __CAMAC_LAM__

static int LAM_handlers[256],LAMflag; /* NOTE 256 = 8 crates + 32 sltations per crate. */
static int LAM_address[256];
static unsigned char LAM_isAsync[256],fcode,dumstat;

void LAM_handler(int thelam)
{
  theIntHandler(LAM_handlers[thelam]);
}

static int LAM_TEST (int code){
  int stat;
  ctlm(LAM_address[code],&stat);
  return(stat);
}

#define LAM_INIT { bzero((char *) LAM_handlers, sizeof(LAM_handlers));bzero((char *) LAM_isAsync, sizeof(LAM_isAsync));}

#define LAM_ENCODE(c,n) ((c)*32+(n))

#define LAM_ASYNC(c,n,id) {int ext,code;code=LAM_ENCODE(c,n);\
                               printf("linking LAM %d to trig source id %d\n",code,id); \
                               cdreg(&ext,0,c,n,0);LAM_address[code]=ext;  ccgl (ext, 0);\
			       cclnk(ext,LAM_handler);LAM_handlers[code] = (id);LAM_isAsync[code] = 1;}

#define LAM_SYNC(c,n,id) {{int ext,code;code=LAM_ENCODE(c,n); \
                              printf("linking code %d to id %d\n",code,id); \
                              cdreg(&ext,0,c,n,0);LAM_address[code]=ext;\
			      LAM_handlers[code] = (id);LAM_isAsync[code] = 0;}

#define LAM_SETA(c,n) {code = LAM_ENCODE(c,n);theIntHandler(LAM_handlers[code]);}

#define LAM_SETS(c,n) LAMflag = LAM_ENCODE(c,n);;

#define LAM_ENA(c,n) {int code = LAM_ENCODE(c,n);cccd (LAM_address[code], 1);ccrgl(LAM_address[code]);ccgl (LAM_address[code], 1);}


#define LAM_DIS(c,n) {int code = LAM_ENCODE(c,n);ccgl (LAM_address[code], 0);cccd (LAM_address[code], 0);}


#define LAM_CLRS(c,n) LAMflag = 0;

#define LAM_GETID(c,n) LAM_handlers[LAM_ENCODE(c,n)]

#define LAM_START(c,n)   {int code = LAM_ENCODE(c,n);cclc (LAM_address[code]);ccci (LAM_address[code], 0);}
	

#define LAM_STOP(c,n)   {int code = LAM_ENCODE(c,n);ccci (LAM_address[code], 1);}


#define LAM_LAM  LAM_doLAM

#endif
/* End  LAM trigger source */

