/* CBOPEN  == OPEN  BANK <bank_name> of <bank_type>  */
/* CBCLOSE == CLOSE BANK <bank_len>  of <bank_type>  */

/* - BankTools.h ---------------------------------------------------------- */
#ifndef _Bank_Tools_h
#define _Bank_Tools_h

/* Param : */

#define BT_BANK_ty 0x10
#define BT_UB1_ty  0x07
#define BT_UI2_ty  0x05
#define BT_UI4_ty  0x01

#define BC_RUNCONTROL 0xCC
#define CURRENT_TIME time(0)
#define RUN_NUMBER rol->runNumber
#define RUN_TYPE   rol->runType
#define EVENT_NUMBER evnb

#define MAX_DEPTH__ 32 

long *StartOfEvent[MAX_DEPTH__],event_depth__;

/* Macro : */


#define NEWEVENT {if(__the_event__ == (NODE *) 0) \
		    { \
			partGetItem(rol->pool,__the_event__); \
			rol->dabufp = (long *) &__the_event__->data[1]; \
		    } \
		}


/* - cbopen ---------------------------------------------------------- 
   crl	: open bank <bank_name> of <bank_type>
   - <bank_name> : converted in bnum through Bank_Dic_ID 
   - <bank_type> : UI2 , UI4, UB1 
   
   example	: open bank 0x1234 of UI2 
   
   call	: cbopen (long bnum, long btype); 
   
   Function: 
   open a CODA bank with CODA Bank Header Format 
   leaves (rol->dabufp) pointing to ready next address 
   keep pointer to length of bank in GblTopBp for length adjustment 
   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#define CBOPEN(bnum, btype, code) {\
				     long *StartOfBank; \
				     NEWEVENT; \
				     StartOfBank = (rol->dabufp); \
				       *(++(rol->dabufp)) = (((bnum) << 16) | (btype##_ty) << 8) | (code);\
					 ((rol->dabufp))++;
				   
#define CEOPEN(bnum, btype) {\
			       NEWEVENT; \
			       StartOfEvent[event_depth__++] = (rol->dabufp); \
			       *(++(rol->dabufp)) = (((bnum) << 16) | (btype##_ty) << 8) | (0xff & evnb);\
			       ((rol->dabufp))++;}
				     
/* - cbclose --------------------------------------------------------- 
crl	: close bank <buff_len> of <bank_type> 
- <bank_type> : UI2 , UI4, UB1 
- <buff_len>  : number of "bank_type" word written 

example	: close bank

Call	: cbclose (btype, &buflen); 

Function: 
Close a CODA bank created by "cbopen" 
leaves the (rol->dabufp) pointing to next empty long after bank 
returns the actual length of that bank 
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#define CBCLOSE \
         *StartOfBank = (long) (((char *) (rol->dabufp)) - ((char *) StartOfBank));\
	 if ((*StartOfBank & 1) != 0) {\
                        (rol->dabufp) = ((long *)((char *) (rol->dabufp))+1);\
                        *StartOfBank += 1;\
                      };\
         if ((*StartOfBank & 2) !=0) {\
                        *StartOfBank = *StartOfBank + 2;\
                        (rol->dabufp) = ((long *)((short *) (rol->dabufp))+1);;\
                      };\
	 *StartOfBank = ( (*StartOfBank) >> 2) - 1;};

#define CECLOSE {event_depth__--;\
         *StartOfEvent[event_depth__] = (long) (((char *) (rol->dabufp)) - ((char *) StartOfEvent[event_depth__]));\
	 if ((*StartOfEvent[event_depth__] & 1) != 0) {\
                        (rol->dabufp) = ((long *)((char *) (rol->dabufp))+1);\
                        *StartOfEvent[event_depth__] += 1;\
                      };\
         if ((*StartOfEvent[event_depth__] & 2) !=0) {\
                        *StartOfEvent[event_depth__] = *StartOfEvent[event_depth__] + 2;\
                        (rol->dabufp) = ((long *)((short *) (rol->dabufp))+1);;\
                      };\
	 *StartOfEvent[event_depth__] = ( (*StartOfEvent[event_depth__]) >> 2) - 1;};

#define CBWRITE32(dat) {*(rol->dabufp)++ = (dat);}
#define CBWRITE16(dat) {*((short *) rol->dabufp)++ = (dat);}
#define CBWRITE8(dat)  {*((char  *)rol->dabufp)++ = (dat);}

#define CBPOINTER (rol->dabufp)
#endif
