/*************************************************************************
** PROGRAM FB_STRIP  				S. W. Kent June 12,1992	**
**									**
** DESCRIPTION								**
**									**
** globally replaces strings in stdin and rewrite to stdout		**
**									**
** strings replaced:							**
**									**
**	=====		with 		\n#				**
**	.....		with		\n				**
** 									**
**************************************************************************
** DEFINITIONS Global							**
**									**	
**************************************************************************
** INCLUDE Files							**
**									*/
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

/************************************************************************/
/* Predefined macro tokens use in lookup				*/
/*									*/
#define FBS_MAXTOKEN	2			/* maximum tokens parsed */
#define FBS_MAXLINE	40000			/* maximum line length */

char *fbs_tokens[] = {"=====",
		      "....."};			/* string tokens */
char *fbs_subst[]  = {"\n#",
		      "\n"};			/* replacement strings */
int fbs_toklength[FBS_MAXTOKEN];		/* length of token strings*/

void fbs_puts(char *string,int newline_flag);
char *fbs_get_first_token(char *string, int *index);

main()
{
int		i;				/* counter */
int		index;				/* index in token arrays */
int		gottoken = 0;			/* found a token flag */
char		*string_start;			/* start of input string */
char		*string;			/* pointer in input string*/
char		*location;			/* location of token */

/* malloc the space for the input string
   ------------------------------------- */

   if (!(string_start = (char *) malloc (FBS_MAXLINE)))
	{
	perror("fb_strip could not malloc\n");
	exit(1);
	}

/* get string length of tokens 
   --------------------------- */

   for (i=0; i<FBS_MAXTOKEN; i++) fbs_toklength[i] = strlen(fbs_tokens[i]);

/* let's read every line until we reach end of file
   ------------------------------------------------ */

   while (gets(string_start))
   	{

     /* parse the string, finding all occurances of the tokens
        ------------------------------------------------------ */

   	for (gottoken = 0, string = string_start; 
	     location = fbs_get_first_token (string, &index);
	     string = location + fbs_toklength[index])
	   {
	   gottoken = 1;		/*at least one token was found*/
	   strcpy(location,fbs_subst[index]);	/*overwrite token*/
	   fbs_puts(string,0);			/* output string */
	   }
	 	
	if (gottoken)				/* we had found a token */
	   {fbs_puts(string,0);printf("\n");}	/* output last segment */

     /* Put comments around line directives 
	----------------------------------- */

	else if (string_start[0] == '#' && 	
		 strlen(string_start) > 2)
	   {
	   if (!strtol(&string_start[2],0,0))
		fbs_puts(string_start,1);
	   else
		printf ("/* %s */\n",string_start);
	   }
	else 					/* remove extra blank lines */
	   {	
	   if (strspn (string_start," \t") != 
	        strlen (string_start))		/* look for white space */
	    	fbs_puts (string_start,1);	/*characters found, write line*/
	   }
	}
exit(0);
}
/* fbs_puts								**
**									**
** DESCRIPTION								**
**									**
**	outputs the string. If the length is longer than 80 characters, **
**	writes it out on multiple lines.				**
**									**
** ARGUMENTS								**
**									**
**	char	*string		string to output			**
**	int	newline_flag	flag to specify not to put a newline    **
*/

int fbs_instring = 0;			/* total count of " found */

void fbs_puts(string,newline_flag)
char	*string;
int	newline_flag;
{
int maxlength = 80;			/* ideal max string length */
char *word;				/* word */
int length = 0;				/* accumlative legth of line */
int word_length;			/* length of word */
int i;					/* counter */
int just_found = 0;			/* just found a " */

/* the output string is already less than the max line length. 
   Just output it.
   ----------------------------------------------------------- */

if ((strlen(string) < maxlength) || (string[0] == '#'))
   {
   if (newline_flag)
      puts(string);
   else
      for (i = 0; i < strlen(string); i++) putchar(string[i]);  /*out segment */
   return;
   }

/* we will output a word at time until we reach the max requested line 
   length. Upon reaching the max line length, we will output a new line
   unless we are in the middle of a string literal (ie, "") 
   -------------------------------------------------------------------- */

for (word = strtok(string," "); word != NULL; word = strtok(NULL," "))
   {
   word_length = strlen(word);
   for (i=0; i<word_length; i++) 
	{
	if (word[i] == '"') {fbs_instring++; just_found = 1;}
	else just_found = 0;
	}
   if ((length+=word_length)>maxlength && !(fbs_instring & 1) && !just_found)
 	{
	printf("\n");
	length = 0;
	}
   printf("%s ",word);
   }
}
/* fbs_get_first_token							**
**									**
** DESCRIPTION								**
**									**
**	Finds the location of the first token in the string.		**
**	It will return the location of the token, NULL if the		**
**	token is not found.						**
**									**
** ARGUMENTS								**
**									**
**	char	*string		string to search			**
**	int	*index		index of the token found 		**
*/

char *fbs_get_first_token (string, index)
char 	*string;				/* string to search */
int 	*index;					/* index of token found */
{
int	i;					/* counter */
char 	*temp_string;				/* temp string pointer */
int	length;					/* string length */

/* Look for the first tokens in the string.

   Did this in a more convulated way than necessary for performance reasons.
   Scan all characters in the string to see if any match the first 
   character of one of the token strings. If so, do a strcmp to see
   if it really is the full token string.
   --------------------------------------------------------------------- */

   length = strlen(string);		
   for (temp_string = string; temp_string < string + length; temp_string++)
	{
	for (i = 0; i < FBS_MAXTOKEN; i++)	/* do for all tokens */
	   {
	   if (fbs_tokens[i][0] == *temp_string)
	      {
	      if (!(strncmp(fbs_tokens[i],temp_string,fbs_toklength[i])))
		 {
		 *index = i;
		 return(temp_string);
		 }
	      }
           }
	}

   return (NULL);
}
