/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *     header file for CODA readout language symbol hash table
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: crlHash.h,v $
 *   Revision 1.1.1.1  1996/08/21 19:20:51  heyes
 *   Imported sources
 *
*	  Revision 1.1  94/03/16  10:00:50  10:00:50  heyes (Graham Heyes)
*	  Initial revision
*	  
*	  Revision 1.1  93/10/27  09:29:24  09:29:24  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  
 */
#ifndef _crl_hash_h
#define _crl_hash_h

typedef struct _symbol{
  char *var_name;
  int  var_type;      /*0: integer, 1: unsigned long */
}CrlSymbol;

typedef struct _SLOT_ENTRY
{
 CrlSymbol         crlSymbol;
 struct _SLOT_ENTRY *next;
}symbolEntry;

extern char *strdup();

extern void crlHashCreate();
extern int  crlHashAdd();
extern int  crlHashDelete();
extern int  crlHashFind();
extern int  crlHashDestroy();
extern void crlAddSymbols();
extern void isSymbolFound();
#endif
