//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      CODA Run Control request object class
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: codaRequestObject.h,v $
//   Revision 1.4  2003/10/15 15:42:00  abbottd
//   Fix cast of findAction function
//
//   Revision 1.3  1999/07/28 20:10:09  rwm
//   Jie Chen-s changes for latest rcServer
//
//   Revision 1.2  1997/02/03 13:47:28  heyes
//   add ask command
//
//   Revision 1.1.1.1  1996/10/11 13:39:32  chen
//   run control source
//
//
#ifndef _CODA_REQUEST_OBJECT_H
#define _CODA_REQUEST_OBJECT_H

#include <cdevSystem.h>
#include <cdevRequestObject.h>

typedef struct _state_string
{
  char *string;
  int  state;
}codaStateString;

// default timeout in seconds
#define CODA_DEFAULT_TIMEOUT 4

class rcClient;
class cdevTranObj;
class codaMonObj;
class codaService;

typedef struct _coda_attr
{
  char *attrName;
  int  attrValue;
}codaAttr;

class codaRequestObject: public cdevRequestObject
{
public:
  // constructor and destructor
  codaRequestObject (char* device,
		     char* msg,
		     codaService* svc,
		     cdevSystem& system = cdevSystem::defaultSystem());
  ~codaRequestObject (void);

  int setContext (cdevData& cxt);
  // PURPOSE: set io context to this request object.
  //          Redefine setContext inherited from cdevIOcontext
  // REQUIRE: nothing
  // PROMISE: value tag will be always set, return CDEV_SUCCESS

  int send (cdevData& out, cdevData& result);
  int send (cdevData *out, cdevData& result);
  int send (cdevData& out, cdevData* result);
  int send (cdevData *out, cdevData* result);
  // PURPOSE: Synchronous IO operations "get", "set", "monitorOn/off"
  // REQUIRE: When set, out must be supplied. When get result must be provided
  // PROMISE: return CDEV_SUCCESS: success. 
  //          There will be no synchronous monitorOn.

  int sendNoBlock (cdevData& out, cdevData& result);
  int sendNoBlock (cdevData* out, cdevData& result);
  int sendNoBlock (cdevData& out, cdevData* result);
  int sendNoBlock (cdevData* out, cdevData* result);
  // PURPOSE: Asynchronous IO operations used in conjunction with cdevGroup or system
  // REQUIRE: When set, out must be supplied. When get result must be provied.
  //          Caller must call system.pend or group.pend to flush out network
  //          requests.
  // PROMISE: return CDEV_SUCCESS: requests have been sent out. 

  int sendCallback (cdevData& out, cdevCallback& callback);
  int sendCallback (cdevData* out, cdevCallback& callback);
  // PURPOSE: Asynchromous IO operations with a user supplied callback function
  // REQUIRE: When set, out must be provided.
  // PROMISE: User callback function will be called with status information
  //          status = CDEV_DISCONNECTED: channel discconected
  //          status = CDEV_SUCCESS     : everything is OK
  //          status = CDEV_RECONNECTED : channel reconnected
  //          status = CDEV_ERROR       : something fishy. 

  int getState (void);
  // PURPOSE: get connection state
  // REQUIRE: none
  // PROMISE: CDEV_CONNECTED or CDEV_NOTCONNECTED

  const char *className (void) const {return "codaRequestObject";}

protected:
  // enumerated value for ca request data type
  static enum {VALUE = 1, STATUS = 4, TIMESTMP = 8, GRINFO = 16, 
	       CTRLINFO = 0x00001000} caEnumTag_;
  // static channel acccess attribute
  static codaAttr codaAttributes[];
  static int      numAttributes;  
  
  // action value
  static enum {GET = 0x1000, SET, MONITOR_ON,
	       MONITOR_OFF, LOAD, CONFIGURE, 
	       DOWNLOAD, PRESTART, PAUSE, RESUME, END, RESET, GO, ABORT,
	       DISCONNECT, CONNECTED, CONNECT, STATE, NEW_STATE,ASK,MSG,
	       UNKNOWN} codaEnumVerb_;

  // some useful functions
  int         getValueCbk     (cdevTranObj* xobj);
  int         setValueCbk     (cdevTranObj* xobj);
  // state information 
  int         stateValueCbk   (cdevTranObj* xobj);
  // different command callbacks 
  int         sendCommandCbk  (int command, cdevTranObj* xobj);
  // change state command callbacks
  int         changeStateCbk  (int command, cdevTranObj* xobj);
  // new state transitione callback
  int         newStateCbk     (int command, cdevTranObj* xobj);

  int         monitorValue    (codaMonObj*  xobj);
  int         monitorOffValue (cdevCallback* cbk);

  // all default callbacks
  static void defaultGetCallback (int status, void* arg, daqNetData* data);
  static void defaultSetCallback (int status, void* arg, daqNetData* data);
  static void defaultCmdCallback (int status, void* arg, daqNetData* data);
  static void defaultMonCallback (int status, void* arg, daqNetData* data);
  static void defaultMonOffCallback (int status, void* arg, daqNetData* data);
  static void defaultStateCallback  (int status, void* arg, daqNetData* data);

  // data conversion function from daqNetData to cdevData
  static void convertData (daqNetData& data,
			   int tag,
			   int reqMask,
			   int reqType,
			   cdevData& resData);
  // data conversion function from cdevData to daqData
  static int  convertData (cdevData& data,
			   char* compname,
			   char* attrname,
			   daqData* &qdata);

  static codaStateString states[];
  static int             numStates;

private:
  // find out action and attribute from message
  static int findAction (char* msg, int& action, char* &attr);
  // find service data i.e. readonly and so on
  int findSvcData (char* device, char* msg, cdevSystem& system);

  // cached device name
  char* device_;
  // attribute name associated with this device name
  char* attr_;
  // action type
  int action_;
  // readonly flag
  int readonly_;
  // real client pointer
  rcClient* codaClient_;
  // request mask and type
  int reqMask_;
  int reqType_;
};
#endif

  
