//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
// CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
//       coda@cebaf.gov  Tel: (804) 249-7030     Fax: (804) 249-5800
//-----------------------------------------------------------------------------
//
// Description:
//      RunControl Daq Data Trigger Class
//      This class will server as a trigger for daqData to trigger something
//      to happen (Abstract Class)
//
// Author:  
//      Jie Chen
//      CEBAF Data Acquisition Group
//
// Revision History:
//   $Log: daqDataTrigger.h,v $
//   Revision 1.1.1.1  1996/10/11 13:39:30  chen
//   run control source
//
//
#ifndef _CODA_DAQDATA_TRIGGER_H
#define _CODA_DAQDATA_TRIGGER_H

#include <stdio.h>
#include <string.h>
#include <assert.h>

class daqData;

class daqDataTrigger
{
public:
  // trigger function: default is empty
  virtual void trigger (daqData* data);
  
  virtual ~daqDataTrigger (void);

protected:
  daqDataTrigger (void);
};
#endif


