import java.io.*;

/**
 * @author timmer
 *
 * Java provides a deprecated getenv, but we'll make our own.
 */
public class UnixEnvironment {

    public static String getenv(String env) {
	String result = null;

	try {
	    java.lang.Process p = Runtime.getRuntime().exec("printenv " + env);
	    p.waitFor();
	    BufferedInputStream bis = new BufferedInputStream(p.getInputStream());
	    int bytes = bis.available() - 1;
	    if (bytes > 0) {
		byte[] b = new byte[bytes];
		bis.read(b, 0, bytes);
		result = new String(b);
		bis.close();
		return result;
	    }
	    bis.close();
	}
	catch (IOException ex) {
	}
	catch (InterruptedException ex) {
	}

	return result;
    }

}
