/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Support routines for the FASTBUS RPC server
 *	
 * Author:  David Abbott, TJNAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: fbSrvrLib.c,v $
 *   Revision 1.1  1998/04/15 13:57:16  abbottd
 *   Initial Revision
 *
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include "fbRpc.h"
#include "fb.h"


#ifdef VXWORKS
unsigned long fpbr_mem_offset = 0;
extern int sysLocalToBusAdrs();
extern unsigned long fb_frdb_1();

void rpcTaskInit();

/* vxServerInit() must be called on VxWorks CPUs before any RPC
   library routines are called */
void vxServerInit()
{
  (void) rpcTaskInit();
}
#endif


int *fb_rpcfbinit_1(arg)
     unsigned long *arg;
{
  static int r, s;
  (void) fb_init_1(*arg);

/* determine memory offset for block reads */
  s = sysLocalToBusAdrs(0x09,0,&fpbr_mem_offset);
  if (s != 0) {
    fpbr_mem_offset = 0;
    printf("fbSrvr: ERROR in sysLocalToBusAdrs() call: status = 0x%x\n",s);
  }else{
    printf("fbSrvr: fpbr_mem_offset = 0x%x\n",fpbr_mem_offset);
  }

  return(&r);
}

int *fb_rpcfbreset_1(arg)
     int *arg;
{
  static int r;
  (void) sfi_error_decode(*arg);
  return(&r);
}

int *fb_rpcfpac_1(arg)
     FB_PS *arg;
{
  static unsigned long r;
  r = fpac(arg->pa,arg->sa);
  return((int *)&r);
}

int *fb_rpcfpad_1(arg)
     FB_PS *arg;
{
  static unsigned long r;
  r = fpad(arg->pa,arg->sa);
  return((int *)&r);
}

int *fb_rpcfprel_1()
{
  static unsigned long r;
  r = fprel();
  return((int *)&r);
}

int *fb_rpcfpr_1()
{
  static unsigned long r;
  r = fpr();
  return((int *)&r);
}

int *fb_rpcfpw_1(arg)
     int *arg;
{
  static unsigned long r;
  r = fpw(*arg);
  return((int *)&r);
}

int *fb_rpcfpsaw_1(arg)
     int *arg;
{
  static unsigned long r;
  r = fpsaw(*arg);
  return((int *)&r);
}

FB_SD *fb_rpcfprc_1(arg)
     FB_PS *arg;
{
  static FB_SD r;
  r.status = fprc(arg->pa,arg->sa,&(r.data));
  return(&r);
}

int *fb_rpcfpwc_1(arg)
     FB_PSD *arg;
{
  static unsigned long r;
  r = fpwc(arg->pa,arg->sa,arg->data);
  return((int *)&r);
}

FB_SD *fb_rpcfprd_1(arg)
     FB_PS *arg;
{
  static FB_SD r;
  r.status = fprd(arg->pa,arg->sa,&(r.data));
  return(&r);
}

int *fb_rpcfpwd_1(arg)
     FB_PSD *arg;
{
  static unsigned long r;
  r = fpwd(arg->pa,arg->sa,arg->data);
  return((int *)&r);
}

FB_SD *fb_rpcfprcm_1(arg)
     FB_PS *arg;
{
  static FB_SD r;
  r.status = fprcm(arg->pa,arg->sa,&(r.data));
  return(&r);
}

int *fb_rpcfpwcm_1(arg)
     FB_PSD *arg;
{
  static unsigned long r;
  r = fpwcm(arg->pa,arg->sa,arg->data);
  return((int *)&r);
}

FB_SD *fb_rpcfprdm_1(arg)
     FB_PS *arg;
{
  static FB_SD r;
  r.status = fprdm(arg->pa,arg->sa,&(r.data));
  return(&r);
}

int *fb_rpcfpwdm_1(arg)
     FB_PSD *arg;
{
  static unsigned long r;
  r = fpwdm(arg->pa,arg->sa,arg->data);
  return((int *)&r);
}

FB_SLD *fb_rpcfpbr_1(arg)
     FB_PS *arg;
{
  static FB_SLD r;
  static int lenb = ((MAX_DATA_BLOCK-1)<<2);
  static unsigned long buf, rb;

  buf = ((int) &r.data[0]) + fpbr_mem_offset;
  if (arg->sa > 0)
    r.status = fb_frdb_1(arg->pa,arg->sa,buf,lenb,&rb,1,0,1,0,0x0a,0,0,1);
  else
    r.status = fb_frdb_1(arg->pa,0,buf,lenb,&rb,1,0,0,0,0x0a,0,0,1);

  if(r.status != 0) {
    r.len = 0;
  }else{
    r.len = rb>>2;
  }
  return(&r);
}
