#include <stdio.h>
#include <rpc/rpc.h>
#include "fbRpc.h"

static void fbsrvr_1();

main()
{
	SVCXPRT *transp;

	(void)pmap_unset(FBSRVR, FBVERS);

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		(void)fprintf(stderr, "cannot create tcp service.\n");
		exit(1);
	}
	if (!svc_register(transp, FBSRVR, FBVERS, fbsrvr_1, IPPROTO_TCP)) {
		(void)fprintf(stderr, "unable to register (FBSRVR, FBVERS, tcp).\n");
		exit(1);
	}
	svc_run();
	(void)fprintf(stderr, "svc_run returned\n");
	exit(1);
}

static void
fbsrvr_1(rqstp, transp)
	struct svc_req *rqstp;
	SVCXPRT *transp;
{
	union {
		int fb_rpcfbinit_1_arg;
		int fb_rpcfbreset_1_arg;
		FB_PS fb_rpcfpac_1_arg;
		FB_PS fb_rpcfpad_1_arg;
		int fb_rpcfpw_1_arg;
		int fb_rpcfpsaw_1_arg;
		FB_PS fb_rpcfprc_1_arg;
		FB_PSD fb_rpcfpwc_1_arg;
		FB_PS fb_rpcfprd_1_arg;
		FB_PSD fb_rpcfpwd_1_arg;
		FB_PS fb_rpcfprcm_1_arg;
		FB_PSD fb_rpcfpwcm_1_arg;
		FB_PS fb_rpcfprdm_1_arg;
		FB_PSD fb_rpcfpwdm_1_arg;
		FB_PS fb_rpcfpbr_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void)svc_sendreply(transp, xdr_void, (char *)NULL);
		return;

	case FB_RPCFBINIT:
		xdr_argument = xdr_int;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfbinit_1;
		break;

	case FB_RPCFBRESET:
		xdr_argument = xdr_int;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfbreset_1;
		break;

	case FB_RPCFPAC:
		xdr_argument = xdr_FB_PS;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfpac_1;
		break;

	case FB_RPCFPAD:
		xdr_argument = xdr_FB_PS;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfpad_1;
		break;

	case FB_RPCFPREL:
		xdr_argument = xdr_void;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfprel_1;
		break;

	case FB_RPCFPR:
		xdr_argument = xdr_void;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfpr_1;
		break;

	case FB_RPCFPW:
		xdr_argument = xdr_int;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfpw_1;
		break;

	case FB_RPCFPSAW:
		xdr_argument = xdr_int;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfpsaw_1;
		break;

	case FB_RPCFPRC:
		xdr_argument = xdr_FB_PS;
		xdr_result = xdr_FB_SD;
		local = (char *(*)()) fb_rpcfprc_1;
		break;

	case FB_RPCFPWC:
		xdr_argument = xdr_FB_PSD;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfpwc_1;
		break;

	case FB_RPCFPRD:
		xdr_argument = xdr_FB_PS;
		xdr_result = xdr_FB_SD;
		local = (char *(*)()) fb_rpcfprd_1;
		break;

	case FB_RPCFPWD:
		xdr_argument = xdr_FB_PSD;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfpwd_1;
		break;

	case FB_RPCFPRCM:
		xdr_argument = xdr_FB_PS;
		xdr_result = xdr_FB_SD;
		local = (char *(*)()) fb_rpcfprcm_1;
		break;

	case FB_RPCFPWCM:
		xdr_argument = xdr_FB_PSD;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfpwcm_1;
		break;

	case FB_RPCFPRDM:
		xdr_argument = xdr_FB_PS;
		xdr_result = xdr_FB_SD;
		local = (char *(*)()) fb_rpcfprdm_1;
		break;

	case FB_RPCFPWDM:
		xdr_argument = xdr_FB_PSD;
		xdr_result = xdr_int;
		local = (char *(*)()) fb_rpcfpwdm_1;
		break;

	case FB_RPCFPBR:
		xdr_argument = xdr_FB_PS;
		xdr_result = xdr_FB_SLD;
		local = (char *(*)()) fb_rpcfpbr_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		(void)fprintf(stderr, "unable to free arguments\n");
		exit(1);
	}
}

