/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	xcefdmp x window tree related routines
 *	
 * Author:  Jie Chen
 *          CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xevent_tree.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  Revision 1.2  1995/03/16  19:39:02  chen
 *	  handle change of DIALOG structure
 *
 *	  Revision 1.1  1994/12/08  17:25:48  chen
 *	  Initial revision
 *
 *	  
 */
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <TreeCODA.h>

#include "xcef_layout.h"

/*
 * private data for this tree display,only 
 * recycle limited number of push buttons
 */
static Widget cx[MAX_NODE];             /* pushbuttons inside tree widget */
static int    num_of_node = 0;          /* num of pushbuttons in the tree */
static int    prev_num_of_node = 0;     /* num of pbutton in previous stp */
static int    partial_tree_display = 0; /* show partial tree              */
static int    show_two_levels = 0;      /* show only two levels           */
static int    show_all_levels = 0;      /* show complete tree             */
int           show_tree_mode = 0;       /* show star or fork tree         */
static evTreeNode *curr_root = (evTreeNode *)0; 
                                        /* current evTreeNode structure   */

/**************************************************************************
 *       static void pop_down_shell ()                                    *
 * Description:                                                           *
 *     Callback function of 'close' button for text dialog shell          *
 *************************************************************************/
static void pop_down_shell(w, client_data, cbs)
Widget              w;
XtPointer           client_data;
XmAnyCallbackStruct *cbs;
{
  int   i,j;
  char  *name = (char *)client_data;
  Widget parent= XtParent(XtParent(XtParent(w)));

  for(i=0;i<MAX_LEAF_NODE;i++){
    if((strcmp(d_shell[i].name, name)) == 0)
      break;
  }

  d_shell[i].count= 0;
  d_shell[i].map_or_not = 0;
  d_shell[i].mask_value = 0xffffffff;
  d_shell[i].rshift_bit = 0;
  d_shell[i].mask_mode = 0;
  if (d_shell[i].buffer != NULL)
    free(d_shell[i].buffer);
  d_shell[i].buffer = (char *)0;

  if(d_shell[i].type == 0xF){  /* release anything assocaiated with oxF*/
    for(j=0;j<MAX_LEAF_NODE;j++){
      if(rm[j].used == 1 && strcmp(d_shell[i].name,rm[j].name) == 0){
	rm[j].used = 0;
	break;
      }
    }
  }
  XtDestroyWidget(parent);
  d_shell[i].dialog_shell = (Widget)0;
  d_shell[i].mask_shell = (Widget)0;
  /* free memory */
  free (name);
}

/**************************************************************************
 *         static void output_v( )                                        *
 * Description:                                                           *
 *     Popup a text window containing text information about the nodes    *
 *************************************************************************/
static void output_v (buffer, base, n, name, title, type, x, y)
char     *buffer;       /* allocated space */
Widget   base;
int      n;
char     *name, *title; /* need to free memory */
Position x, y; 
int      type;
{
  Widget   out_rc, text_w, action_form;
  Widget   action0, action1;
  Arg      wargs[20];
  char     msg[80];
  Position xt,yt;
  int      i, ac = 0;
  DIALOG   *passing;

  for(i=0; i<MAX_LEAF_NODE; i++){ /* looking for a matched shell */
    if((strcmp(d_shell[i].name, name)) == 0)
      break; 
  }

  if(i < MAX_LEAF_NODE){ /* there is a match */
    if(d_shell[i].count != 0 && d_shell[i].map_or_not == 1){
      XtSetArg(wargs[ac],XmNx,&xt); ac++;
      XtSetArg(wargs[ac],XmNy,&yt); ac++;
      XtGetValues(d_shell[i].dialog_shell,wargs,ac);
      ac = 0;
      XtDestroyWidget(d_shell[i].dialog_shell);
      d_shell[i].dialog_shell = (Widget)0; /* make sure it is clean */
      d_shell[i].mask_shell = (Widget)0;
      d_shell[i].count = 0;
      d_shell[i].map_or_not = 0;
      d_shell[i].mask_value = 0xffffffff;
      d_shell[i].rshift_bit = 0;
      d_shell[i].mask_mode = 0;
      if(d_shell[i].buffer != NULL){
	free (d_shell[i].buffer);
      }
      d_shell[i].buffer = (char *)0;
      output_v (buffer,base,n,name,title,type,xt,yt);        
      return;
    }
  }
  
  /* if there is no match */
  if(d_shell[n].count == 1){  /* already used by other shell*/
    for(i=0;i<MAX_LEAF_NODE;i++){
      if(d_shell[i].count ==0)
	break;
    }
    n = i;  /* choose a new n*/
   }
  d_shell[n].count = 1;
  d_shell[n].map_or_not = 1;
  d_shell[n].type = type;
  strcpy (d_shell[n].name, name);

  sprintf(msg,"%s:%s",name,title);
  XtSetArg(wargs[ac],XmNtitle,msg); ac++;
  XtSetArg(wargs[ac],XmNx,x); ac++;
  XtSetArg(wargs[ac],XmNy,y); ac++;
  
  d_shell[n].dialog_shell=XtCreatePopupShell("text_sh",xmDialogShellWidgetClass,
					     sw, wargs, ac);
  ac = 0;
  out_rc=XtCreateWidget("out_rc",xmFormWidgetClass,d_shell[n].dialog_shell,NULL,0);
  
  XtSetArg(wargs[ac],XmNscrollVertical,         TRUE); ac++;
  XtSetArg(wargs[ac],XmNscrollHorizontal,       FALSE); ac++;
  XtSetArg(wargs[ac],XmNeditMode,               XmMULTI_LINE_EDIT); ac++;
  XtSetArg(wargs[ac],XmNrows,                   10); ac++;
  XtSetArg(wargs[ac],XmNcolumns,                48); ac++;
  XtSetArg(wargs[ac],XmNeditable,               FALSE); ac++;
  XtSetArg(wargs[ac],XmNwordWrap,               TRUE); ac++;
  XtSetArg(wargs[ac],XmNautoShowCursorPosition, TRUE); ac++;
  XtSetArg(wargs[ac],XmNcursorPosition,         FALSE); ac++;
  XtSetArg(wargs[ac],XmNvalue,                  buffer); ac++;
  XtSetArg(wargs[ac],XmNmarginHeight,           0); ac++;
  XtSetArg(wargs[ac],XmNmarginWidth,            0); ac++;
  d_shell[n].text_w=(Widget)XmCreateScrolledText(out_rc,"text_out",wargs,ac);
  XtManageChild(d_shell[n].text_w);
  ac = 0;
  
  XtSetArg(wargs[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(wargs[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(wargs[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetValues(XtParent(d_shell[n].text_w), wargs, ac); ac++;
  ac = 0;

  XtSetArg(wargs[ac], XmNfractionBase,     40); ac++;
  XtSetArg(wargs[ac], XmNtopAttachment,    XmATTACH_NONE); ac++;
  XtSetArg(wargs[ac], XmNleftAttachment,   XmATTACH_FORM);  ac++;
  XtSetArg(wargs[ac], XmNrightAttachment,  XmATTACH_FORM); ac++;
  XtSetArg(wargs[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  action_form = XtCreateManagedWidget("action_form",
				      xmFormWidgetClass,
				      out_rc,wargs, ac);
  ac = 0;

  XtSetArg(wargs[ac], XmNtopAttachment,     XmATTACH_FORM); ac++;
  XtSetArg(wargs[ac], XmNbottomAttachment,  XmATTACH_FORM); ac++;
  XtSetArg(wargs[ac], XmNleftAttachment,    XmATTACH_FORM); ac++;
  XtSetArg(wargs[ac], XmNleftOffset,        5); ac++;
  action0 =(Widget)XtCreateManagedWidget("Close",
					 xmPushButtonWidgetClass,
					 action_form,wargs,ac);
  ac = 0;

  XtSetArg(wargs[ac], XmNtopAttachment,     XmATTACH_FORM); ac++;
  XtSetArg(wargs[ac], XmNbottomAttachment,  XmATTACH_FORM); ac++;
  XtSetArg(wargs[ac], XmNrightAttachment,   XmATTACH_FORM); ac++;
  XtSetArg(wargs[ac], XmNrightOffset,       5); ac++;
  action1 =(Widget)XtCreateManagedWidget("Mask",
					 xmPushButtonWidgetClass,
					 action_form,wargs, ac);
  ac = 0;

  if (d_shell[n].buffer != NULL){
    free (d_shell[n].buffer);
  }
  d_shell[n].buffer = buffer;
  passing = &(d_shell[n]);

  if(type != 0x1)
    XtSetSensitive(action1, FALSE);
  else
    XtAddCallback(action1,XmNactivateCallback,pop_value_mask, passing);
  XtAddCallback(action0,XmNactivateCallback, pop_down_shell, (XtPointer)name);
  
  XtSetArg(wargs[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg(wargs[ac], XmNbottomWidget, action_form); ac++;
  XtSetValues(XtParent(d_shell[n].text_w), wargs, ac);
  ac = 0;
   
  XtManageChild(out_rc);
  /* free memory for title but not for name  
     which has been passed to callback,
     it will be freed upon destruction of
     this dialog shell               
   */
  free (title);
  XtPopup(d_shell[n].dialog_shell,XtGrabNone);
}

/**************************************************************************
 *         static visit_tree ()                                           *
 * Description:                                                           *
 *     Convert a tree structure into an array representation              *
 *************************************************************************/
static void visit_tree(root,i,node,parent)
evTreeNode *root;
int        *i;
XNODE      node[];
Widget     parent;
{
  evTreeNode *p,*q,*qq;
  int n,level = 0, num_children = 0;

  q = p =root;
  n= *i;
  if(p !=NULL){
    node[n].p = p;
    node[n].nc = n;
    while(q->parent != NULL){
      level++;
      q = q->parent;
    }
    node[n].level = level+1;
    q = p;
    if(q->mleft != NULL){
      for(qq = q->mleft; qq != NULL; qq=qq->rsibling)
	num_children++;
    }
    node[n].num_children = num_children;
    *i = *i +1;
    visit_tree(p->mleft,i,node,parent);
    visit_tree(p->rsibling,i,node,parent);
  }
}
  

/**************************************************************************
 *         static void view_content()                                     *
 * Description:                                                           *
 *     Pushbutton inside tree widget callback                             *
 *************************************************************************/
static void view_content(w,tree_node,cbs)
Widget w;
XNODE  *tree_node;
XmPushButtonCallbackStruct *cbs;
{
  int               i, nc;
  char              temp[4],temp8[8],temp2[2];
  int               header1,header2;
  char              *buffer, *p;
  char              *t_name, *t_title;
  evTreeNode        *root, *ptr;
  XNODE             node[MAX_NODE];
  int               nn, t_num_of_node;
  unsigned short    thead;
  Dimension         height, height1, height2;
  Position          x,y;
  Arg               wargs[10];
  FORMAT            *format[100];
  int               format_num; /*format number in format array*/
  int               format_len; /*format des length in 16 bit wird*/


  ptr = tree_node->p;
  nc = tree_node->nc;

  if(ptr->mleft != NULL && !is_string_empty(TAG)){  /* contains children */
    report_message("Not a leaf node", 0);
    return;
  }
  else if(ptr->mleft !=NULL && ptr->parent != NULL && 
	  is_string_empty(TAG)){
    if(view_mode == 0){
      root = ptr;
      root->rsibling = (evTreeNode *)0;
      root->parent = (evTreeNode *)0;
      show_tree (root);
    }
  }
  else if(ptr->parent == NULL && ptr->mleft != NULL && 
	  is_string_empty(TAG)) {/* current root*/
    if(view_mode == 0){
      bufcpy (temp,ev);
      header1 = *(int *)(temp)+1;
	  
      root = EvTreeConstruct(ev,0xC,header1);
      nn = 0;
      visit_tree(root,&nn,node,NULL);
	  
      t_num_of_node = nn;
      for(i=0;i<t_num_of_node;i++){
	if((is_same_node(node[i].p,ptr)) ==0)  /* we have match*/
	  break;                                 
      }
      if(i == 0){
	report_message("This is the root node", 0);
	return;
      }
      root = node[i].p->parent;
      root->rsibling = NULL;
      root->parent = NULL;

      if(curr_root){
	free_ev_tree (curr_root);
	curr_root = 0;
      }
      curr_root = root;
      show_tree(root);
    }
  }
  else{                        /* a leaf node */
    switch(ptr->type){
    case 0x0:
      report_message("Unknown data type", 1);
      if(hex_or_decimal == 0){
	hex_or_decimal = 1;
	XtSetArg(wargs[0],XmNset,False);
	XtSetValues(hex_op0,wargs,1);
	XtSetArg(wargs[0], XmNset, TRUE);
	XtSetValues(hex_op1, wargs, 1);
      }
      if(ptr->parent_type == 0x10){         /* bank type*/
	i = ptr->start;
	i = i+4;
	buffer = (char *)malloc(13*((ptr->length)-2)+1);
      }
      else{                           /*segment */
	i = ptr->start;
	i = i+2;
	buffer = (char *)malloc(13*((ptr->length)-1)+1);
      }
      get_ascii_buffer(ev,ptr,i,buffer);
      break;
    case 0x30: /*packet with unknow data type*/
      report_message("Unknown data type", 1);
      if(hex_or_decimal == 0){
	hex_or_decimal = 1;
	XtSetArg(wargs[0],XmNset,False);
	XtSetValues(hex_op0,wargs,1);
	XtSetArg(wargs[0], XmNset, TRUE);
	XtSetValues(hex_op1, wargs, 1);
      }
      i = ptr->start;
      i++;
      buffer = (char *)malloc(13*((ptr->length)-1)+1);
      get_ascii_buffer(ev,ptr,i,buffer);
      break;
    case 0x1:      /* 32 bit int*/
      if(ptr->parent_type == 0x10){         /* bank type*/
	i = ptr->start;
	i = i+4;
	buffer = (char *)malloc(7*((ptr->length)-2)+1);
      }
      else{        /*segment */
	i = ptr->start;
	i = i+2;
	buffer = (char *)malloc(7*((ptr->length)-1)+1);
      }

      get_ascii_buffer(ev,ptr,i,buffer);
      break;
    case 0x3:
      if(ptr->parent_type == 0x10){         /* bank type*/
	i = ptr->start;
	i = i+4;
	buffer = (char *)malloc(2*(ptr->length + 1)*sizeof(char));
      }
      else{                     /*segment */
	i = ptr->start;
	i = i+2;
	buffer = (char *)malloc(2*(ptr->length + 1)*sizeof(char));
      }
      
      get_ascii_buffer(ev,ptr,i,buffer);
      break;
    case 0x4:
    case 0x5:
      if(ptr->parent_type == 0x10){         /* bank type*/
	i = ptr->start;
	i = i+4;
	buffer = (char *)malloc(13*((ptr->length)-2)+1);
      }
      else{                            /*segment */
	i = ptr->start;
	i = i+2;
	buffer = (char *)malloc(13*((ptr->length)-1)+1);
      }
      get_ascii_buffer(ev,ptr,i,buffer);
      break;
    case 0x33:  /*packet with short word*/
      i = ptr->start;
      i++;
      buffer = (char *)malloc(2*((ptr->length)-1)+1);
      get_ascii_buffer(ev,ptr,i,buffer);
      break;
    case 0x34:  /*packet with short int*/
    case 0x35:
      i = ptr->start;
      i++;
      buffer = (char *)malloc(13*((ptr->length)-1)+1);
      get_ascii_buffer(ev,ptr,i,buffer);
      break;
    case 0xF:
      for(i=0;i<100;i++)
	format[i] = (FORMAT *)malloc(1*sizeof(FORMAT));
      for(i=0;i<MAX_LEAF_NODE;i++)
	if(rm[i].used == 0)  /*find first available*/
	  break;
	    
      rm[i].used = 1;
      strcpy(rm[i].name, ptr->name);
      copy_evnode_value(ptr,rm[i].p);
      
      parse_format(ev,ptr,format,&format_num,&format_len);
	    
      i = ptr->start;
      if(ptr->parent_type == 0x10)
	i = i + 4;
      else
	i = i + 2;

      i = i + format_len;

      buffer = (char *)malloc(13*(ptr->length));
      sprint_item(ev,ptr,i,format,format_num,buffer);
      break;
    default:
      buffer = (char *)malloc(100);
      sprintf(buffer,"Wrong data type\n");
      break;
    }
    XtSetArg(wargs[0],XmNheight,&height);   
    XtGetValues(tree,wargs,1);
    
    XtSetArg(wargs[0],XmNheight,&height1);
    XtGetValues(sw,wargs,1);
    
    if(w != NULL){ /* take care of update content from show_tree routine*/
      XtSetArg(wargs[0],XmNheight,&height2);
      XtGetValues(w,wargs,1);
    }
    else
      height2 = 0;
	
    if(height1 < height)
      height = height1;
    XtTranslateCoords(sw,(Position)(0),(Position)(height+height2),&x,&y);
    /* Copy name and title information, tree_node will be deallocated
     * by free_ev_tree routine. Bummmer
     */
    t_name = strsave(ptr->name);
    t_title = strsave (ptr->title);
    /******************************************/
    output_v(buffer,sw,nc,t_name, t_title,
	     ptr->type,x,y);
    return;
  }   
}


/**************************************************************************
 *         void clean_tree ( )                                            *
 * Description:                                                           *
 *     Reset X window Tree Widget resources to default values             *
 *     and reset all pushbuttons callbacks and label to default values    *
 *     This routine is used in the case from displaying one event to      *
 *     next                                                               *
 *************************************************************************/
void clean_tree ()
{
  int i, ac = 0;
  Arg args[5];
  XtCallbackRec *callback;

  XtUnmanageChildren (cx, prev_num_of_node);
  XtUnmanageChild (tree);

  XcodaResetTreeConstraints(tree);
  for(i = 0;i < prev_num_of_node; i++){
    /* Clean up all memory registerd to callbacks */
    XtSetArg (args[ac], XmNactivateCallback, &callback); ac++;
    XtGetValues (cx[i], args, ac);
    ac = 0;
    /* Here I cleaned out memory I allocated before XtAddCallback */
    free (callback->closure);
    
    XtRemoveAllCallbacks(cx[i],XmNactivateCallback);
    if(partial_tree_display){
      XtSetArg(args[ac], XmNbackground, normal_bg); ac++;
      XtSetValues(cx[i], args, ac);
      ac = 0;
    }
    XcodaResetTreeChildResource(cx[i]);
  }
}  

/***************************************************************************
 *                 static void update_content()                            *
 * Description:                                                            *
 *     Update content of text to the dialog shell indexed by integer       *
 *     This usually happens when one goes from one event to next with      *
 *     same node appears in the two events                                 *
 **************************************************************************/
static void update_content(tree_node,n)
XNODE  *tree_node;
int    n;
{
  int        i, header1,header2;
  char       *buffer,*p,temp[4],temp2[2],temp8[8];
  char       *buffer1;
  Arg        wargs[10];
  int        ac = 0;
  FORMAT     *format[100];
  evTreeNode *ptr;
  int        format_num; /*format number in format array*/
  int        format_len; /*format des length in 16 bit wird*/

  ptr = tree_node->p;
  free (tree_node);

  switch(ptr->type){
  case 0x0:
    if(hex_or_decimal == 0){
      hex_or_decimal = 1;     /* force option menu to use hex_dump */
      XtSetArg(wargs[ac],XmNset,False); ac++;
      XtSetValues(hex_op0,wargs, ac);
      ac = 0;
      XtSetArg(wargs[ac], XmNset, TRUE); ac++;
      XtSetValues(hex_op1, wargs, ac);
      ac = 0;
    }
    if(ptr->parent_type == 0x10){         /* bank type*/
      i = ptr->start;
      i = i+4;
      buffer = (char *)malloc(12*((ptr->length)-2)+1);
    }
    else{                            /*segment */
      i = ptr->start;
      i = i+2;
      buffer = (char *)malloc(12*((ptr->length)-1)+1);
    }
    get_ascii_buffer(ev,ptr,i,buffer);
    break;
  case 0x30:
    if(hex_or_decimal == 0){
      hex_or_decimal = 1;     /* force option menu to use hex_dump */
      XtSetArg(wargs[ac],XmNset,False); ac++;
      XtSetValues(hex_op0, wargs, ac);
      ac = 0;
      XtSetArg(wargs[ac], XmNset, TRUE); ac++;
      XtSetValues(hex_op1, wargs, ac);
      ac = 0;
    }
    i = ptr->start;
    i = i + 1;
    buffer = (char *)malloc(13*((ptr->length)-1)+1);
    get_ascii_buffer(ev,ptr,i,buffer);
    break;
  case 0x1:      /* 32 bit int*/
    if(ptr->parent_type == 0x10){         /* bank type*/
      i = ptr->start;
      i = i+4;
      buffer = (char *)malloc(7*((ptr->length)-2)+1);
    }
    else{                            /*segment */
      i = ptr->start;
      i = i+2;
      buffer = (char *)malloc(7*((ptr->length)-1)+1);
    }
    get_ascii_buffer(ev,ptr,i,buffer);
    break;
  case 0x3:
    if(ptr->parent_type == 0x10){         /* bank type*/
      i = ptr->start;
      i = i+4;
      buffer = (char *)malloc((ptr->length+1)*2*sizeof(char));
    }
    else{                            /*segment */
      i = ptr->start;
      i = i+2;
      buffer = (char *)malloc((ptr->length + 1)*2*sizeof(char));
    }
    get_ascii_buffer(ev,ptr,i,buffer);
    break;
  case 0x4:
  case 0x5:
    if(ptr->parent_type == 0x10){         /* bank type*/
      i = ptr->start;
      i = i+4;
      buffer = (char *)malloc(13*((ptr->length)-2)+1);
    }
    else{                            /*segment */
      i = ptr->start;
      i = i+2;
      buffer = (char *)malloc(13*((ptr->length)-1)+1);
    }
    get_ascii_buffer(ev,ptr,i,buffer);
    break;
  case 0x33:  /*packet with short word*/
    i = ptr->start;
    i++;
    buffer = (char *)malloc(2*((ptr->length)-1)+1);
    get_ascii_buffer(ev,ptr,i,buffer);
    break;
  case 0x34:  /*packet with short int*/
  case 0x35:
    i = ptr->start;
    i++;
    buffer = (char *)malloc(13*((ptr->length)-1)+1);
    get_ascii_buffer(ev,ptr,i,buffer);
    break;	    
  case 0xF:
    for(i=0;i<100;i++)
      format[i] = (FORMAT *)malloc(1*sizeof(FORMAT));
    for(i=0;i<MAX_LEAF_NODE;i++){
      if(rm[i].used == 1 && strcmp(d_shell[n].name,rm[i].name) == 0){
	copy_evnode_value(ptr,rm[i].p);
	break;
      }
    }
    parse_format(ev,ptr,format,&format_num,&format_len);
    
    i = ptr->start;
    if(ptr->parent_type == 0x10)
      i = i + 4;
    else
      i = i + 2;
    
    i = i + format_len;
    
    buffer = (char *)malloc(13*(ptr->length));
    sprint_item(ev,ptr,i,format,format_num,buffer);
    break;
  default:
    buffer = (char *)malloc(100);
    sprintf(buffer,"Wrong data type\n");
    break;
  }

/* update buffer to text_w in d_shell[n] */
  if(d_shell[n].buffer != (char *)0){
    free(d_shell[n].buffer);
  }
  d_shell[n].buffer = (char *)0;
  d_shell[n].buffer = buffer;
  if(d_shell[n].type == 0x1){
    if(d_shell[n].mask_value != 0xffffffff || d_shell[n].rshift_bit != 0){
      buffer1 = applyMaskToIntBuffer(buffer, d_shell[n].mask_value, 
				     d_shell[n].rshift_bit,
				     d_shell[n].mask_mode);
      XmTextSetString(d_shell[n].text_w, buffer1);	  
      XtFree (buffer1);
    }
    else{
      XmTextSetString(d_shell[n].text_w, buffer);
    }
  }
  else
    XmTextSetString(d_shell[n].text_w,buffer);
}

/***************************************************************************
 *                 static void update_dialog_text_shell( )                 *
 * Description:                                                            *
 *     Update Text content dialog shell depending upon the name of         *
 *     the node. If a shell with the same name already up, it will         *
 *     stay up, othersise it will be unmapped                              *
 **************************************************************************/
static void update_dialog_text_shell (node, num)
XNODE node[];
int   num;
{
  int   j, k;
  XNODE *t_node;

  for(j = 0;j < MAX_LEAF_NODE; j++){
    for(k = 0; k < num; k++){ /* only looking for leaf nodes */
      if((strcmp(d_shell[j].name, node[k].p->name)) == 0 && 
	 node[k].p->mleft == NULL)
	break;
    }
      
    if(k >= num){    /* no match*/
      if(d_shell[j].dialog_shell != NULL && d_shell[j].count == 1
	 && (XtIsRealized(d_shell[j].dialog_shell)) == True
	 && d_shell[j].map_or_not == 1){
	d_shell[j].map_or_not = 0;
	/* Free Text content inside this shell */
	if(d_shell[j].buffer != NULL)
	  free(d_shell[j].buffer);
	d_shell[j].buffer = (char *)NULL;
	XtUnmapWidget(d_shell[j].dialog_shell);
      }
    }
    else{  /* Match a shell */
      if(d_shell[j].dialog_shell != NULL && d_shell[j].count == 1 
	 && (XtIsRealized(d_shell[j].dialog_shell)) == True){
	if(d_shell[j].map_or_not == 1){ /* Shell already up */
	  d_shell[j].type = node[k].p->type;
	  t_node=(XNODE *)malloc(sizeof(XNODE));
	  t_node->nc = node[k].nc;
	  t_node->p = node[k].p;
	  if(d_shell[j].buffer != NULL)
	    free (d_shell[j].buffer);

	  d_shell[j].buffer = (char *)0;
	  update_content (t_node, j); 
	}
	else{
	  d_shell[j].type = node[k].p->type;
	  d_shell[j].map_or_not = 1;
	  if(d_shell[j].buffer != NULL)
	    free (d_shell[j].buffer);

	  d_shell[j].buffer = (char *)0;
	  XtMapWidget(d_shell[j].dialog_shell);
	  t_node=(XNODE *)malloc(sizeof(XNODE));
	  t_node->nc = node[k].nc;
	  t_node->p = node[k].p;
	  update_content(t_node,j); 
	}
      }
    }
  }
  /* end of for loop */
}

/***************************************************************************
 *             static void update_xtree_node_info ()                       *
 * Description:                                                            *
 *    Update a pushbutton inside the tree widget with name and constraint  *
 *    information. This routine will be called by show_tree routine.       *
 **************************************************************************/
static void update_xtree_node_info(node, buttons, num_btns)
XNODE  node[];
Widget buttons[];
int    num_btns;
{
  int      j, k;
  Arg      args[20];
  int      ac = 0;
  XNODE    *t_node;
  XmString t;

  for(j = 1; j < num_btns; j++){
    for(k = 0; k < num_btns; k++){
      if(node[j].p->parent == node[k].p)
	break;
    }
    if(partial_tree_display && !show_all_levels){
      if(node[k].folded == 0){  /* parent of this node is not folded */
	switch(node[j].level){
	case 2:
	  if(show_two_levels){
	    if(node[j].num_children > 0)
	      node[j].folded = 1;
	    else
	      node[j].folded = 0;
	  }
	  else{
	    if(node[j].num_children >= 5)
	      node[j].folded = 1;
	    else
	      node[j].folded = 0;
	  }
	  break;
	case 3:
	  if(node[j].num_children >= 4)
	    node[j].folded = 1;
	  else
	    node[j].folded = 0;
	  break;
	case 4:
	  if(node[j].num_children >= 3)
	    node[j].folded = 1;
	  else
	    node[j].folded = 0;
	  break;
	default:
	  if(node[j].num_children >= 2)
	    node[j].folded = 1;
	  else
	    node[j].folded = 0;
	  break;
	}
	if(node[j].folded == 1){
	  t=XmStringCreateSimple(node[j].p->name);       
	  XtSetArg(args[0],XcodaNsuperNode, buttons[k]);
	  XtSetArg(args[1],XmNlabelString,  t);
	  XtSetArg(args[2],XmNbackground, fold_bg);
	  XtSetValues(buttons[j],args,3);
	  XmStringFree(t);
	}
	else{
	  t=XmStringCreateSimple(node[j].p->name);       
	  XtSetArg(args[0],XcodaNsuperNode,buttons[k]);
	  XtSetArg(args[1],XmNlabelString,t);
	  XtSetValues(buttons[j],args,2);
	  XmStringFree(t);	       
	}
	t_node=(XNODE *)malloc(sizeof(XNODE));
	t_node->nc = node[j].nc;
	t_node->p = node[j].p;
	/* t_node memory will be freed inside clean_tree */
	XtAddCallback(buttons[j],XmNactivateCallback,view_content, t_node);
	XtManageChild(buttons[j]);
      }
      else
	node[j].folded = 1;
    }
    else{  /* display whole tree */
      t=XmStringCreateSimple(node[j].p->name);       
      XtSetArg(args[0],XcodaNsuperNode,buttons[k]);
      XtSetArg(args[1],XmNlabelString,t);
      XtSetValues(buttons[j],args,2);
      XmStringFree(t); 
      
      t_node=(XNODE *)malloc(sizeof(XNODE));
      t_node->nc = node[j].nc;
      t_node->p = node[j].p;
      /* t_node memory will be freed inside clean_tree */
      XtAddCallback(buttons[j],XmNactivateCallback, view_content, t_node);
    }
  }
  
  if(!partial_tree_display || show_all_levels)
    XtManageChildren(buttons,num_btns);
}

/***************************************************************************
 *                 void show_tree (root)                                   *
 * Description:                                                            *
 *    Show Tree Display of a given evTreeNode Data Structure               *
 **************************************************************************/
void show_tree(root)
evTreeNode *root;
{
  int        i, j, k, m, ac = 0;
  XNODE      node[MAX_NODE];
  XNODE      *t_node;
  evTreeNode *p;
  Arg        args[20];
  XmString   t;
   
  if(prev_num_of_node != 0)
    clean_tree();

  i = 0;
  p = root;
  visit_tree (p,&i,node,tree);
  num_of_node = i;
  if(num_of_node > prev_num_of_node){
    /* Create new node for tree widget */
    for(j = prev_num_of_node; j < num_of_node; j++){
      XtSetArg(args[ac], XmNbackground, normal_bg); ac++;
      cx[j] = XtCreateWidget("t_node",	xmPushButtonWidgetClass,tree,
			     args ,ac);
      ac = 0;
    }
  }
  if(num_of_node < prev_num_of_node){
    /* throw away unused widgets */
    for(j=num_of_node; j < prev_num_of_node; j++){
      XtDestroyWidget(cx[j]);
      cx[j] = (Widget)0;
    }
  }
  prev_num_of_node = num_of_node;

  if(num_of_node > 50)  /* too many tree nodes, don't show leaf */
    partial_tree_display = 1;
  else
    partial_tree_display = 0;

  /* update dialog text content shells */
  update_dialog_text_shell (node, num_of_node);
   
  /* update label of the root node pushbutton */
  t=XmStringCreateSimple(node[0].p->name);
  XtSetArg (args[0], XmNlabelString, t);
  XtSetValues (cx[0], args, 1);
  XmStringFree (t);

  /* create a pointer to point to a XNODE structure and pass to callback proc. */
  node[0].folded = 0;
  t_node=(XNODE *)malloc(sizeof(XNODE));
  t_node->nc = node[0].nc;
  t_node->p = node[0].p;
  XtAddCallback(cx[0],XmNactivateCallback,view_content,t_node);
  XtManageChild(cx[0]);

  /* update single push button resources and displaying labels */
  update_xtree_node_info (node, cx, num_of_node);

  XtManageChild(tree);
}

/**************************************************************************
 *       void  next_prev_tree ( )                                         *
 * Description:                                                           *
 *     Show Next or Previous Tree Structure when one click on the button  *
 *     Make sure previous evTreeNode *root freed here                     *
 *************************************************************************/
void next_prev_tree (root)
evTreeNode *root;
{
  int   i, j;
  XNODE node[MAX_NODE];
  char  message[128];

  if(curr_root)
    free_ev_tree (curr_root);
  curr_root = root;

/*  i = 0;
  visit_tree(root, &i,node,NULL);    
  num_of_node = i; */

  if(!is_string_empty(TAG)){
    i = 0;
    visit_tree(root,&i,node,NULL); /* root was tree-name-matched before, no more*/
    num_of_node = i;
    
    for(j=0;j<num_of_node;j++){
      if((strcmp(TAG,node[j].p->name)) == 0)
	break;
    }
    if(j >=num_of_node){
      sprintf(message,"Cannot find this tag in the event %d\n",evn+1);
      report_message(message, 1);
      clean_tree();
      return;
    }
    else{
      root=node[j].p;
      root->rsibling = 0;
      root->parent = 0;
      show_tree(root);
      return;
    }
  }
  else
    show_tree(root);               
}

/************************************************************************************
 *                 void mode_change_reset ()                                        *
 * Description:                                                                     *
 *     When one click on view button, change view mode from view a file to spy      *
 *     an event, One has to release oold memory and set everything to default       *
 *     value                                                                        *
 ***********************************************************************************/
void mode_change_reset()
{
  int i;
  Arg arg[5];
  int ac = 0;

  XmTextSetString(text_in3,"");
  XmTextSetString(text_in2,"");
  XmTextSetString(text_in0,"");

  if(!is_string_empty (TAG)){
    empty_string(TAG);
  }
  if(!is_string_empty (SOURCE)){
    empty_string(SOURCE);
  }
  /* allow all dialog_shell can be used , ie. erase old memory */
  for(i=0; i<MAX_LEAF_NODE; i++){
    rm[i].used = 0;
    strcpy(rm[i].name, "-JIE");
    if(d_shell[i].count == 1 && d_shell[i].dialog_shell != NULL
       && (XtIsRealized(d_shell[i].dialog_shell)) == True){
      d_shell[i].count = 0;
      d_shell[i].map_or_not = 0;
      d_shell[i].mask_value = 0xffffffff;
      d_shell[i].rshift_bit = 0;
      d_shell[i].mask_mode = 0;
      if(d_shell[i].buffer != NULL){
	free (d_shell[i].buffer);
      }
      d_shell[i].buffer = (char *)0;
      XtDestroyWidget(d_shell[i].dialog_shell);
      d_shell[i].dialog_shell = (Widget)0;
      d_shell[i].mask_shell = (Widget)0;
    }
    else{
      d_shell[i].count = 0;
      d_shell[i].map_or_not = 0;
      d_shell[i].mask_value = 0xffffffff;
      d_shell[i].rshift_bit = 0;
      d_shell[i].mask_mode = 0;
      if(d_shell[i].buffer != NULL){
	free (d_shell[i].buffer);
      }
      d_shell[i].buffer = (char *)0;
      d_shell[i].dialog_shell = (Widget)0;
    }
  }
  XmTextSetString(text_in3,"");
/* clean up tree then create another */
  clean_tree();
  XtSetArg (arg[ac], XmNwidth, 100); ac++;
  XtSetArg (arg[ac], XmNheight, 100); ac++;
  XtSetValues (tree, arg, ac);
  ac = 0;
/*  XtDestroyWidget(tree);
  num_of_node = prev_num_of_node = 0;
  tree=(Widget)XtCreateManagedWidget("tree",xcodaTreeWidgetClass,sw,NULL,0);*/
}


/**************************************************************************************
 *                     void tree_disp_mode ()                                         *
 * Description:                                                                       *
 *     Callbacks for view_options menu which will determines tree_display mode        *
 *************************************************************************************/
void tree_disp_mode(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmAnyCallbackStruct *cbs;
{
  int pb = (int)client_data;
  Arg args[5];
  int ac = 0;

  if(pb == 0){  /* star tree button */
    if(show_tree_mode != 0){
      XtSetArg(args[ac], XcodaNtreeType, XcodaTILTREE); ac++;
      XtSetValues(tree, args, ac);
      ac = 0;
      if(dict_shell != NULL && XtIsRealized(dict_shell)){
	XtSetArg(args[ac], XcodaNtreeType, XcodaTILTREE); ac++;
	XtSetValues(dict_tree, args, ac);	
	ac = 0;
      }
      show_tree_mode = 0;
    }
  }
  else if(pb == 1){    /* fork tree button */
    if(show_tree_mode != 1){
      XtSetArg(args[ac], XcodaNtreeType, XcodaRECTREE); ac++;
      XtSetValues(tree, args, ac);
      ac = 0;
      if(dict_shell != NULL && XtIsRealized(dict_shell)){
	XtSetArg(args[ac], XcodaNtreeType, XcodaRECTREE); ac++;
	XtSetValues(dict_tree, args, ac);
	ac = 0;
      }
      show_tree_mode = 1;
    }
  }
  else if(pb == 2){    /* show 2 levels */
    if(show_two_levels)
      return;
    else{
      show_two_levels = 1;
      show_all_levels = 0;
      if(partial_tree_display)
	show_tree(curr_root);
    }
  }
  else if(pb == 3){    /* show all levels */
    if(show_all_levels)
      return;
    else{
      show_two_levels = 0;
      show_all_levels = 1;
      if(partial_tree_display)
	show_tree(curr_root);
    }
  }
  else{                /* reset to default */
    if(!show_two_levels  && !show_all_levels)
      return;
    show_all_levels = 0;
    show_two_levels = 0;
    if(partial_tree_display)
      show_tree(curr_root);
  }
}

/*************************************************************************************
 *               void disp_tree_dict_mode ( )                                        *
 * Description:                                                                      * 
 *     Show x tree upon the change of dictionary enable/disble mode                  *
 ************************************************************************************/
void disp_tree_dict_mode(root)
evTreeNode *root;
{
  int   nn, i, node_number;
  XNODE node[MAX_NODE];

  if (curr_root){
    nn = 0;
    visit_tree(root, &nn, node, NULL);
    node_number = nn;

    for(i=0;i<node_number;i++){
      if((is_same_node(node[i].p, curr_root)) == 0) /* we have match */
	break;
    }
    /* free old memory */
    free_ev_tree (curr_root);
    curr_root = 0;

    root = node[i].p;
    root->rsibling = 0;
    root->parent = 0;
    curr_root = root;
    show_tree(root);
  }
  else{
    curr_root = root;
    show_tree (root);
  }
}
