/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	xcefdmp xwindow misc routines
 *	
 * Author:  Jie Chen
 *           CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef_xmisc.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  
 */
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/DialogS.h>

#include "xcef_layout.h"

/*******************************************************************
 *    void pop_error_message (err, base)                           *
 * Description:                                                    *
 *      Output fatal error message                                 *
 ******************************************************************/
void pop_error_message(er, base)
char *er;
Widget base;
{
  Widget dialog;
  XmString t= XmStringCreateSimple(er);
  Arg args[2];
    
  XtSetArg(args[0], XmNmessageString,t);
  dialog=(Widget)XmCreateErrorDialog(base,"error",args,1);
  XtSetSensitive((Widget)XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON),FALSE);
  XtUnmanageChild((Widget)XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));
  XtManageChild(dialog);
  XmStringFree(t);


  XtPopup(XtParent(dialog),XtGrabNone);
}  

/*********************************************************************
 *               void report_message (message, type)                 *
 * Description:                                                      *
 *     Report vital warning message to a message area                *
 ********************************************************************/
void report_message(msg, type)
char *msg;
int  type;  /* 0: info, 1, warning, 2: error */
{
  char temp[256];
  Arg  args[5];
  int  ac = 0;
  static XmTextPosition wpr_position = 0;

  if (type == 0)
    strcpy(temp,"Info   -> ");
  else if (type == 1)
    strcpy(temp,"Warning-> ");
  else
    strcpy(temp,"Error  -> ");
  strcat(temp,msg);
  strcat(temp,"\n");

  XmTextInsert (msg_win, wpr_position, temp);
  wpr_position += strlen (temp);
  XtSetArg (args[ac], XmNcursorPosition, wpr_position); ac++;
  XtSetValues (msg_win, args, ac);
  ac = 0;
  XmTextShowPosition (msg_win, wpr_position);
}

/**********************************************************************
 *            int conv_tag_int (tag_value, tag_name)                  *
 * Description:                                                       *
 *     Convert a tag name to a tag value                              *
 *********************************************************************/
int conv_tag_int(tag_value,tag_name)
int *tag_value;
char *tag_name;
{
  int  suc;

  if(strstr(tag_name,"0x") != 0){
    suc = sscanf(tag_name,"0x%x",tag_value);
    if(suc <= 0){
      pop_error_message("Illegal Syntax in Tag input !",text_in2);
      return 1;
    }
  }
  else if(strstr(tag_name,"0X") != 0){
    suc = sscanf(tag_name,"0X%x",tag_value);
    if(suc <= 0){
      pop_error_message("Illegal Syntax in Tag input !",text_in2);
      return 1;
    }
  }
  else{
    suc = sscanf(tag_name,"%d",tag_value);
    if(suc <= 0){
      pop_error_message("Illegal Syntax in Tag input !",text_in2);
      return 1;
    }
  }
  return 0;
}
