/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	create 3 pixmaps for main program of xcefdmp
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef_pix.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *
 */

#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include "xcef.h"
#include "xcef_layout.h"

#include "icon.bit"
#include "dict.bit"

Pixmap icon_map, dict_icon;

void create_pixmaps()
{
    Pixel fg,bg;

    fg=1;
    bg=0;
    icon_map = XCreatePixmapFromBitmapData(XtDisplay(toplevel),
             RootWindowOfScreen(XtScreen(toplevel)),icon_bits,icon_width,
             icon_height,fg,bg,DefaultDepthOfScreen(XtScreen(toplevel)));

    dict_icon = XCreatePixmapFromBitmapData(XtDisplay(toplevel),
             RootWindowOfScreen(XtScreen(toplevel)),dict_bits,dict_width,
             dict_height,fg,bg,DefaultDepthOfScreen(XtScreen(toplevel)));

  }

