/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	 Find name given a tag value from a dictionary
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef_node_name.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  Revision 1.1  1994/12/08  17:25:06  chen
 *	  Initial revision
 *
 *
 */

#include <stdio.h>
#include <string.h>
#include "xcef.h"

extern int is_string_empty();

/**************************************************************************
 *         void GetName (q, name, title)                                  *
 * Description:                                                           *
 *     Find out a name according to evTreeNode *q from a dictionary       *
 *************************************************************************/
void GetName(q,name,title)
evTreeNode *q;
char *name;
char *title;
{
  int         i,j,k;
  char        temp[80];
  evTreeNode *qq;
  TREE_NODE   *p, *pp;
  int         level_n,tag_v[20];          /* tag values on a path */

  sprintf(temp,"0x%x",q->tag_v);

  if(is_string_empty(DIRC) || is_regular(DIRC) !=1 || disable_dict){
    strcpy(name,temp);
    strcpy(title," ");
    return;
  }

/* put all tag values on the path to an array*/
  i=0;
  qq = q;
  while(qq != NULL){
    tag_v[i] = qq->tag_v;
    i++;   
    qq = qq->parent;
  }
  level_n = i;
  
/* try to match a path stored in tag_v[] to any tree node with same level */
   
  for(i = 0;i < num_of_tree; i++){
    p = root_d[i];
    j = level_n-1;
    while(j >= 0){
      if(tag_v[j] != p->tag_v){      /* no match at present level */
	if(p->rsibling !=NULL){
	  p = p->rsibling;
	}
	else{
	  while(p->rsibling == NULL && j <level_n-1 && p!=NULL){
	    p= p->parent;
	    j++;
	  }
	  p=p->rsibling;
	  if(j >= level_n -1)
	    break;
	}
      }
      else{
	if(p->mleft == NULL && j !=0){
	  if(p->rsibling != NULL)
	    p=p->rsibling;
	  else{
	    while(p->rsibling == NULL && j <level_n-1 && p!=NULL){
	      p= p->parent;
	      j++;
	    }
	    p=p->rsibling;
	    if(j >= level_n -1)
	      break;
	  }
	}
	else{
	  pp = p;
	  p = p->mleft;
	  j--;
	}
      }
    }

    if(j < 0){     /* match a path */
      strcpy(name,pp->name);
      strcpy(title,pp->title);
      break;
    }
  }

  if( i >= num_of_tree ){     /* no match for all trees */
    strcpy(name,temp);
    strcpy(title," ");
  }
  return;
}


