/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	layout and common variables for xcefdmp
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef_layout.h,v $
 *   Revision 1.3  1997/06/11 01:44:12  heyes
 *   spy on DD systemcd /usr/local/coda/linux/source/event/xcefdmp!
 *
 *   Revision 1.2  1997/03/05 16:08:03  chen
 *   increase buffer size
 *
 *   Revision 1.1.1.1  1996/09/19 18:26:25  chen
 *   original port to solaris
 *
 *	  Revision 1.2  1994/05/13  15:30:29  chen
 *	  redesign dialog_shell structure
 *
 *	  Revision 1.1  1994/04/12  16:23:53  chen
 *	  Initial revision
 *
*	  Revision 1.2  1994/02/07  15:23:27  chen
*	  change data struct on dialog_shell
*
*	  Revision 1.1  1993/10/27  09:22:59  heyes
*	  Initial revision
*
 *	  Revision 1.11  1993/10/25  16:15:51  chen
 *	  extern definition change
 *
 *	  Revision 1.10  1993/08/10  17:59:28  chen
 *	  add help and message widget
 *
 *	  Revision 1.9  1993/07/30  09:37:53  heyes
 *	  cc->gcc required callback changes
 *
 *	  Revision 1.7  1993/06/21  17:08:19  chen
 *	  add dict_mode and dict_op widgets
 *
 *	  Revision 1.6  1993/06/21  13:11:34  chen
 *	  change XNODE structure, increase array size for dictionary tree
 *
 *	  Revision 1.5  1993/06/16  15:25:38  chen
 *	  change numerical definition
 *
 *	  Revision 1.4  1993/06/01  16:45:20  chen
 *	  add more definitions
 *
 *	  Revision 1.3  1993/03/19  15:40:58  chen
 *	  add items to handle spy_event
 *
 *	  Revision 1.2  1993/01/08  19:32:45  chen
 *	  put event view region
 *
 *	  Revision 1.1  1992/07/28  20:24:12  chen
 *	  Initial revision
 *
 */

#ifndef _xcef_layout_h
#define _xcef_layout_h

#include "xcef.h"
#define  EVN_INC 2000  /* event number viewing region */
#define  MAX_NODE 500  /* MAX tree node inside a tree */
#define  MAX_DNODE 500 /* MAX dictionary tree node    */
#define  MAX_LEAF_NODE 100 /* max leaf nodes */

typedef struct _node
{
  evTreeNode *p;
  int         nc;
  int         level;
  int         num_children;
  int         folded;
}XNODE;

typedef struct _dnode
{
  TREE_NODE *p;
  int        nc;
}DXNODE;

typedef struct _dialog
{
  Widget dialog_shell;  /* pop up shell */
  Widget text_w;        /* text_window of pop_up */
  Widget mask_shell;    /* value_mask_shell      */
  char   name[100];     /* widget name must be unique*/
  int    type;          /* tell what type in my text_window*/
  int    count;         /* widget is created or not */
  int    map_or_not;    /* widget is mapped or not */
  int    mask_value;    /* mask_value for this popup */
  int    rshift_bit;    /* num of bit to shift right */
  int    mask_mode;     /* mask_mode, 0 and, 1 or */
  char   *buffer;       /* original char buffer */
}DIALOG;

typedef struct
{
  int  ind;
  char *type;
}D_TYPE;

typedef struct _rep_str
{
  int used;         /*1 it is current usabel*/
  char name[100];   /* static memory is better */
  evTreeNode *p;
}RepeatMem;         /*will be used in hex conversion for oxf case*/

/* Global Widgets, Wooooooooooooo, Ugly c code *******/
extern Widget toplevel;
extern Widget sw;
extern Widget tree;
extern Widget view;
extern Widget scale;
extern Widget tog_source,tog_stream;
extern Widget pushb0,pushb1,pushb2,pushb3;
extern Widget help_label, msg_win;
extern Widget m_cas0;
extern Widget menu1_0, menu1_1;
extern Widget comm0,comm1,comm2,comm3,comm4,comm5;
extern Widget text_in0,text_in1,text_in2,text_in3,text_in4,text_in5;
extern Widget hex_op0,hex_op1;
extern Widget dict_op0, dict_op1;
extern Widget dict_shell, dict_tree;
extern Pixmap icon_map,pixmap,dict_icon;
extern XtAppContext app_context;

/* some gloabal vriables */
extern char ev[];            /*memory for current event 2000000 bytes*/
extern int   evn;             /*tell which event we are working on */
extern int   n_of_ev;         /* number of event in a physical data file */
extern int   current_start;
extern int   current_ending;
extern XtIntervalId spy_id;   /* spy event timeout id           */
extern DIALOG   d_shell[MAX_LEAF_NODE];  /* keep track tree widget's children*/
extern RepeatMem rm[MAX_LEAF_NODE]; 
extern Pixel fold_bg, normal_bg;
extern int   show_tree_mode;

/* extern functions */
extern evTreeNode *EvTreeConstruct();
extern char       *strsave();
extern int        is_string_empty();
extern void       empty_string();
extern int        isRegularString();
extern char       *massage_string();
extern char       *applyMaskToIntBuffer();
extern void       sprint_item();
extern void       get_ascii_buffer();
extern void       pop_value_mask();
extern TREE_NODE  *DictTreeConstruct();
extern void       free_dict_tree();
extern void       free_ev_tree();
extern void       free_mask_widget_list();

extern void       popup_intro();
extern void       init_g();
extern void       source_pick();
extern void       new_source();
extern void       pop_error_message();
extern void       report_message ();
extern void       copy_evnode_value();
extern void       dict_pick();
extern void       new_dict();
extern void       view_dict();
extern void       popup_dict_shell();
extern void       tree_print();
extern void       load_dict();
extern void       open_source();
extern void       view_ev();
extern void       show_tree();
extern void       clean_tree();
extern void       show_d_tree();
extern void       get_tags();
extern void       tree_d_print();
extern void       pop_down();
extern void       save_v();
extern void       read_name();
extern void       pop_down_shell();
extern void       pop_question_dialog();
extern void       answer_q();
extern void       pop_auto_warning_message();
extern void       auto_popdown();
extern void       auto_pop_down();
extern void       new_evn();
extern void       view_mode_changed();
extern void       start_spy_timer();
extern void       spy_timer();
extern void       hex_or_dec();
extern void       dict_mode();
extern void       create_pixmaps();
extern void       create_colors();
extern void       input_tag();
extern void       change_event_mode();
extern void       popup_about();
extern void       tree_disp_mode();
extern void       popup_color_selector();
extern int        is_regular();
extern int        is_same_node();
extern int        open_dict();
extern int        convert_tag_int ();
extern void       pop_value_mask();
extern void       quit();

#endif

