/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	intial popup window for xcefdmp program
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef_intro.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *
 */

#include <stdio.h>
#include <string.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/Separator.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include <Xm/DialogS.h>

#include "xcef.h"
#include "xcef_layout.h"

static void popdown_about();

static Widget iform;

void popup_about(w,client_data, cbs)
Widget w;
XtPointer client_data;
XmAnyCallbackStruct *cbs;
{
  Widget   pb, label;
  XmString t;
  char     temp[256];
  Arg      arg[20];
  int      ac = 0;
  static   int ftime = 1;

  if (ftime) {
    ftime = 0;

    iform = XmCreateFormDialog (w, "Introduction", NULL, 0);

    t = XmStringCreateSimple ("ok");
    XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg (arg[ac], XmNrightOffset, 3); ac++;
    XtSetArg (arg[ac], XmNlabelString, t); ac++;
    pb = XtCreateManagedWidget ("ok button", xmPushButtonWidgetClass,
				iform, arg, ac);
    ac = 0;
    XmStringFree (t);
    
    sprintf (temp, "Event Display Utility for CODA 2.0\nby TJNAF Data Acquisition Group\n1996");
    t = XmStringCreateLtoR (temp, XmSTRING_DEFAULT_CHARSET);

    XtSetArg (arg[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg (arg[ac], XmNtopOffset, 30); ac++;
    XtSetArg (arg[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
    XtSetArg (arg[ac], XmNbottomOffset, 30); ac++;
    XtSetArg (arg[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg (arg[ac], XmNleftOffset, 30); ac++;
    XtSetArg (arg[ac], XmNrightAttachment, XmATTACH_WIDGET); ac++;
    XtSetArg (arg[ac], XmNrightWidget, pb); ac++;
    XtSetArg (arg[ac], XmNrightOffset, 5); ac++;
    XtSetArg (arg[ac], XmNlabelString, t); ac++;
    label = XtCreateManagedWidget ("introLabel", xmLabelWidgetClass,
				   iform, arg, ac);

    XtAddCallback (pb, XmNactivateCallback, popdown_about, (XtPointer)0);
    
  }
  XtManageChild (iform);
  XtPopup (XtParent (iform), XtGrabNone);
}

static void popdown_about(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmAnyCallbackStruct *cbs;
{
  XtPopdown (XtParent (iform));
}
       
