/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *     Init some global variables
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef_init.c,v $
 *   Revision 1.2  1997/06/11 17:30:07  heyes
 *   fix for configure
 *
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  Revision 1.2  1996/03/18  16:42:08  chen
 *	  enlarge root_d array size
 *
 *	  Revision 1.1  1994/12/08  17:24:42  chen
 *	  Initial revision
 *
 *
 */

#include <stdio.h>
#include "xcef.h"

char TAG[100], DIRC[200], SOURCE[200];
int  hex_or_decimal;
int  start, ending, disable_dict;
int  view_mode, event_mode;
int  spy_go_pause, spy_rate;
int  num_of_tree;
TREE_NODE *root_d[MAX_NUM_DICT_TREES];

void EvInit()
{
   int i;

   DIRC[0] = '\0';
   strcpy(SOURCE,"SPY");
   strcpy(TAG,"-1");
   start = 0;
   ending = 0;
   num_of_tree = 0;
   hex_or_decimal = 1;
   disable_dict = 0;
   view_mode = 1;        /* default view mode is viewing from spy */
   event_mode = 1;       /* default event mode is for all events */
   spy_go_pause = 0;     /* spy event go or pause */
   spy_rate = 1;         /* spy data stream event = 1 sec */
   for(i = 0;i < MAX_NUM_DICT_TREES; i++)
     root_d[i] = (TREE_NODE *)NULL;
 }
