/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	 header file for xcefdmp
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef.h,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:25  chen
 *   original port to solaris
 *
 *	  Revision 1.2  1996/03/18  16:41:46  chen
 *	  enlarge root_d array size
 *
 *	  Revision 1.1  1994/12/08  17:24:12  chen
 *	  Initial revision
 *
 *
 */

#ifndef _xcef_h
#define _xcef_h

#define MAX_NUM_DICT_TREES 50
#define MAXLEN         1000
#define NUM_BLOCK      100
#define NUM_EVENT      2000
#define MAX_BLOCK_SIZE 0x00000f00
#define MAXCHAR        4*MAX_BLOCK_SIZE*NUM_BLOCK
#define lcur           '{'
#define rcur           '}'

typedef struct _pst
{
  int            length;      /*inlclude size +1*/
  int            posi;        /* event start posi */
  int            type;
  int            tag;
  int            num;
  struct _pst    *next;
}EvStack;

typedef struct
{
  int           head_pos;
  int           type;
}Look_Ahead;                  /* find out which is header */

typedef struct _evTree
{
  int           length;     /*include size +1*/
  int           start;       /*where it starts inside a event */
  int           tag_v;
  char          *name;
  char          *title;
  int           type;       /*type for its own content*/
  int           num;        /*number in bank header */
  int           parent_type; /*type of its parent which will help header recognition*/
  struct _evTree *parent;
  struct _evTree *mleft;
  struct _evTree *rsibling;
}evTreeNode;


typedef struct TREE_NODE     /*tree structure related to dictionary*/
{
  int                tag_v;
  char               *name;
  char               *title;
  struct TREE_NODE   *mleft;
  struct TREE_NODE   *rsibling;
  struct TREE_NODE   *parent;
}TREE_NODE;

typedef struct _format
{
  short type;
  int new_line;     /*type newline or not*/
}FORMAT;

typedef struct _sdw
{
  short first_bit;
  short repeat;
  short arb;          /*either type or number of words*/
}SDW;               /*format descripotor*/

typedef char Bank;
typedef char Event;

extern char DIRC[];   /*dictionary name memory allocated*/
extern char SOURCE[]; /*data source name memory alocated*/
extern char TAG[];    /*tag name memory allocated       */
extern int  hex_or_decimal;  /* tell hex or decimal dump*/
extern int  disable_dict;    /* disable dictionary or not, 0 no */
extern int  start;           /* which event we start at*/
extern int  ending;          /* which event we are going to end at*/
extern int  num_of_tree;     /* number of trees in the forest of dictionary */
extern int  view_mode;       /* view mode, 0 for view data file, 1 for live stream*/
extern int  event_mode;      /* event mode, 0 for physics event, 1 for all events */
extern int  spy_go_pause;    /* 0, go mode, 1, pause mode in spying case */
extern int  spy_rate;        /* spy time out rate, controled by scale */
extern TREE_NODE  *root_d[MAX_NUM_DICT_TREES];


#endif
