/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	parse the format description when the data type
 *	is 0xF which is repeating structure
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: parse_format.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "xcef.h"

static void wm_parse();

void parse_format(evin,evnode,format,num,len)
Event evin[];
evTreeNode *evnode;
FORMAT *format[];
int    *num;        /*format number*/
int    *len;        /*format length in short word*/
{
  int          i,j,k,l,m;
  short        sdlen;
  char         temp[4],temp2[2];
  int          in_temp;
  short        s_temp1;
  SDW          *sd_array[100];  
/*format description is not going to exceed 100*/
  void         bufcpy();

  for(i=0;i < 100; i++)
    {
      sd_array[i] = (SDW *)malloc(1*sizeof(SDW));
    }

  i = evnode->start;
  
  if(evnode->parent_type == 0x10)  /*bank*/
     i = i + 4;
  else
     i = i + 2;

  j = 0;
  
  bufcpy(temp,&evin[i*2]);
  
  in_temp = *(int *)(temp);

  sdlen = (in_temp)&(0x0000ffff);   /* get number of long words for format*/

  *len = 2*sdlen;
  
  if(sdlen > 49)  /* I can not handle more 100*/
    {
     fprintf(stderr,"Too many format.\n");
     exit(1);
   }

  s_temp1 = (in_temp >> 16)&(0x0000ffff);

  if((s_temp1 & 0x8000) != 0)  /*first bit is 1*/
    {
      sd_array[j]->first_bit = 1;
      sd_array[j]->repeat = (s_temp1 >> 4) & (0x07ff);
      sd_array[j]->arb = (s_temp1)&(0x000f);
    }
  else     /* first bit is 0 */
    {
      sd_array[j]->first_bit = 0;
      sd_array[j]->repeat = (s_temp1 >> 8) &(0x00ff);
      sd_array[j]->arb = (s_temp1) & (0x00ff);
    }

  j++;   /*increase the pointer to sd_array*/
  i=i+2;   /*parse start*/

  l = i*2;
  k = i;

  while(k < i +2*sdlen-2)
    {
      bufcpy2(temp2,&evin[l]);
      s_temp1 = *(short *)(temp2);
      if((s_temp1 & 0x8000) != 0)
	{
	  sd_array[j]->first_bit = 1;
          sd_array[j]->repeat = (s_temp1 >> 4) & (0x07ff);
	  sd_array[j]->arb = (s_temp1)&(0x000f);
	}
      else     /* first bit is 0 */
	{
	  sd_array[j]->first_bit = 0;
	  sd_array[j]->repeat = (s_temp1 >> 8) &(0x00ff);
	  sd_array[j]->arb = (s_temp1) & (0x00ff);
	}     
      j++;
      l = l+2;
      k = k+1;
    }

/*fill the format structure*/
  k=0;i=0;l=0;
  
  while(k < j)
    {
      if(sd_array[k]->first_bit == 1)  /* real format*/
	{
          m = 0;
	  while(m < sd_array[k]->repeat)
	    {
	      format[i]->type = sd_array[k]->arb;
	      if(m != sd_array[k]->repeat - 1)
		format[i]->new_line = 0;
	      else
                format[i]->new_line = 1;
              i++;
              m++;
	    }
	  k++;
	}
      else                            /*recursive parsing format*/
	{
          m = sd_array[k]->arb;
	  wm_parse(sd_array,k,format,&i);
          k = k + m + 1;
	}
    }
  *num = i;
}

  
static void wm_parse(sd_array,k_start,format,ii)
SDW *sd_array[];
int k_start;
FORMAT *format[];
int *ii;
{
  int i,j,k,l,m;
  int nw,repeat;
  
  i = k_start;

  repeat = sd_array[i]->repeat;
  nw = sd_array[i]->arb;
  
  l = *ii;
  for(k=0;k<repeat;k++)
    {
      for(j = i + 1;j < i + nw + 1; j++)
	{
	  if(sd_array[j]->first_bit == 1)  /*real stuff*/
	    {
              m = 0;
	      while(m < sd_array[j]->repeat)
		{
		  format[l]->type = sd_array[j]->arb;
		  if(m != sd_array[j]->repeat - 1)
		    format[l]->new_line = 0;
		  else
		    format[l]->new_line = 1;
                  l++;
                  m++;
		  *ii = l;
		}
	    }
	  else
	    wm_parse(sd_array,j,format,ii);
	}
    }
}




  
  

  
  
