/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	get ascii number from input data stream
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: get_ascii_buffer.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *
 */

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <ctype.h>

#include "xcef.h"

void get_ascii_buffer(evin,ev_node,start,buffer)
Event      evin[];
evTreeNode *ev_node;
int        start;
char       *buffer;
{
  int            i,j,k,l,m;
  evTreeNode     *p;
  int            in_temp;
  short          sh_temp;
  unsigned short us_temp;
  float          f_temp;
  char           temp[4],temp2[2],str[50];
  char           *q;
  void           bufcpy(),bufcpy2();


  i = start;
  p = ev_node;
  q = buffer;
  switch(p->type)
    {
    case 0x0:
    case 0x30:
      j = i*2;
      while(i < p->start + p->length)
	{
	  bufcpy2(temp2,&evin[j]);
	  us_temp = *(unsigned short *)(temp2);
	  sprintf(str,"0x%-10.4x",us_temp);
	  for(m = 0; m < 12; m++)
	    {
	      *q = str[m];
	      q++;
	    }
	  j = j + 2;
          i = j/2;
	}
      *q = '\0';
      break;
    case 0x1:
      while(i < p->start + p->length)
	{
	  bufcpy(temp,&evin[i*2]);
	  in_temp = *(int *)(temp);
	  if(hex_or_decimal == 0)
	    sprintf(str,"%-12d",in_temp);
	  else
	    sprintf(str,"0x%-10.8x",in_temp);
	  for(m=0;m<12;m++)
	    {
	      *q = str[m];
	      q++;
	    }
	  i = i + 2;
	}
      *q = '\0';
      break;
    case 0x2:
      while(i < p->start + p->length)
	{
	  bufcpy(temp,&evin[i*2]);
	  f_temp = *(float *)(temp);
	  sprintf(str,"%-12.6f",f_temp);
	  for(m=0;m<12;m++)
	    {
	      *q = str[m];
	      q++;
	    }
	  i = i + 2;
	}
      *q = '\0';
      break;
    case 0x3:
      while(i < p->start + p->length)
	{
	  bufcpy(temp,&evin[i*2]);
	  for(m=0;m < 4 ;m++)
	    {
	      *q = temp[m];
	      q++;
	    }
	  i = i + 2;
	}
      *q = '\0';
      break;
    case 0x4:
      while(i < p->start + p->length)
	{
	  bufcpy2(temp2,&evin[i*2]);
	  sh_temp = *(short *)(temp2);
	  if(hex_or_decimal == 0)
	    sprintf(str,"%-12d",sh_temp);
	  else
	    sprintf(str,"0x%-10.4x",sh_temp);
	  for(m=0;m<12;m++)
	    {
	      *q = str[m];
	      q++;
	    }
	  i++;
	}
      *q = '\0';
      break;
    case 0x5:
    case 0x35:
      while(i < p->start + p->length)
	{
	  bufcpy2(temp2,&evin[i*2]);
	  us_temp = *(unsigned short *)(temp2);
	  if(hex_or_decimal == 0)
	    sprintf(str,"%-12d",us_temp);
	  else
	    sprintf(str,"0x%-10.4x",us_temp);
	  for(m=0;m<12;m++)
	    {
	      *q = str[m];
	      q++;
	    }
	  i++;
	}
      *q = '\0';
      break;
    case 0x33:  /*packet with short word*/
      while(i < p->start + p->length)
	{
	  bufcpy2(temp2,&evin[i*2]);
	  for(m=0;m<strlen(temp2);m++)
	    {
	      *q = temp2[m];
	      q++;
	    }
	  i++;
	}
      *q = '\0';
      break;
    case 0x34:  /*packet with short int*/
      while(i < p->start + p->length)
	{
	  bufcpy2(temp2,&evin[i*2]);
	  sh_temp = *(short *)(temp2);
	  if(hex_or_decimal == 0)
	    sprintf(str,"%-12d",sh_temp);
	  else
	    sprintf(str,"0x%-10.4x",sh_temp);
	  for(m=0;m<12;m++)
	    {
	      *q = str[m];
	      q++;
	    }
	  i++;
	}
      *q = '\0';
      break;
    default:
      sprintf(buffer,"Wrong Data Type !");
      break;
    }
}
