/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	CODA Color Utitlties
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: coda_color.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  
 */
#include <stdio.h>
#include <string.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <math.h>

void RGB_TO_HSV();
void HSV_TO_RGB();

void RGB_TO_HSV(r,g,b,h,s,v)
int r,g,b;
float *h,*s,*v;
{
  float max,min;
  float temp;
  float rr,gg,bb;
  float delta;

  rr = r/65535.0;
  gg = g/65535.0;
  bb = b/65535.0;

  max = rr;
  if(gg >= max)
     max = gg;
  if(bb >= max)
     max = bb;

  min = rr;
  if(gg < min)
     min = gg;
  if(bb < min)
     min = bb;
  

  *v = max;
  if(max != 0)
    {
     *s = (max-min)/max;
   }
  else
     *s = 0.0;

  if(*s == 0.0)
    *h = 400.0;
  else
    {
      delta = max - min;
      if(rr == max)
	*h = (gg-bb)/delta;
      else if(gg == max)
	*h = 2 + (bb - rr)/delta;
      else
        *h = 4 + (rr - gg)/delta;

      *h = *h * 60.0;
      if(*h < 0)
        *h = *h + 360;
    }
}


void HSV_TO_RGB(r,g,b,h,s,v)
int *r,*g,*b;
float h,s,v;
{
  float rr,gg,bb;
  int i;
  float f,p,q,t;

  if(s == 0)
    {
     if(h == 400.0)
       {
        rr = v;
        gg = v;
        bb = v;
      }
   }
  else
    {
      if(h == 360.0)
         h = 0.0;
      h = h/60;
      i = floor(h);
      f = h -i;
      p = v*(1-s);
      q = v*(1-(s*f));
      t = v*(1-(s*(1-f)));
      switch(i)
	{
	case 0:
          rr = v;
          gg = t;
          bb = p;
          break;
        case 1:
          rr = q;
          gg = v;
          bb = p;
          break;
        case 2:
          rr = p;
          gg = v;
          bb = t;
          break;
        case 3:
          rr = p;
          gg = q;
          bb = v;
          break;
        case 4:
          rr = t;
          gg = p;
          bb = v;
          break;
        case 5:
          rr = v;
          gg = p;
          bb = q;
        default:
          break;
	}
    }
  *r = (int)(rr*65535);
  *g = (int)(gg*65535);;
  *b = (int)(bb*65535);;
}


void XcodaGetShadowColor(parent,bg,b_shadow,t_shadow)
Widget parent;
Pixel bg;
Pixel *b_shadow,*t_shadow;
{
  Display *disp = XtDisplay(parent);
  Screen   *sc = XtScreen(parent);
  Colormap colmap;
  XColor   bg_color,t_color,b_color;
  int      r,b,g;
  float    h,s,v,th,ts,tv;

  colmap = DefaultColormapOfScreen(sc);
    
  bg_color.pixel = bg;
  XQueryColor(disp,colmap,&bg_color);

  RGB_TO_HSV(bg_color.red,bg_color.green,bg_color.blue,&h,&s,&v);

/*calculate bottom shadow*/
  if(s == 0.0)
    {
      ts = 0.0;
      th = 400.0; /*undefined*/
      tv = 3*v/4;
    }
  else
    {
      ts = s;
      th = h;
      tv = 3*v/4;
    }

  HSV_TO_RGB(&r,&g,&b,th,ts,tv);
  
  b_color.red = r;
  b_color.green = g;
  b_color.blue = b;

  XAllocColor(disp,colmap,&b_color);
  *b_shadow = b_color.pixel;

/*calculate top shade*/
  if(s == 0.0)
    {
      ts = 0.0;
      th = 400.0; /*undefined*/
      tv = v;
    }
  else
    {
      ts = s/4;
      th = h;
      tv = v;
    }

  HSV_TO_RGB(&r,&g,&b,th,ts,tv);

  t_color.red = r;
  t_color.green = g;
  t_color.blue = b;

  XAllocColor(disp,colmap,&t_color);
  *t_shadow = t_color.pixel;

}

