%{
/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	CODA event dictionary parser
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 */
#include "cefDictTree.h"
#include "y.tab.h"
int lineno = 0;
int tag = 1;
char linebuf[256];
extern char *strsave ();
%}
ws         [ \t]+
comment    [ \t]*!.*
hexnum     [a-fA-F0-9]+
desname    [a-zA-Z]+[A-Za-z0-9_="/""@"]*

%s C_COMMENT NORMAL

%%
%{
    BEGIN NORMAL;
%}
<NORMAL>{ws}                      ;
<NORMAL>{comment}                 ;
<NORMAL>^[ \t]*"/*".*"*/"[ \t]*\n    {lineno++;       }
<NORMAL>"/*"                         {BEGIN C_COMMENT;}
<C_COMMENT>.                         ;
<C_COMMENT>\n                        {lineno++;       }
<C_COMMENT>.*"*/"                    {BEGIN NORMAL;   }

<NORMAL>{hexnum}                     {yylval.string = strsave (yytext);
                                      if (tag){
                                         tag = 0;
                                         return INT_TAG; 
                                         }
                                      else
                                         return DESNAME;
                                     }
<NORMAL>{desname}                    {yylval.string = strsave (yytext);
                                      return DESNAME; }
<NORMAL>"{"                          {return LEFT_CUR;}
<NORMAL>"}"                          {return RIGHT_CUR;}
<NORMAL>\n.*                         {lineno++; strcpy (linebuf, yytext+1);
                                      tag = 1;
                                      yyless (1);}
<NORMAL>.                            {fprintf (stdout, "unrecognized char %c at line %d\n", 
                                               yytext[0], lineno);}

%%

void yyerror()
{
/* empty */
}
