/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	 Various utility routines
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: cef_util.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  Revision 1.1  1994/12/08  17:22:28  chen
 *	  Initial revision
 *
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include "xcef.h"

/*************************************************************************
 *            char *strsave (s)                                          *
 * Description:                                                          *
 *         Same as strdup, caller has to release the memory              *
 ************************************************************************/
char *strsave(string)
char *string;
{
  char *p;
 
  if((p=(char *)malloc(strlen(string)+1))!=NULL)
    strcpy(p,string);
  return(p);
}

/************************************************************************
 *              int is_string_empty (s)                                 *
 * Description:                                                         *
 *     Check whether a string is a empty string or not                  *
 ***********************************************************************/
int is_string_empty(s)
char *s;
{
  if(strlen(s) != 0)
    return 0;
  else
    return 1;
}

/***********************************************************************
 *             void empty_string (s)                                   *
 * Description:                                                        *
 *     Clean out string s                                              *
 **********************************************************************/
void empty_string(s)
char *s;
{
  s[0] = '\0';
}

/**********************************************************************
 *             int isRegularString(s)                                 *
 * Description:                                                       * 
 *     Check whether a string is a reguler string which contains      *
 *     Alpha Numeric numbers                                          *
 *     Return 1: OK, 0: NO                                            *
 *********************************************************************/
int isRegularString (s)
char *s;
{
  char *p = s;
  while (*p != '\0'){
    if (isgraph(*p))
      return 1;
    p++;
  }
  return 0;
}

/**********************************************************************
 *             int is_reguler(filename)                               *
 * Description:                                                       *
 *     Check a file 'filename' is regular file or not                 *
 *     -1: bad file,                                                  *
 *     0:  may be a directory                                         *
 *     1: ok for read at least                                        *
 *********************************************************************/
int is_regular(file)
char *file;
{
  struct stat s_buf;

  if(stat(file,&s_buf) == -1)
    return(-1);
  else if((s_buf.st_mode & S_IFMT) == S_IFDIR)
    return 0;
  else if(!(s_buf.st_mode &S_IFREG) || access(file,R_OK) == -1)
    return -1;
  else
    return 1;
}

