/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	 header file for dictionary tree structure
 *	
 * Author:  Jie Chen
 *          CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: cefDictTree.h,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:25  chen
 *   original port to solaris
 *
*	  Revision 1.2  1996/03/18  16:41:34  chen
*	  enlarge root_d array size
*
*	  Revision 1.1  1995/03/16  20:00:59  chen
*	  Initial revision
*
 *
 */
#ifndef _CEFDICT_TREE_H
#define _CEFDICT_TREE_H

#define MAX_NUM_CHILDREN 50
#define MAX_NUM_DICT_TREES 50

typedef struct TREE_NODE     /*tree structure related to dictionary*/
{
  int                tag_v;
  char               *name;
  char               *title;
  struct TREE_NODE   *mleft;
  struct TREE_NODE   *rsibling;
  struct TREE_NODE   *parent;
}TREE_NODE;

typedef struct forest_
{
  TREE_NODE         *root[MAX_NUM_CHILDREN];
  int               numTrees;
}FOREST;

extern FOREST *glbForest;

extern void      updateGlbTreeNode ();
extern TREE_NODE *newTreeNode ();
extern void      updateTreeNoe ();
extern void      deleteDictTree ();
extern FOREST    *newForest();
extern void      addTreeToForest ();
extern void      deleteForest ();
extern void      mleftOfTree ();
extern void      parentOfForest ();
extern void      print_forest ();
extern int       parseDictionary ();

extern TREE_NODE *root_d[MAX_NUM_DICT_TREES];
extern int       num_of_tree;
#endif
