/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *          construct tree structure using most left
 *          child and right sibling data structure
 *          accrording to the dictionary
 *	
 * Author:  Jie Chen
 *          CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: cefDictParse.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:23  chen
 *   original port to solaris
 *
 *
 */
#include <stdio.h>
#include <string.h>
#include "cefDictTree.h"

/**********************************************************************
 *           int parseDictionary (filename)                           *
 * Description:                                                       *
 *     Parse a dictionary with filename 'filename'                    *
 *     Return 0: success, 1: failure                                  *
 *********************************************************************/
int parseDictionary (filename, lnum, line)
char *filename;
int  *lnum;
char *line;
{
  int i = 0;
  extern FILE *yyin;
  extern int  lineno;
  extern char linebuf[];
  int         status;

  /* clean up old structure */
  if (num_of_tree){
    for (i = 0; i < num_of_tree; i++)
      deleteDictTree (root_d[i]);
    num_of_tree = 0;
  }
  yyin = fopen (filename, "r");
  status = yyparse ();
  fclose (yyin);
  if (status){ /* error ocurred */
    *lnum = lineno;
    line = linebuf;
    if (num_of_tree){
      for (i = 0; i < num_of_tree; i++)
	deleteDictTree (root_d[i]);
      num_of_tree = 0;
    }
  }
  return status;
}
