/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *   private header file for the Tree Widget
 *	
 * Author:  Jie Chen and Chip Watson, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log $
 */
#ifndef TREECODAP_H
#define TREECODAP_H
typedef struct _XcodaTreeClassPart {
    int         ignore;
} XcodaTreeClassPart;

typedef struct _XcodaTreeClassRec {
    CoreClassPart         core_class;
    CompositeClassPart    composite_class;
    ConstraintClassPart   constraint_class;
    XcodaTreeClassPart    tree_class;
} XcodaTreeClassRec;

extern XcodaTreeClassRec xcodaTreeClassRec;

typedef struct {
    Dimension  *array;
    int         size;
  }  TreeOffset, *TreeOffsetPtr;

typedef struct {
    Dimension      h_min_space;
    Dimension      v_min_space;
    Pixel          foreground;
    GC             gc;
    Dimension      line_width;  /*connection line width*/
    int            tree_type;   /*tree layout          */
    TreeOffsetPtr  horizontal;
    TreeOffsetPtr  vertical;
    Widget         tree_root;
} XcodaTreePart;


typedef struct _XcodaTreeRec {
    CorePart        core;
    CompositePart   composite;
    ConstraintPart  constraint;
    XcodaTreePart      tree;
}  XcodaTreeRec;



typedef struct _TreeConstraintsPart {
  Widget        super_node;
  WidgetList    sub_nodes;
  long          n_sub_nodes;
  long          max_sub_nodes;
  Position      x, y;
} TreeConstraintsPart;

typedef struct _TreeConstraintsRec {
   TreeConstraintsPart tree;
} TreeConstraintsRec, *TreeConstraints;


#define TREE_CONSTRAINT(w) \
                   ((TreeConstraints)((w)->core.constraints))

#endif TREECODAP_H



