/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Open a dictionary load DictTree Objects
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: open_dict.c,v $
 *   Revision 1.1.1.1  1996/09/24 14:21:28  chen
 *   Initial import to coda_2.0
 *
 *	  Revision 1.2  1995/03/17  14:58:44  chen
 *	  Using new yacc/lex based dictionary parser
 *
 *	  Revision 1.1  1994/12/08  14:45:09  chen
 *	  Initial revision
 *
 *
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "cef.h"

extern char      *strsave();
extern int       is_regular();

/*********************************************************
 *       int open_dict( )                                *
 * Description:                                          *
 *     Open a dictionary given the name by DIRC          *
 ********************************************************/
int open_dict()
{
  int  parseError = 0;
  int  errLineNum;
  char *errLine;

  if(is_string_empty (DIRC))
    return -1;

  if(is_regular(DIRC) < 1){
    fprintf(stderr,"Unreadable dictionary file %s\n",DIRC);
    return -1;
  }
  
  parseError = parseDictionary (DIRC, &errLineNum, errLine);
  if (parseError){
    fprintf (stderr,"Syntax error at line %d of the dictionary\n", errLineNum);
    return -1;
  }
  return 0;
}
