%{
/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	CODA event display dictionary parser
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 */
#include <stdio.h>
#include <string.h>
#include "cefDictTree.h"
char        tx[256];
extern char *strsave ();
%}

%union{
  char *string;
  int  i_value;
  TREE_NODE *dictTree;
  FOREST    *dictForest;
}

%token <string>  DESNAME, INT_TAG
%token <i_value> LEFT_CUR, RIGHT_CUR
%type  <string>  title stitle
%type  <dictTree> dict_tree
%type  <dictForest> dict_forest

%start dict

%%
dict: dict_forest {updateGlbTreeNode ($1);
		   deleteForest ($1);}

dict_forest: dict_tree {$$ = newForest();
		        addTreeToForest ($$, $1);
		      }
           | dict_tree dict_forest {addTreeToForest ($2, $1);
				    $$ = $2;
				   }

dict_tree: INT_TAG DESNAME title {$$ = newTreeNode();
				  updateTreeNode ($$,$1, $2, $3);
				  free ($1); free ($2); free ($3);
				}
           | INT_TAG DESNAME title LEFT_CUR dict_forest RIGHT_CUR {
	     $$ = newTreeNode ();
	     updateTreeNode ($$, $1, $2, $3);
	     free ($1); free ($2); free ($3);
	     mleftOfTree ($$, $5);
	     parentOfForest ($5, $$);
	     deleteForest ($5);
	   }

title: stitle {$$ = strsave ($1); free ($1);}
       | stitle title {sprintf (tx,"%s %s",$1, $2);
		       $$ = strsave (tx);
		       free ($1); free ($2);
		     }

stitle: DESNAME  {$$ = strsave ($1); free ($1);}

%%

      
