/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Spy event stream according to object name and event type
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: cef_spy_event.c,v $
 *   Revision 1.1.1.1  1996/09/24 14:21:27  chen
 *   Initial import to coda_2.0
 *
 *	  Revision 1.1  1994/12/08  14:43:33  chen
 *	  Initial revision
 *
 */
#include <stdio.h>
#include <string.h>
#include "cef.h"
#include "evfile_msg.h"

extern evTreeNode *EvTreeConstruct();
extern void       dump_tree(),bufcpy();
extern void       free_ev_tree ();

static int daCopyRegister (char* name, int type)
{
  return 0;
}

static int daCopy (char* buffer, int* bufsize, int rate)
{
  return 0;
}

static int daCopyUnregister (char* name, int type)
{
  return 0;
}

/******************************************************************
 *           int get_event_num (event)                            *
 * Description:                                                   *
 *     Get Current event number pointed by event                  *
 *****************************************************************/
static int get_event_num (ev)
char ev[];
{
  int e_num;
  char temp[4];
  int  i,header,key;

  i = 0;
  i= i+12;
  bufcpy(temp,&ev[i]);
  header = *(int *)(temp);
  key = (header >> 16) &(0x0000ffff);
  if(key != 0xc000){  /* roc */
    header = *(int *)(temp);
    e_num = (0x000000ff)&(header);
    return(e_num);
  }
  else{  /* event id bank */
    i = i + 4;
    bufcpy(temp,&ev[i]);
    e_num = *(int *)(temp);
    return(e_num);
  }
}

/******************************************************************
 *           void spy_event (objname, type, spy_period)           *
 * Description:                                                   *
 *     Spy in a event stream, with object name and event type     *
 *****************************************************************/
void spy_event(objname,type, spy_period)
char *objname;
int  type, spy_period;
{
  Event ev[20000];
  int   status;
  int   ev_size,t_type,t_length;
  int   ev_num;
  char  temp[4];
  evTreeNode *root;

  while(1){
    /*establish rpc connection*/
    ev_size = sizeof(ev);
    status = daCopyRegister (objname, type);
    if (status < 0){
      fprintf(stderr,"Cannot establish remote connection\n");
      exit (1);
    }
    status = daCopy(ev,&ev_size, spy_period);
    daCopyUnregister (objname, type);
    if(status >= 0 && ev_size != sizeof(ev)){
      bufcpy(temp,ev);
      ev_size = *(int *)(temp);
      t_type = 0xC;
      t_length = ev_size;
      ev_num = get_event_num (ev);
      root = EvTreeConstruct(ev,t_type,t_length);
      printf("Event number %d \n", ev_num);
      dump_tree(root,ev);
      free_ev_tree (root);
    }
    else
      fprintf(stderr,"Cannot find this event type %d \n", type);
    sleep (spy_period);
  }
  exit(0);
}
