/*
 *      Original Author: Ben-chin Cha
 *      Date:            8-10-92
 *
 *      Experimental Physics and Industrial Control System (EPICS)
 *
 *      Copyright 1991, the Regents of the University of California,
 *      and the University of Chicago Board of Governors.
 *
 *      This software was produced under  U.S. Government contracts:
 *      (W-7405-ENG-36) at the Los Alamos National Laboratory,
 *      and (W-31-109-ENG-38) at Argonne National Laboratory.
 *
 *      Initial development by:
 *              The Controls and Automation Group (AT-8)
 *              Ground Test Accelerator
 *              Accelerator Technology Division
 *              Los Alamos National Laboratory
 *
 *      Co-developed with
 *              The Controls and Computing Group
 *              Accelerator Systems Division
 *              Advanced Photon Source
 *              Argonne National Laboratory
 *
 * Modification Log:
 * -----------------
 * .01  08-11-92        bkc     Model list use the new next element pointer, 
 *                              all the global functions begins with ca_ .
 * .02  01-27-93        bkc     Add the ca_monitor_get_all_array to return the
 *				value, status, severity for the monitored
 *				list form data structure. 
 * .03  08-27-93        bkc     Add the checking for whether event monitor 
 *                              is on before setting return infomation  
 * .04  mm-dd-yy        iii     Comment
 */


#include<sys/types.h>
#include<sys/time.h>
#include<stdio.h>
#include "chandata.h"
#include "tcl.h"

extern struct caGlobals CA;

caddr_t pfdctx;  /*fdmgr context */

int event_timeout_id;
#define USEC_TIME_OUT 10000
static struct timeval timeout = {0,USEC_TIME_OUT};

int CONN = 1;
extern chandata *pchandata;
extern Tcl_Interp *pinterp;

double atof();

void ca_get_dbr_sts_double_callback();
void ca_get_dbr_sts_string_callback();
void ca_get_dbr_sts_string_callback3();
void ca_get_dbr_ctrl_double_callback();
int ca_monitor_add_event_array();
int ca_monitor_clear_event_array();
void ca_monitor_add_event();
void ca_monitor_clear_event();
int ca_monitor_get_event();
void ca_monitor_get_event_array();
void ca_monitor_get_value_array();
void ca_monitor_get_all_array();
int ca_monitor_check_event();
int ca_monitor_check_event_array();
void ca_connect_change_event();
void  ca_monitor_value_change_event();
void ca_connect_add_event();
void ca_process_CA();

/******************************************************
  get value callback instead of ca_get function
******************************************************/
void ca_get_dbr_sts_double_callback(args)
struct event_handler_args args;
{
chandata *pchandata;

	pchandata = (chandata *)ca_puser(args.chid);

        if (CA.devprflag > 1)
        fprintf(stderr,"Old: name=%s, value=%f, stat=%d, sevr=%d, error=%d\n",
                ca_name(pchandata->chid),
                pchandata->value, pchandata->status,
                pchandata->severity,pchandata->error);

	/* get new value */

        pchandata->value = ((struct dbr_sts_double *)args.dbr)->value;
        pchandata->status= ((struct dbr_sts_double *)args.dbr)->status;
        pchandata->severity = ((struct dbr_sts_double *)args.dbr)->severity;
        pchandata->error= 0;

        if (CA.devprflag > 1)
        fprintf(stderr,"New: name=%s, value=%f, stat=%d, sevr=%d, error=%d\n",
                ca_name(pchandata->chid),
                pchandata->value, pchandata->status,
                pchandata->severity,pchandata->error);
}



/******************************************************
  get value callback instead of ca_get function
******************************************************/
void ca_get_dbr_sts_string_callback(args)
struct event_handler_args args;
{
chandata *pchandata;

	pchandata = (chandata *)ca_puser(args.chid);

        if (CA.devprflag > 1)
        fprintf(stderr,"Old: name=%s, value=%s, stat=%d, sevr=%d, error=%d\n",
                ca_name(pchandata->chid),
                pchandata->string, pchandata->status,
                pchandata->severity,pchandata->error);

	/* get new value */

        strcpy(pchandata->string, ((struct dbr_sts_string *)args.dbr)->value);
        pchandata->status= ((struct dbr_sts_string *)args.dbr)->status;
        pchandata->severity = ((struct dbr_sts_string *)args.dbr)->severity;
	pchandata->value = atof(pchandata->string);
        pchandata->error= 0;

        if (CA.devprflag > 1)
        fprintf(stderr,"New: name=%s, value=%s, stat=%d, sevr=%d, error=%d\n",
                ca_name(pchandata->chid),
                pchandata->string, pchandata->status,
                pchandata->severity,pchandata->error);

}

void ca_get_dbr_sts_string_callback3(args)
struct event_handler_args args;
{
  chandata *pchandata;
  char *result;
  
  pchandata = (chandata *)ca_puser(args.chid);
  result = ((struct dbr_sts_string *)args.dbr)->value;

/*
  strcpy(pchandata->string, ((struct dbr_sts_string *)args.dbr)->value);
  pchandata->status= ((struct dbr_sts_string *)args.dbr)->status;
  pchandata->severity = ((struct dbr_sts_string *)args.dbr)->severity;
  pchandata->value = atof(pchandata->string);
  pchandata->error= 0;
*/
 
  Tcl_SetVar2(pinterp,"Control",ca_name(pchandata->chid),result,TCL_GLOBAL_ONLY);
}

/******************************************************
  get dbr_ctrl_double_callback instead of ca_get function
******************************************************/
void ca_get_dbr_ctrl_double_callback(args)
struct event_handler_args args;
{
char string[MAX_STRING_SIZE];
chandata *pchandata;

	pchandata = (chandata *)ca_puser(args.chid);

        if (CA.devprflag > 1)
        fprintf(stderr,"Old: name=%s, value=%f, stat=%d, sevr=%d, error=%d\n",
                ca_name(pchandata->chid),
                pchandata->value, pchandata->status,
                pchandata->severity,pchandata->error);

	/* get new value */

        pchandata->value = ((struct dbr_ctrl_double *)args.dbr)->value;
        pchandata->uopr = ((struct dbr_ctrl_double *)args.dbr)->upper_disp_limit;
        pchandata->lopr = ((struct dbr_ctrl_double *)args.dbr)->lower_disp_limit;
        pchandata->upper_alarm_limit = ((struct dbr_ctrl_double *)args.dbr)->upper_alarm_limit;
        pchandata->upper_warning_limit = ((struct dbr_ctrl_double *)args.dbr)->upper_warning_limit ;
        pchandata->lower_warning_limit = ((struct dbr_ctrl_double *)args.dbr)->lower_warning_limit ;
        pchandata->lower_alarm_limit = ((struct dbr_ctrl_double *)args.dbr)->lower_alarm_limit ;
        pchandata->upper_ctrl_limit = ((struct dbr_ctrl_double *)args.dbr)->upper_ctrl_limit ;
        pchandata->lower_ctrl_limit = ((struct dbr_ctrl_double *)args.dbr)->lower_ctrl_limit ;
        pchandata->status = ((struct dbr_ctrl_double *)args.dbr)->status;
        pchandata->severity = ((struct dbr_ctrl_double *)args.dbr)->severity;
        strcpy(pchandata->units, ((struct dbr_ctrl_double *)args.dbr)->units);
        if (pchandata->max < ((struct dbr_ctrl_double *)args.dbr)->value) 
		pchandata->max = ((struct dbr_ctrl_double *)args.dbr)->value;
        if (pchandata->min > ((struct dbr_ctrl_double *)args.dbr)->value) 
		pchandata->min = ((struct dbr_ctrl_double *)args.dbr)->value;
	pchandata->error = 0;

if (CA.devprflag > 1) {
        fprintf(stderr,"New: name=%s, value=%f, stat=%d, sevr=%d, error=%d\n",
                ca_name(pchandata->chid),
                pchandata->value, pchandata->status,
                pchandata->severity,pchandata->error);
        fprintf(stderr,"\tprecision=%d\n",
		((struct dbr_ctrl_double *)args.dbr)->precision);
        fprintf(stderr,"\tRISC_pad0=%d\n",
		((struct dbr_ctrl_double *)args.dbr)->RISC_pad0);
        fprintf(stderr,"\tunits=%s\n",
		pchandata->units);
        fprintf(stderr,"\tdisp_limit : [ %f : %f ]\n",
                pchandata->uopr, 
                pchandata->lopr); 
        fprintf(stderr,"\tctrl_limit : [ %f : %f ]\n",
                ((struct dbr_ctrl_double *)args.dbr)->lower_ctrl_limit, 
		((struct dbr_ctrl_double *)args.dbr)->upper_ctrl_limit);
        fprintf(stderr,"\tupper_alarm_limit=%f\n",
		pchandata->upper_alarm_limit);
        fprintf(stderr,"\tupper_warning_limit=%f\n",
		pchandata->upper_warning_limit);
        fprintf(stderr,"\tlower_warning_limit=%f\n",
		pchandata->lower_warning_limit);
        fprintf(stderr,"\tlower_alarm_limit=%f\n",
		pchandata->lower_alarm_limit);
        fprintf(stderr,"\tvalue=%f\n",
		pchandata->value);
        fprintf(stderr,"\tstatus=%d\n",
		pchandata->status);
        fprintf(stderr,"\tseverity=%d\n",
		pchandata->severity);
        }


}



/******************************************************
  add a monitor list
******************************************************/
int ca_monitor_add_event_array(interp,noName,pvName)
int noName;
char **pvName;
Tcl_Interp *interp;
{
  int i,status,command_error=0;
  chandata *list,*snode;
  
  command_error = ca_pvlist_search(noName,pvName,&list);
  pinterp = interp;
  snode = list;
  while (snode)  {
    pchandata = snode;
    pchandata->type = ca_field_type(pchandata->chid);
    if (pchandata->type == TYPENOTCONN) {
      fprintf(stderr,"%-30s  ***  device not found\n",pvName[i]);
      command_error = CA_FAIL;
    }
    else  if (pchandata->evid == NULL) {
      ca_monitor_add_event(pchandata); 
      if (CA.devprflag > 0)
	fprintf(stderr,"name=%s, evid=%x\n",
		ca_name(pchandata->chid),pchandata->evid);
    }
    snode = snode->next;
  }
  ca_check_command_error(command_error);
  if (command_error == CA_FAIL) { return TCL_ERROR; } else {return TCL_OK;}
}

/******************************************************
  clear a monitor list
******************************************************/
int ca_monitor_clear_event_array(interp,noName,pvName)
int noName;
char **pvName;
Tcl_Interp *interp;
{
  int i,status,command_error=0;
  chandata *list,*snode;
  
  command_error = ca_pvlist_search(noName,pvName,&list);
  pinterp = interp;
  snode = list;
  while (snode)  {
    pchandata = snode;
    pchandata->type = ca_field_type(pchandata->chid);
    if (pchandata->type == TYPENOTCONN) {
      fprintf(stderr,"%-30s  ***  device not found\n",pvName[i]);
      command_error = CA_FAIL;
    }
    else  if (pchandata->evid) ca_monitor_clear_event(pchandata); 
    snode = snode->next;
  }
  
  ca_check_command_error(command_error);
  if (command_error == CA_FAIL) { return TCL_ERROR; } else {return TCL_OK;}
}

/******************************************************
  add a monitor channel 
******************************************************/
void ca_monitor_add_event(pchandata)
chandata *pchandata;
{
void ca_monitor_value_change_event();
int status;
/* JvZ: DOUBLE-> STRING
        status = ca_add_masked_array_event(DBR_STS_STRING,1,
                pchandata->chid,
		ca_monitor_value_change_event,
                pchandata,
                (float)0,(float)0,(float)0,
                &(pchandata->evid),
                DBE_VALUE | DBE_ALARM);
*/
        status = ca_add_event(DBR_STS_STRING,
                pchandata->chid,
		ca_get_dbr_sts_string_callback3,
                pchandata,
                &(pchandata->evid));

       	ca_check_return_code(status);

/* automatically add a change connection event */

	ca_connect_add_event(pchandata);

}

/******************************************************
  clear  a monitor channel 
******************************************************/
void ca_monitor_clear_event(pchandata)
chandata *pchandata;
{
  int status;
  if (pchandata->evid) {
    status = ca_clear_event(pchandata->evid);
    ca_check_return_code(status);
    pchandata->evid = NULL;
  }
}

/************************************************************
  event been monitored event =0, not yet event =1
 ***********************************************************/
int ca_monitor_get_event(pchandata)
chandata *pchandata;
{
int event=0;
	if (pchandata->evid ) {
		if (pchandata->event ) {
		if (CA.devprflag > 0) 
			fprintf(stderr,"caEventMonitor: name=%s, value=%f, status=%d, event=%d\n",
			ca_name(pchandata->chid),pchandata->value,
			pchandata->status,pchandata->event);
		event = pchandata->event;
		pchandata->event = 0;
		}
	}
	else fprintf(stderr,"Error: %s is not monitored yet.\n",
			ca_name(pchandata->chid)); 
	return(event);
}


/******************************************************
  value change event callback 
  ******************************************************/
void ca_monitor_value_change_event(args)
     struct event_handler_args args;
{
  chandata *pchandata;
  Tcl_DString command;
  char result[100];
  
  pchandata = (chandata *)args.usr;
  
  if (CA.devprflag > 1)
    fprintf(stderr,"Old: name=%s, value=%f, stat=%d, sevr=%d, event=%d\n",
	    ca_name(pchandata->chid),
	    pchandata->value, pchandata->status,
	    pchandata->severity,pchandata->event);

/* JvZ: double -> string */
/*  pchandata->value = ((struct dbr_sts_double *)args.dbr)->value; */

  strcpy(result,((struct dbr_sts_string *)args.dbr)->value);
  pchandata->status= ((struct dbr_sts_double *)args.dbr)->status;
  pchandata->severity = ((struct dbr_sts_double *)args.dbr)->severity;
  pchandata->event = 1;
  if (CA.devprflag > 1)
    fprintf(stderr,"New: name=%s, value=%f, stat=%d, sevr=%d, event=%d\n",
	    ca_name(pchandata->chid),
	    pchandata->value, pchandata->status,
	    pchandata->severity,pchandata->event);
  
/*   sprintf(result,EPICSfloatformat,pchandata->value); */

  Tcl_DStringInit(&command);
  Tcl_DStringAppend(&command,"Control(",-1);
  Tcl_DStringAppend(&command,ca_name(pchandata->chid),-1);
  Tcl_DStringAppend(&command,")",-1);
  Tcl_SetVar(pinterp,command.string,result,TCL_GLOBAL_ONLY);
  Tcl_DStringFree(&command);
}

/******************************************************
  process event id for a monitored list and reset to 0
******************************************************/
void ca_monitor_get_event_array(noName,pvName,vals)
int noName;
char **pvName;
int *vals;
{
int i,status,command_error=0;
chandata *list,*snode;

        command_error = ca_pvlist_search(noName,pvName,&list);

        snode = list; i=0;
        while (snode)  {
                pchandata = snode;
                pchandata->type = ca_field_type(pchandata->chid);
                if (pchandata->type == TYPENOTCONN) {
                        fprintf(stderr,"%-30s  ***  device not found\n",pvName[i
]);
                        command_error = CA_FAIL;
                        }
		else  if (pchandata->evid ) {
			if (CA.devprflag > 0) 
				fprintf(stderr,"caEventMonitorList: name=%s, value=%f, status=%d, event=%d\n",
				ca_name(pchandata->chid),pchandata->value,
				pchandata->status,pchandata->event);

			 *(vals+i) = pchandata->event; 
		      if (pchandata->event ) 
				pchandata->event = 0;  /* reset after read*/
			  
			}
		else fprintf(stderr,"Error: %s is not monitored yet.\n",
			ca_name(pchandata->chid)); 
		snode = snode->next; i++;
                }

        ca_check_command_error(command_error);
}


/******************************************************
  get event values for a monitored list
******************************************************/
void ca_monitor_get_value_array(noName,pvName,vals)
int noName;
char **pvName;
double *vals;
{
int i,status,command_error=0;
chandata *list,*snode;

        command_error = ca_pvlist_search(noName,pvName,&list);

        snode = list; i=0;
        while (snode)  {
                pchandata = snode;
                pchandata->type = ca_field_type(pchandata->chid);
                if (pchandata->type == TYPENOTCONN) {
                        fprintf(stderr,"%-30s  ***  device not found\n",pvName[i
]);
                        command_error = CA_FAIL;
                        }
		else  if (pchandata->evid ) {
			if (CA.devprflag > 0) 
				fprintf(stderr,"caGetMonitorValueList: name=%s, value=%f, status=%d, event=%d\n",
				ca_name(pchandata->chid),pchandata->value,
				pchandata->status,pchandata->event);

			 *(vals+i) = pchandata->value; 
			if (pchandata->event)
				 pchandata->event = 0;  /* reset after read*/
			}
		else fprintf(stderr,"Error: %s is not monitored yet.\n",
			ca_name(pchandata->chid)); 
		snode = snode->next; i++;
                }

        ca_check_command_error(command_error);
}



/******************************************************
  get event value, status and severity  for a monitored list
******************************************************/
void ca_monitor_get_all_array(noName,pvName,vals)
int noName;
char **pvName;
double *vals;
{
int i,status,command_error=0;
chandata *list,*snode;

        command_error = ca_pvlist_search(noName,pvName,&list);

        snode = list; i=0;
        while (snode)  {
                pchandata = snode;
                pchandata->type = ca_field_type(pchandata->chid);
                if (pchandata->type == TYPENOTCONN) {
                        fprintf(stderr,"%-30s  ***  device not found\n",pvName[i
]);
                        command_error = CA_FAIL;
                        }
		else  if (pchandata->evid ) {
			if (CA.devprflag > 0) 
				fprintf(stderr,"caGetMonitorList: name=%s, value=%f, status=%d, event=%d\n",
				ca_name(pchandata->chid),pchandata->value,
				pchandata->status,pchandata->event);

			 *(vals+i*3) = pchandata->value; 
			 *(vals+i*3+1) = pchandata->status; 
			 *(vals+i*3+2) = pchandata->severity; 
			if (pchandata->event)
				 pchandata->event = 0;  /* reset after read*/
			}
			else fprintf(stderr,"Error: %s is not monitored yet.\n",
				ca_name(pchandata->chid)); 
		snode = snode->next; i++;
                }

        ca_check_command_error(command_error);
}


/******************************************************
 * check for single event for a monitored channel: return 0 or -1
 *   	-1   no event happened
 *	0    at least one value change event happened
******************************************************/
int ca_monitor_check_event(name)
char *name;
{
int EVENT = CA_FAIL;
int i,status,command_error=0;

	ca_find_dev(name,pchandata);

        if (pchandata->type == TYPENOTCONN)  
		command_error = CA_FAIL;
                        
	else  if (pchandata->evid ) {
	      if (pchandata->event ) {
			EVENT = 0;
		if (CA.devprflag > 0) 
		fprintf(stderr,"caWaitEventMonitor: name=%s, value=%f, status=%d, event=%d\n",
			ca_name(pchandata->chid),pchandata->value,
			pchandata->status,pchandata->event);
			}
		  }

        ca_check_command_error(command_error);
	return(EVENT);
}

/******************************************************
 * check any event occurs  for a monitored list : return 0 or -1
 *   	-1   no event happened
 *	0    at least one value change event happened
******************************************************/
int ca_monitor_check_event_array(noName,pvName,vals)
int noName;
char **pvName;
int *vals;
{
int EVENT = CA_FAIL;
int i,status,command_error=0;
chandata *list,*snode;

        command_error = ca_pvlist_search(noName,pvName,&list);

        snode = list; i=0;
        while (snode)  {
                pchandata = snode;
                pchandata->type = ca_field_type(pchandata->chid);
                if (pchandata->type == TYPENOTCONN) {
                        fprintf(stderr,"%-30s  ***  device not found\n",pvName[i
]);
                        command_error = CA_FAIL;
                        }
		else  if (pchandata->evid ) {
		      if (pchandata->event ) {
			EVENT = 0;
			if (CA.devprflag > 0) 
				fprintf(stderr,"caWaitEventMonitorList: name=%s, value=%f, status=%d, event=%d\n",
				ca_name(pchandata->chid),pchandata->value,
				pchandata->status,pchandata->event);

			 *(vals+i) = pchandata->event; 
			  }
			}
		snode = snode->next; i++;
                }

        ca_check_command_error(command_error);
	return(EVENT);
}


/****************************************************
 *  change connection event callback 
 ****************************************************/
void ca_connect_change_event(args)
struct connection_handler_args args;
{
chandata *pchandata;

	pchandata = (chandata *)ca_puser(args.chid);
 	if (pchandata->type != TYPENOTCONN) {
		fprintf(stderr,"****WARNING****\n");
		fprintf(stderr,"****Reconnection happend on %s ****\n",
				ca_name(pchandata->chid));
		fprintf(stderr,"****You have to wait for CA  re-connection.\n\n");
		}

}



/****************************************************
 *  add connection event for a channel
****************************************************/
void ca_connect_add_event(pchandata)
chandata *pchandata;
{
void ca_connect_change_event();
int status;

	ca_puser(pchandata->chid) = pchandata;
	ca_change_connection_event(pchandata->chid,ca_connect_change_event);
}



/**************************************************
   process ca event queue
*****************************************************/
void ca_process_CA()
{
    ca_pend_event(CA.PEND_EVENT_TIME);
}



static void registerCA(pfdctx,fd,condition)
  void *pfdctx;
  int fd;
  int condition;
{


        if (condition) {
                fdmgr_add_fd(pfdctx,fd,ca_process_CA,NULL);
                }
        else {
                fdmgr_clear_fd(pfdctx,fd);
                }
}


void caInit()
{
int status;
/*
 *  initialize channel access
 */
	status = ca_task_initialize();
	if (status != ECA_NORMAL) 
	     fprintf(stderr,"caInit: ca_task_initialize failed.\n");

/*
 *  initialize fdmgr
 */
        pfdctx = (void *) fdmgr_init();

	if (pfdctx == NULL) 
		fprintf(stderr,"caInit: fdmgr_init failed.\n");

/*
 * and add CA fd to pfdctx's input stream...
 */
        status = ca_add_fd_registration(registerCA,pfdctx);
        if (status != ECA_NORMAL)
		fprintf(stderr,"caInit: ca_add_fd_registration failed.\n");

}

caAddTimeout()
{

fprintf(stderr,"caAddTimeout\n");
	event_timeout_id = fdmgr_add_timeout(pfdctx, &timeout,
		ca_flush_io(),NULL);
}

caClearTimeout()
{
fprintf(stderr,"caClearTimeout\n");
      if (event_timeout_id) {
      fdmgr_clear_timeout(pfdctx, event_timeout_id);
	event_timeout_id = NULL;
	}

}

void caClose()
{
int status;

/* cancel registration of the CA file descriptors */

      status = ca_add_fd_registration(registerCA,pfdctx);
	if (status != ECA_NORMAL) 
		fprintf(stderr,"caClose: ca_add_fd_registration failed.\n");

/* and close channel access */

      status = ca_task_exit();
	if (status != ECA_NORMAL) 
		fprintf(stderr,"caClose: ca_task_exit failed\n");
}


