#
#   flags.mk
#   --------
#   determines the compile/archive switches
#   stolen from HY Kehayias
#   Jul 31, 1995
#
#

UNIX_OS:=$(shell uname -s)

#----------------   IRIX  -------------------
ifeq ($(UNIX_OS),IRIX)
# CFLAGS = -I$(DD_USR) -I$(DD_INC) $(DCFLAGS)  -I/usr/dist/tcl7.3 -I/usr/dist/tk3.6
CFLAGS = -I$(DD_USR) -I$(DD_INC) $(DCFLAGS) -I/PublicDomain/include -I/PublicDomain/include -DUNAME_SGI
MOTIF_LIBS = -lXm -lXt -lX11
# TCL_LIBS = /usr/dist/lib/libtk.a /usr/dist/lib/libtcl.a
TCL_LIBS = /PublicDomain/lib/libtk4.0.a /PublicDomain/lib/libtcl7.4.a

endif



#----------------   OSF1  -------------------
ifeq ($(UNIX_OS),OSF1)
CFLAGS = -I$(DD_USR) -I$(DD_INC) $(DCFLAGS) -D_LANGUAGE_C -I/PublicDomain/include -DUNAME_OSF1
TCL_LIBS = /PublicDomain/lib/libtk4.0.a /PublicDomain/lib/libtcl7.4.a
MOTIF_LIBS = -lXm -lXt -lX11
endif



#----------------- HP-UX  -------------------
#hp-ux FLAGS
ifeq ($(UNIX_OS),HP-UX)
CFLAGS = -I$(DD_USR) -I$(DD_INC) $(DCFLAGS) -Ae -D_LANGUAGE_C -I/usr/include/X11R5 -I/usr/include/Motif1.2 -I/usr/local/include -DUNAME_HPUX
MOTIF_LIBS =  -L/usr/lib/Motif1.2 -lMrm -lXm -lXt -lX11
TCL_LIBS = /usr/local/lib/libtk4.0.a /usr/local/lib/libtcl7.4.a
endif



#----------------- SunOS  -------------------
#hp-ux FLAGS
ifeq ($(UNIX_OS),SunOS)
CFLAGS = -I$(DD_USR) -I$(DD_INC) $(DCFLAGS) -g -D_LANGUAGE_C -I/usr/openwin/include -I/usr/dt/include -I/usr/local/include 
MOTIF_LIBS =  -L/usr/openwin/lib  -L/usr/dt/lib -lMrm -lXm -lXt -lX11
TCL_LIBS = $(CODA_LIB)/libtk4.0.a $(CODA_LIB)/libtcl7.4.a
EXTRA_FLAGS = -lnsl -lsocket
endif




