/*
 * dd2tcp_server :  Main server loop for dd2tcp.
 * Author        :  C.Witzig
 * Date          :  Jan 3, 1992
 * Mods          :
 *               :  Feb 15, 1996: ddns_added fifo_exist(char *fifoname)
 *               :  Apr 16, 1996: added ddns_fifo_active(char *fifoname)
 */

/*
 * This code is based on the original dd2tcp_server, but
 * has been extensivly rewritten and is no longer the
 * main program, but a subroutine.
 * The dd2tcp_server is started  by the main dd_server (and
 * not the inetd any more).
 * Note: upon creation there is no attachment to any DD 
 * system.
 *
 * The mode of operation is to read a ddn_cmd structure from the
 * socket and decide upon this command what to do.
 */
int go_on = 1;


#define _BSD_SIGNALS

#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <time.h>

#include <dd_log.h>
#include <dd_user.h>

#define TRUE 1
#define FALSE 0

extern int go_on;

/* 
 * max number of bad commands tolerated 
 */
#define MAX_NBADCMD 100

static FILE *logfile;
static char env1_string[1024];
static char env2_string[1024];

void ddns_broken_pipe(int sig)
{
  sprintf(dd_log_msg,"ddnc_broken_pipe: pipe to client broken !!! \n");
  dd_log(DD_ERROR, dd_log_msg);
  sprintf(dd_log_msg,"ddnc_broken_pipe: REINITIALISE \n");
  dd_log(DD_ERROR, dd_log_msg);
  dd_sockfd = -1;
  dd_fp = NULL;

  return;
}



/*
 * The server connects its standard output and standard error
 * to a logfile
 */


 
int open_logfile()
{
  int status;
  mode_t mode;
  time_t t;
  char filename[100];
  char *fname;
  char *hostname;

  fname = getenv("DD_LOGFILES_DIRECTORY");
  if ( fname == NULL ){
    sprintf(dd_log_msg, "dd2tcp_server %i:  LOGFILE_DIRECTORY not defined \n",getpid);
    dd_log(DD_INFO, dd_log_msg);
    fname = "/tmp";
    sprintf(dd_log_msg, "dd2tcp_server %i uses /tmp as DD_LOGFILE_DIRECTORY \n",getpid);
    dd_log(DD_INFO, dd_log_msg);
  }

  if ( (hostname = getenv("HOST")) != NULL )
    sprintf(filename, "%s/dd2tcp_server.%s.%d",fname, hostname, getpid());
  else
    sprintf(filename,"%s/dd2tcp_server.%d", fname, getpid());

  if ( (logfile = fopen(filename,"w")) == NULL){
    sprintf(dd_log_msg, "dd2tcp_server %i cannot open logfile\n",getpid);
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  mode = S_IRWXU | S_IRWXG | S_IRWXO;
  if ( ( status = chmod(filename, mode) ) != 0 ) {
    sprintf(dd_log_msg, "dd2tcp_server %i cannot change mode of logfile\n",getpid());
    dd_log(DD_ERROR, dd_log_msg);
  }

  if ( dup2(fileno(logfile),STDOUT_FILENO) < 0 ){
   sprintf(dd_log_msg, "dd2tcp_server %i cannot dup2 the logfile\n",getpid());
   dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  if ( dup2(fileno(logfile),STDERR_FILENO) < 0 ){
    sprintf(dd_log_msg, "dd2tcp_server %i cannot dup2 the logfile\n",getpid());
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  sprintf(dd_log_msg,"dd2tcp_server %6i: starts on %s \n",
           getpid(), hostname );
  dd_log(DD_INFO, dd_log_msg);
  t = time(NULL);
  sprintf(dd_log_msg,"                      : time of connection %s\n",ctime(&t));
  dd_log(DD_INFO, dd_log_msg);

  return 0;
}


/*
 * calls corresponding to the ddu_calls that the
 * server has to execute
 */

static int dduns_exists()
{
  return ddu_exists();
}

static int dduns_attach()
{
  return ddu_attach();
}

static int dduns_init()
{
  char fname[FIFO_NAME_LEN], a_name[1000], *p2c;
  int error;
  int fnamelen, env_name_len;
  struct fifo_mode fmode;
  int fctl[FIFO_HDR_CTL_LEN];

  error = FALSE;
  if (readsocket(dd_sockfd,(void*)&env_name_len, sizeof(env_name_len)) < 0){
    sprintf(dd_log_msg,"dduns_init: error in readsocket for env_name_len \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  if ( env_name_len > 0 ) {
    if (readsocket(dd_sockfd,(void*)a_name, env_name_len) < 0){
      sprintf(dd_log_msg,"dduns_init: error in readsocket for env_string \n");
      dd_log(DD_ERROR, dd_log_msg);
      error = TRUE;
    }
    if ( (p2c = strrchr(a_name,'@')) != NULL ) 
      *p2c = '\0';
    sprintf(env1_string,"DD_NAME=%s",a_name);
    if ( putenv(env1_string) ) {
      sprintf(dd_log_msg,"dduns_init: error in putenv for env_string \n");
      dd_log(DD_ERROR, dd_log_msg);
      error = TRUE;
    }
  }

  if (readsocket(dd_sockfd,(void*)&fnamelen,sizeof(fnamelen)) < 0){
    sprintf(dd_log_msg,"dduns_init: error in readsocket for fnamelen \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  if (fnamelen >= FIFO_NAME_LEN){
    sprintf(dd_log_msg,"dduns_init: fifoname too long \n");
    dd_log(DD_ERROR, dd_log_msg);
    error = TRUE;
  }

  if (readsocket(dd_sockfd,(void*)fname,fnamelen) < 0){
    sprintf(dd_log_msg,"dduns_init: error in readsocket for fnamelen \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

/* transfer fmode individually as it contains pointers */
  if (readsocket(dd_sockfd, (void*)&fmode.mode, sizeof(fmode.mode) ) < 0){
    sprintf(dd_log_msg,"dduns_init: error in readsocket for fwait \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }
  if (readsocket(dd_sockfd, (void*)&fmode.wait, sizeof(fmode.wait) ) < 0){
    sprintf(dd_log_msg,"dduns_init: error in readsocket for fwait \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }
  if (readsocket(dd_sockfd, (void*)&fmode.prescale, sizeof(fmode.prescale) ) < 0){
    sprintf(dd_log_msg,"dduns_init: error in readsocket for fwait \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }
  if (readsocket(dd_sockfd, (void*)&fmode.suser, sizeof(fmode.suser) ) < 0){
    sprintf(dd_log_msg,"dduns_init: error in readsocket for fwait \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  fmode.p2ctl = fctl;

  if (readsocket(dd_sockfd,(void*)fctl,sizeof(fctl)) < 0){
    sprintf(dd_log_msg,"dduns_init: error in readsocket for fctl \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  return ddu_init(fname,fmode);
}


static int dduns_start()
{
  return ddu_start();
}


static int dduns_stop()
{
  return ddu_stop();
}


static int  dduns_put_fev()
/*
 * Receives an event over the network and puts it into
 * the dd. Read first all the data from the socket, then
 * do the DD calls.
 */
{
  int nbytes, status;
  struct fifo_entry fev1, fev;

  if ( ddn_receive_fev(dd_sockfd, &fev1) < 0 ) {
    sprintf(dd_log_msg,"dduns_put_fev: error in ddn_receive_fev \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

/* note: fev1.len might have changed during this call */
  nbytes = 4*fev1.len;
  if (ddu_req_fev(fev1.len, &fev) < 0){
    int i, dummy;
    sprintf(dd_log_msg,"dduns_put_fev: error in ddu_req_fev\n");
    dd_log(DD_ERROR, dd_log_msg);
    for (i=0; i<nbytes/4; i++)
      readsocket(dd_sockfd, (void*)&dummy, sizeof(dummy));
    return -1;
  }

  fev.len = nbytes/4;
  fev.ctlw1 = fev1.ctlw1;
  fev.ctlb1 = fev1.ctlb1;
  fev.ctlw2 = fev1.ctlw2;
  fev.ctlb2 = fev1.ctlb2;

  if ( readsocket(dd_sockfd, (void*)fev.p2da, nbytes) < 0){
    sprintf(dd_log_msg,"dduns_put_fev: error in rec data\n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  if ( ( status = ddu_put_fev(fev)) < 0) {
    sprintf(dd_log_msg,"dduns_put_fev: error in ddu_put_fev\n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  return status;
}


static int  dduns_ins_fev()
/*
 * Inserts an event over the network and puts it into
 * the dd.
 */
{
  int nbytes, status;
  struct fifo_entry fev1,fev;

  if ( ddn_receive_fev(dd_sockfd, &fev1) < 0 ) {
    sprintf(dd_log_msg,"dduns_ins_fev: error in ddn_receive_fev \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  nbytes = 4*fev1.len;
  if (ddu_req_fev(fev1.len, &fev) < 0){
    int i, dummy;
    sprintf(dd_log_msg,"dduns_req_fev: error in ddu_req_fev\n");
    dd_log(DD_ERROR, dd_log_msg);
    for (i=0; i<nbytes/4; i++)
      readsocket(dd_sockfd, (void*) &dummy, sizeof(dummy) );
    return -1;
  }

  if ( readsocket(dd_sockfd, (void*)fev.p2da, nbytes) < 0){
    sprintf(dd_log_msg,"dduns_ins_fev: error in rec data\n");
    dd_log(DD_ERROR, dd_log_msg);
    status = -1;
  }

  fev.len = nbytes/4;
  if ( (status = ddu_ins_fev(fev)) < 0){
    sprintf(dd_log_msg,"dduns_ins_fev: error in ddu_put_fev\n");
    dd_log(DD_ERROR, dd_log_msg);
    status -1;
  }

  return status;
}


static int  dduns_brc_fev()
/*
 * Receives an event over the network and broadcasts it to
 * all the consumers on the dd system.
 */
{
  int nwait, nbytes, status;
  struct fifo_entry fev1,fev;

  if ( readsocket(dd_sockfd, (void*)&nwait, sizeof(nwait) ) < 0){
    sprintf(dd_log_msg,"dduns_brc_fev: error in readsocket \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  if ( ddn_receive_fev(dd_sockfd, &fev1) < 0 ) {
    sprintf(dd_log_msg,"dduns_brc_fev: error in ddn_receive_fev \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  nbytes = 4*fev1.len;
  if (ddu_req_fev(fev1.len, &fev) < 0){
    int i, dummy;
    sprintf(dd_log_msg,"dduns_brc_fev: error in ddu_req_fev\n");
    dd_log(DD_ERROR, dd_log_msg);
    for (i=0; i<nbytes/4; i++)
      readsocket(dd_sockfd, (void*) &dummy, sizeof(dummy) );
    return -1;
  }
  fev.len = nbytes/4;
  fev.ctlw2 = BROADCAST_MARKER;

  if ( (status = ddu_brc_fev(fev, nwait)) < 0){
    sprintf(dd_log_msg,"dduns_brc_fev: error in ddu_put_fev\n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  return status;
}


static int dduns_get_fev()
/*
 * gets an event from the dd and sends it over the network.
 * In case of a positive return code from ddu_get_fev, send
 * a zero event length, and a positive status afterwards.
 */
{
  int status;
  struct fifo_entry fev;

  if ( (status = ddu_get_fev(&fev)) != 0) {
    fev.len = 0;
    if (status < 0) {
      sprintf(dd_log_msg,"dduns_get_fev: error in ddu_get_fev \n");
      dd_log(DD_ERROR, dd_log_msg);
    }
  }
  
  if ( ddn_send_fev(dd_sockfd, fev) < 0 ) {
    sprintf(dd_log_msg,"dduns_get_fev: error in writesocket \n");
    dd_log(DD_ERROR, dd_log_msg);
    status = -1;
  }

  else if (fev.len > 0){

    if ( writesocket(dd_sockfd, (void*)fev.p2da,4*fev.len, ddn_trf_usrdata) < 0){
      sprintf(dd_log_msg,"dduns_get_fev: error in writesocket \n");
      dd_log(DD_ERROR, dd_log_msg);
      status = -1;
    }

    if (ddu_put_fev(fev) < 0){
      sprintf(dd_log_msg,"ddsn_get_fev: error in ddu_put_fev\n");
      dd_log(DD_ERROR, dd_log_msg);
      status = -1;
    }
  }
  
  return status;
}

static int dduns_close()
{
  return ddu_close();
}


static int dduns_set_brc()
{
  int brc_flag;

  if (readsocket(dd_sockfd,(void*)&brc_flag,sizeof(brc_flag)) < 0){
    sprintf(dd_log_msg,"dduns_set_brc: error in readsocket for brcflag %s \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  sprintf(dd_log_msg,"server %i: set broadcast flag to %i\n",getpid(),brc_flag);
  dd_log(DD_INFO, dd_log_msg);

  return ddu_set_brc(brc_flag);
}


static int dduns_set_protection()
{
  int protection;

  if (readsocket(dd_sockfd,(void*)&protection,sizeof(protection)) < 0){
    sprintf(dd_log_msg,"dduns_set_protection: error in readsocket for protection %s \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  return ddu_set_protection(protection);
}

static int dduns_set_dd_wait()
{
  int dd_wait;

  if (readsocket(dd_sockfd,(void*)&dd_wait,sizeof(dd_wait)) < 0){
    sprintf(dd_log_msg,"dduns_set_dd_wait: error in readsocket for dd_wait %s \n");
    dd_log(DD_ERROR, dd_log_msg);
   return -1;
  }

  return ddu_set_dd_wait(dd_wait);
}

static int dduns_set_netswap()
{
  int swap;

  if (readsocket(dd_sockfd,(void*)&swap,sizeof(swap)) < 0){
    sprintf(dd_log_msg,"dduns_set_netswap: error in readsocket for dd_set_netswap %s \n");
    dd_log(DD_ERROR, dd_log_msg);
   return -1;
  }

  return ddu_set_netswap(swap);
}


static int dduns_get_free_buffers()
{
  return ddu_get_free_buffers();
}

static int dduns_fifo_exist(int nbytes)
{
  int status;
  char fifoname[FIFO_NAME_LEN];

  if (readsocket(dd_sockfd,(void*)fifoname, nbytes) < 0){
    sprintf(dd_log_msg,"dduns_fifo_exist: error in readsocket for fifoname \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  return ddu_fifo_exist(fifoname);
}

static int dduns_fifo_active(int nbytes)
{
  int status;
  char fifoname[FIFO_NAME_LEN];

  if (readsocket(dd_sockfd,(void*)fifoname, nbytes) < 0){
    sprintf(dd_log_msg,"dduns_fifo_exist: error in readsocket for fifoname \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  return ddu_fifo_active(fifoname);
}



static int dduns_set_reqcnt()
{
  int req_cnt;

  if (readsocket(dd_sockfd,(void*)&req_cnt,sizeof(req_cnt)) < 0){
    sprintf(dd_log_msg,"dduns_set_reqcnt: error in readsocket for req_cnt %s \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

  return ddu_set_reqcnt(req_cnt);
}


static int ddns_test_link(int nbytes)
{
  int i;

  if (readsocket(dd_sockfd, test_data_rec, nbytes) < 0 ){
    sprintf(dd_log_msg,"ddns_test_link: error in read \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }

/*
  for (i=0; i<nbytes/4; i++)
    sprintf(dd_log_msg, "test data %i %i \n",i,test_data_rec[i]);
    dd_log(DD_ERROR, dd_log_msg);
*/

  if (writesocket(dd_sockfd, test_data_rec, nbytes, DDN_TRF_LONG) < 0 ){
    sprintf(dd_log_msg,"ddnc_close: error in write \n");
    dd_log(DD_ERROR, dd_log_msg);
    return -1;
  }
  fflush(dd_fp);

  return 0;
}


static int dduns_put_nfev(int n_fev)
{
  int ifev, trf_header, nbytes, status;
  struct fifo_entry fev[DDN_TRF_MAXNFEV], fev1;

  for (ifev = 0; ifev < n_fev; ifev++) {
    
    if ( readsocket(dd_sockfd, &trf_header, sizeof(trf_header) ) < 0 ) {
      sprintf(dd_log_msg, "dduns_put_nfev: error in readsocket for trf_header\n");
      dd_log(DD_ERROR, dd_log_msg);
      return -1;
    }
    
    if ( trf_header != DDN_TRF_HEADER ) {
      sprintf(dd_log_msg, "dduns_put_nfev: error in trf_header %x instead of %x\n",
              trf_header, DDN_TRF_HEADER);
      dd_log(DD_ERROR, dd_log_msg);
      return -1;
    }

    if ( ddn_receive_fev(dd_sockfd, &fev[ifev]) < 0 ) {
      sprintf(dd_log_msg,"dduns_put_nfev: error in readsocket \n");
      dd_log(DD_ERROR, dd_log_msg);
      return -1;
    }
    nbytes = 4*fev[ifev].len;
    fev1.ctlw1 = fev[ifev].ctlw1;
    fev1.ctlb1 = fev[ifev].ctlb1;
    fev1.ctlw2 = fev[ifev].ctlw2;
    fev1.ctlb2 = fev[ifev].ctlb2;

    if (ddu_req_fev(fev[ifev].len, &fev[ifev]) < 0){
      int i, dummy;
      sprintf(dd_log_msg,"dduns_put_nfev: error in ddu_req_nfev\n");
      dd_log(DD_ERROR, dd_log_msg);
      for (i=0; i<nbytes/4; i++)
        readsocket(dd_sockfd, (void*)&dummy, sizeof(dummy));
      return -1;
    }

    fev[ifev].len = nbytes/4;
    fev[ifev].ctlw1 = fev1.ctlw1;
    fev[ifev].ctlb1 = fev1.ctlb1;
    fev[ifev].ctlw2 = fev1.ctlw2;
    fev[ifev].ctlb2 = fev1.ctlb2;

    if ( readsocket(dd_sockfd, (void*)fev[ifev].p2da, nbytes) < 0){
      sprintf(dd_log_msg,"dduns_put_nfev: error in rec data\n");
      dd_log(DD_ERROR, dd_log_msg);
      return -1;
    }

    if ( ( status = ddu_put_fev(fev[ifev])) < 0) {
      sprintf(dd_log_msg,"dduns_put_nfev: error in ddu_put_nfev\n");
      dd_log(DD_ERROR, dd_log_msg);
     return -1;
    }

  }

  return status;
}




/*
 * dds routines over the net
 */

static int ddsns_create()
{
/*
 * Read the environment variables from the socket
 * and call dds_create
 */
  static char dd_name[1024], dd_configuration[1024];

  int len, error = FALSE;
  char env_name[1024], *p2c;

  if ( readsocket(dd_sockfd, (void*) &len, sizeof(len) ) < 0 ) {
    sprintf(dd_log_msg,"ddsns_create: error in readsocket for env_string \n");
    dd_log(DD_ERROR, dd_log_msg);
    error = TRUE;
  }
  if ( len > 0 ) {
    if (readsocket(dd_sockfd,(void*)env_name, len) < 0){
      sprintf(dd_log_msg,"dduns_init: error in readsocket for env_string \n");
      dd_log(DD_ERROR, dd_log_msg);
      error = TRUE;
    }
    sprintf(dd_name,"DD_NAME=%s", env_name);
    if ( (p2c = strrchr(dd_name,'@')) != NULL )
      *p2c = '\0';
    if ( putenv(dd_name) ) {
      sprintf(dd_log_msg,"ddsns_create: error in putenv for env_string \n");
      dd_log(DD_ERROR, dd_log_msg);
     error = TRUE;
    }
  }

  if ( readsocket(dd_sockfd, (void*) &len, sizeof(len) ) < 0 ) {
    sprintf(dd_log_msg,"ddsns_create: error in readsocket for env_string \n");
    dd_log(DD_ERROR, dd_log_msg);
    error = TRUE;
  }
  if ( len > 0 ) {
    if (readsocket(dd_sockfd,(void*)env_name, len) < 0){
      sprintf(dd_log_msg,"dduns_init: error in readsocket for env_string \n");
      dd_log(DD_ERROR, dd_log_msg);
     error = TRUE;
    }
    sprintf(dd_configuration,"DD_CONFIGURATION=%s", env_name);
    if ( putenv(dd_configuration) ) {
      sprintf(dd_log_msg,"ddsns_create: error in putenv for env_string \n");
      dd_log(DD_ERROR, dd_log_msg);
      error = TRUE;
    }
  }

  return (error) ? -1 : dds_create();
}

static int ddsns_init()
{
  return dds_init();
}

static int ddsns_wait4proc(int ntime_ms)
{
  return dds_wait4proc(ntime_ms);
}

static int ddsns_wakeup()
{
  return dds_wakeup();
}

static int ddsns_prepare_shutdown()
{
  return dds_prepare_shutdown();
}

static int ddsns_reset()
{
  return dds_reset();
}

static int ddsns_flush(int brc_flush)
{
  printf("calling dds_flush\n");
  fflush(stdout);
  return dds_flush(brc_flush);
}

static int ddsns_close(int enforce)
{
  return dds_close();
}



/*
 * process handler: calls the ddXns_xxx routines
 */

static int process_ddn_cmd(struct ddn_cmd ddn_cmd)
{
  static int nbadcmd = 0;
  int status;

/*
 * DDU_xxx routines
 */
  if (ddn_cmd.cmd == DDN_CMD_ATTACH){
    status = dduns_attach();
  }
  else if (ddn_cmd.cmd == DDN_CMD_EXISTS){
    status = dduns_exists();
  }
  else if (ddn_cmd.cmd == DDN_CMD_INIT){
    status = dduns_init();
  }
  else if (ddn_cmd.cmd == DDN_CMD_START){
    status = dduns_start();
  }
  else if (ddn_cmd.cmd == DDN_CMD_STOP){
    status = dduns_stop();
  }
  else if (ddn_cmd.cmd == DDN_CMD_GET_FEV){
    status = dduns_get_fev();
  }
/*
 * a place holder for future extensions...
  else if (ddn_cmd.cmd == DDN_CMD_GET_NFEV){
    status = dduns_get_nfev(ddn_cmd.len);
  }
*/
  else if (ddn_cmd.cmd == DDN_CMD_PUT_FEV){
    status = dduns_put_fev();
  }
  else if (ddn_cmd.cmd == DDN_CMD_PUT_NFEV){
    status = dduns_put_nfev(ddn_cmd.len);
  }
  else if (ddn_cmd.cmd == DDN_CMD_INS_FEV){
    status = dduns_ins_fev();
  }
  else if (ddn_cmd.cmd == DDN_CMD_BRC_FEV){
    status = dduns_brc_fev();
  }
  else if (ddn_cmd.cmd == DDN_CMD_SET_BRC) {
    status = dduns_set_brc();
  }
  else if (ddn_cmd.cmd == DDN_CMD_SET_REQCNT){
    status = dduns_set_reqcnt();
  }
  else if (ddn_cmd.cmd == DDN_CMD_SET_PROTECTION){
    status = dduns_set_protection();
  }
  else if (ddn_cmd.cmd == DDN_CMD_SET_DD_WAIT){
    status = dduns_set_dd_wait();
  }
  else if (ddn_cmd.cmd == DDN_CMD_SET_NETSWAP){
    status = dduns_set_netswap();
  }
  else if ( ddn_cmd.cmd == DDN_CMD_GET_FREE_BUFFERS) {
    status = dduns_get_free_buffers();
  }
  else if ( ddn_cmd.cmd == DDN_CMD_FIFO_EXIST) {
    status = dduns_fifo_exist(ddn_cmd.len);
  }
  else if ( ddn_cmd.cmd == DDN_CMD_FIFO_ACTIVE) {
    status = dduns_fifo_active(ddn_cmd.len);
  }
  else if (ddn_cmd.cmd == DDN_CMD_CLOSE){
    status = dduns_close();
  }
  else if ( ddn_cmd.cmd == DDN_CMD_EXIT ) {
    sprintf(dd_log_msg, "dd2tcp_server: %d: exit command received \n",getpid());
    dd_log(DD_ERROR, dd_log_msg);
  }

/*
 * DDS_xxx routines
 */
  else if ( ddn_cmd.cmd == DDSN_CMD_CREATE) {
    status = ddsns_create();
  }
  else if ( ddn_cmd.cmd == DDSN_CMD_INIT) {
    status = ddsns_init();
  }
  else if ( ddn_cmd.cmd == DDSN_CMD_WAIT4PROC) {
    status = ddsns_wait4proc(ddn_cmd.len);
  }
  else if ( ddn_cmd.cmd == DDSN_CMD_WAKEUP) {
    status = ddsns_wakeup();
  }
  else if ( ddn_cmd.cmd == DDSN_CMD_PREPARE_SHUTDOWN) {
    status = ddsns_prepare_shutdown();
  }
  else if ( ddn_cmd.cmd == DDSN_CMD_RESET) {
    status = ddsns_reset();
  }
  else if ( ddn_cmd.cmd == DDSN_CMD_FLUSH) {
    status = ddsns_flush(ddn_cmd.len);
  }
  else if ( ddn_cmd.cmd == DDSN_CMD_CLOSE) {
    status = ddsns_close(ddn_cmd.len);
  }

/*
 * other
 */
  else if (ddn_cmd.cmd == DDN_CMD_TEST_TRF){
    status = ddns_test_link(ddn_cmd.len);
    if ( status ) {
      sprintf(dd_log_msg,"dd2tcp_server: error in ddns_test_link");
      dd_log(DD_ERROR, dd_log_msg);
    }
  }
  else {
    nbadcmd++;
    sprintf(dd_log_msg,"dd2tcp_server %6i: unknown command received %x %d\n",
            getpid(), ddn_cmd.cmd);
    dd_log(DD_ERROR, dd_log_msg);
    status = 1;
    if ( nbadcmd > MAX_NBADCMD ){
      sprintf(dd_log_msg,"dd2tcp_server %6i: exit as max bad cmd received\n",
              getpid());
      dd_log(DD_ERROR, dd_log_msg);
     status = -1;
    }
  }
/*  
  sprintf(dd_log_msg, "dd_server pid: %d processed cmd %d status = %d\n",getpid(),ddn_cmd.cmd,status); 
  dd_log(DD_ERROR, dd_log_msg);
*/
  return status;
}


/* Added by CTCTCT in order for dd2tcp_server to die gracefully */
static void
dd2tcp_sighandler (int sig)
{
/*
  printf("Going thru signal handler for dd2tcp_server.\n");
  printf("signal %d received\n", sig);
*/
  go_on = FALSE;
  return;
}


void dd2tcp_server()
{
  /* int go_on; */
  int i, status, iread;
  struct ddn_cmd ddn_cmd;
  time_t t;

  /* Added by CTCTCT in order to die gracefully */
  signal(SIGHUP,  dd2tcp_sighandler);
  signal(SIGINT,  dd2tcp_sighandler);
  signal(SIGQUIT, dd2tcp_sighandler);
  signal(SIGTERM, dd2tcp_sighandler);

  i_am_dd2tcp_server = TRUE;
  go_on = TRUE;
  open_logfile();

  signal(SIGPIPE, ddns_broken_pipe);

  /* Get open socket descriptor "dd_sockfd" & turn it into a file descriptor
   * with fdopen command for reading. Store fp in dd_fp. CTCTCT */
  if ( ddn_set_dd_fp() ) {
    sprintf(dd_log_msg,"dd2tcp_server: ddn_set_dd_fp failed\n");
    dd_log(DD_ERROR, dd_log_msg);
   return;
  }

  /* set variable byte_swapping (0 if none, 1 otherwise) CTCTCT */
  ddn_set_byte_swapping();

  do {
    int *p_i = (int*) &ddn_cmd;
    fflush(stdout);

    /* Read data into p_i with "read", byte swapping taken care of. CTCTCT */
    if ( readsocket(dd_sockfd, p_i, sizeof(struct ddn_cmd)) ) {
      sprintf(dd_log_msg,"dd2tcp_server pid %i: error in reading ddn_cmd \n",
              getpid());
      dd_log(DD_ERROR, dd_log_msg);
      go_on = FALSE;
    } 

    else if ( ddn_cmd.header != DDN_HEADER ) {
      sprintf(dd_log_msg,"dd2tcp_server pid %i: header %x = %d not found \n",
              getpid(),ddn_cmd.header, ddn_cmd.header);
      dd_log(DD_ERROR, dd_log_msg);
      sprintf(dd_log_msg,"dd2tcp_server pid %i: command %x %x %x \n",
              getpid(), ddn_cmd.header, ddn_cmd.cmd, ddn_cmd.len);
      dd_log(DD_ERROR, dd_log_msg);
      go_on = FALSE;
    }
/*  
 *  a valid command received 
 */
    else{
      if ( ddn_cmd.cmd == DDN_CMD_EXIT ) {
        go_on = FALSE;
        status = 0;
      }
      else {
        if ( (status = process_ddn_cmd(ddn_cmd)) < 0 ) {
          sprintf(dd_log_msg, "dd_server: cmd=%d BAD STATUS=%d \n", ddn_cmd.cmd, status);
          dd_log(DD_ERROR, dd_log_msg);
          go_on = FALSE;
        }
        writesocket(dd_sockfd, &status, sizeof(status), DDN_TRF_LONG);
        fflush(dd_fp);
      }
    }
  } while ( go_on );

  if ( ddu_attached() ) {
    dduns_stop();
    dduns_close();
  }

  t = time(NULL);
  sprintf(dd_log_msg,"dd2tcp_server pid %i : host %s to peer %s exit at %s \n",
          getpid(), my_hostname, dd_peername,ctime(&t));
  dd_log(DD_INFO, dd_log_msg);

  fclose(logfile);

  return;
}
