/*
 * dd_log    : DD logging routine
 *           : instead of calling printf or whatever 
 *           : the DD code calls dd_report which currently
 *           : is a simple printf statement.
 *           : It allows to customize the code and 
 *           : redirect the error messages to whereever
 *           : the user wants. This might be of interest
 *           : in a distributed system.
 *           :
 * Author    :  C.Witzig
 * Date      :  Jan 17, 1996
 * Mods      :
 */


#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <dd_log.h>

char dd_log_msg[DD_MAX_LOG_MSG];

void dd_log(int level, char *info)
{
  if ( level == DD_INFO ) {
    fprintf(stdout, "DD proc pid:%d : %s", getpid(), info);
    fflush(stdout);
  }
  else{
    fprintf(stderr, "DD proc pid:%d : %s", getpid(), info);
    fflush(stderr);
  }
  return;
}

