/* 
 * tkAppInit.c --
 */

#include <tk.h>


#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include <signal.h>
#include <string.h>
#include <fcntl.h>

#include <dd_user.h>

#define TIME_MS 1000

Tcl_Interp *my_interp;	     

int status[MAX_FIFO_NB_MAX], cnt[MAX_FIFO_NB_MAX]; 
int devin[MAX_FIFO_NB_MAX], devout[MAX_FIFO_NB_MAX];
static char *fifo_status[] = { "unused", "idle  ","active"};


int active_fifos(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[])
{
  int i;
  char fifo_list[1024], cfifo[4];

  strcpy(fifo_list,"");
  if (fifo_rate(status, cnt, devin, devout) == 0){
    for (i=0; i<dd_dcom->dd_config.max_fifo_nb; i++) {
      if ( status[i] != FSTAT_UNUSED ){ 
	sprintf(cfifo,"%d ",i);
	strcat(fifo_list,cfifo);
      }
    }
  }
  fifo_list[strlen(fifo_list)] = '\0';
  interp->result = fifo_list;

  return TCL_OK;
}

int get_fifo_info(ClientData clientdata, Tcl_Interp *interp, int argc, char *argv[])
{
  extern struct a_fifo *fifo_shm_start;
  struct a_fifo *p;
  int ififo, delta_t;
  char info[1024];

  if ( argc != 2 ) {
    interp->result = "wrong # arguments";
    return TCL_ERROR;
  }
 
  delta_t = TIME_MS/1000 ;
  if ( delta_t <= 0 )
    delta_t = 1;
  ififo = atoi(argv[1]);
  p = fifo_shm_start + ififo;
  sprintf(info,"%s %s %d %d %d",p->fhdr.fname,fifo_status[p->fhdr.fstatus],
	  cnt[ififo],devin[ififo]/delta_t, devout[ififo]/delta_t);
  
  interp->result = info;

  return TCL_OK;
}

void update(ClientData clientData)
{
  Tcl_Eval(my_interp, "update_fifos");
  
  Tk_CreateTimerHandler(TIME_MS, &update, (ClientData)NULL);
}


int
Tcl_AppInit(interp)
    Tcl_Interp *interp;	     
{
    Tk_Window main;

    my_interp = interp;

    main = Tk_MainWindow(interp);
    
    if (Tcl_Init(interp) == TCL_ERROR) {
      return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
      return TCL_ERROR;
    }
    
    if ( ddu_attach() ) {
      printf("cannot attach to the DD system\n");
      exit(1);
    }

    /*
     *  define TCL commands
     */
    Tcl_CreateCommand(interp, "active_fifos", active_fifos,
		      (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);
    Tcl_CreateCommand(interp, "get_fifo_info", get_fifo_info,
		      (ClientData)NULL, (Tcl_CmdDeleteProc*)NULL);

    Tk_CreateTimerHandler(TIME_MS, &update, (ClientData)NULL);


    tcl_RcFileName = "~/.wishrc";
    return TCL_OK;
}


int main(int argc, char **argv)
{
  Tk_Main(argc, argv, Tcl_AppInit);
  return 0;
}

