/*
 * dd2tcp_client :  Test client program for dd2tcp.
 * Author        :  C.Witzig
 * Date          :  May 13, 1992
 * Mods          :
 *               :  updated April 11, 1995 to incorproate
 *                  numerous changes in the DD system
 */

#define _BSD_SIGNALS
#include <sys/types.h>
#include <sys/socket.h>
#include <signal.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

#include <dd_user.h>

#define TRUE 1
#define FALSE 0

main(argc,argv)
    int argc;
    char **argv;
{
  int ival, prot;
  int go_on,icmd;
  int status;
  int i, imax, len, iloop, nloop;
  char cmd[80],what[80],what1[80];

  char *cfname;
  char *cfmode;
  char *cfwait;
  char *cfprescale;
  struct fifo_mode fmode;
  int ctl[FIFO_HDR_CTL_LEN];
  char filename[80];
  FILE *fp;

  struct fifo_entry fev;
  int dummy_event[10];

  cfname = getenv("FIFONAME");
  cfmode = getenv("FIFOMODE");
  cfwait = getenv("FIFOWAIT");
  cfprescale = getenv("FIFOPRESCALE");

  if (cfname == NULL){
    printf("you must specify at least the FIFONAME!!!\n");
    exit(1);
  }
  if (cfmode == NULL)
    cfmode = "ALL";
  if (cfwait == NULL)
    cfwait = "SLEEP";

  if (strstr(cfname,"INPUT") != NULL){
    fmode.mode = FMODE_ALL;
    fmode.wait = FWAIT_SLEEP;
    fmode.prescale = 1;
    fmode.suser = FMODE_MULTI_USER;
    fmode.p2ctl = ctl;
    for (i = 0;i<FIFO_HDR_CTL_LEN;i++)
      ctl[i]=0;
  }
  else{
    if (strcmp(cfmode,"ALL") == 0){
      fmode.mode = FMODE_ALL;
      for (i=0;i<FIFO_HDR_CTL_LEN;i++)
	ctl[i] = -1;
    }
    else if (strcmp(cfmode,"COND") == 0){
      fmode.mode = FMODE_COND;
      strcpy(filename,cfname);
      strcat(filename,"_COND.DAT");
      fp = fopen(filename,"r");
      for (i=0;i<FIFO_HDR_CTL_LEN;i++)
        fscanf(fp,"%i",&ctl[i]);
      fclose(fp);
    }
    else if (strcmp(cfmode,"ONREQUEST") == 0){
      fmode.mode = FMODE_ONREQ;
      for (i = 0;i<FIFO_HDR_CTL_LEN;i++)
	ctl[i]=0;
    }
    else{
      printf(" ddinit_: unknown fifo mode \n");
		exit(1);
    }
    if (strcmp(cfwait,"SLEEP") == 0)
      fmode.wait = FWAIT_SLEEP;
    else if (strcmp(cfwait,"ASYNC") == 0)
      fmode.wait = FWAIT_ASYNC;
    else{
      printf(" ddinit_: unknown fifo wait mode \n");
		exit(1);
    }
  }
  if ( cfprescale ) 
    fmode.prescale = atoi(cfprescale);
  else
    fmode.prescale = 1;

  if ( (status = ddu_init(cfname, fmode) ) < 0 ){
    printf(" ddinit_: ddu_init failed - status %i \n",status);
	 exit(1);
  }

  printf(" type help for help\n");

  go_on = TRUE;

  while(go_on){
    if (gets(what) == NULL ){
      if (errno != EINTR) {
	printf(" main: gets");
	go_on = FALSE;
      }
    }
    else if ( ddu_attached() ) {

      if (strstr(what,"init")){
	status = ddu_init(cfname,fmode );
	printf("ddu_init: status returned %i \n",status);
      }

      else if (strstr(what,"sta")){
	status = ddu_start();
	printf("ddu_start: status returned %i \n",status);
      }

      else if (strstr(what,"sto")){
	status = ddu_stop();
	printf("ddu_stop: status returned %i \n",status);
      }

      else if ( strstr(what,"prot")) {
	printf("enter fifo protection: 0=noprotection, 1=protection\n");
	scanf("%d",&prot);
	status = ddu_set_protection(prot);
	printf("ddu_set_protection: status %d\n",status);
      }

      else if (strstr(what,"test")){
	sscanf(what,"%s %i",what1,&nloop);
	iloop = 0;
	status = 0;
	system("date");
	while ( (iloop<nloop) && !(status) ){
	  status = ddnc_test_link();
	  iloop++;
	  if ( (iloop%10) == 0)
	    printf("NETWORK TEST: now I am at iteration %i \n",iloop);
	}
	system("date");
	printf("NETWORK TEST: finished with %i iterations \n",iloop);
      }

      else if (strstr(what,"fput")){
	len = sizeof(dummy_event)/4;
	ddu_req_fev(len,&fev);
	fev.len = 10;
	fev.p2da = dummy_event;
	for (i=0;i<sizeof(dummy_event)/4;i++)
	  dummy_event[i] = i;
	status = ddu_put_fev(fev);
	printf("ddu_put_fev: status returned %i \n",status);
      }

      else if (strstr(what,"fget")){
	status = ddu_get_fev(&fev);
	printf("ddu_get_fev: status returned %i \n", status);
	if (status == 0){
	  printf("fev returned: len %5i p2da %p ctlw1 %9i ctlb1 %9x \n",
		 fev.len, fev.p2da, fev.ctlw1, fev.ctlb1);
	  printf("\nevent:\n");
	  imax = (fev.len > 25) ? 100 : fev.len ;
	  for (i=0;i<imax;i++)
	    printf("loc - data %5i %9x %9x %9x %9x %9x \n",
		   i,*fev.p2da,*fev.p2da++,*fev.p2da++,*fev.p2da++,*fev.p2da++);
	}
      }

      else if (strstr(what,"mput")){
	sscanf(what,"%s %i",what1,&nloop);
	len = sizeof(dummy_event)/4;
	ddu_req_fev(len,&fev);
	fev.len = 10;
	fev.p2da = dummy_event;
	for (i=0;i<sizeof(dummy_event)/4;i++)
	  dummy_event[i] = i;
	iloop = 0;
	status = 0;
	system("date");
	while ( (iloop<nloop) && !(status) ){
	  status = ddu_put_fev(fev);
	  iloop++;
	  if ( (iloop%100) == 0)
	    printf("fev put loop: now I am at iteration %i \n",iloop);
	}
	system("date");
	printf("fev put loop: finished with %i iterations \n",iloop);
      }

      else if (strstr(what,"mget")){
	int nevt_rec = 0;
	sscanf(what,"%s %i",what1,&nloop);
	iloop = 0;
	status = 0;
	system("date");
	while ( (iloop<nloop) && (status>=0) ){
	  status = ddu_get_fev(&fev);
	  if ( status == 0 )
	    nevt_rec++;
	  iloop++;
	  if ( (iloop%100) == 0)
	    printf("fev put loop: now I am at iteration %i nb events rec %d\n",iloop,nevt_rec);
	}
	system("date");
	printf("fev put loop: finished with %i iterations \n",iloop);
      }
      
      else if (strstr(what,"exi")){
	ddu_close();
	go_on = FALSE;
      }

      else if (strstr(what,"hel")){
	printf("\n\n HELP for dd2tcp_client test program \n");
	printf("********************************************\n\n");
	printf("type init ...... to initialise the FIFOs at server end \n");
	printf("     start ..... to start server at FIFO \n");
	printf("     stop ...... to stop server at FIFO \n");
	printf("     fput ...... to put a fev over the network into the FIFO\n");
	printf("     fget ...... to get a fev over the network from the FIFO\n");
	printf("     mget 'i' .. to call fput i times \n");
	printf("     mput 'i' .. to call fget i times \n");
	printf("     test 'i' .. to send i buffers back and forth over the network \n");
	printf("     exit ...... to go home! \n");
      }

      else
	printf("I do not know this command - type help for help\n");
    }
    else{
      printf("ddu no longer attached - exit now\n");
      go_on = FALSE;
    }
  }
  exit(0);
}

