/*
 * dd_ctl.c : This program is the main control program for the DD
 *          : system. It is used in two different ways:
 *          : 1. Directly from DUI. 
 *          : 2. As a server to the standalone dd_ui program.
 *          : Note: the difference between "exit" and "quit" command:
 *          :       exit is used by DUI and removes the DD completely.
 *          :       quit is used by dd_ui and only deattaches from the DD.  
 *
 * Author   :  C.Witzig
 * Date     :  Apr ?, 1992
 * 
 * D.Abbot CEBAF used this as a consumer for this performance
 * measurements 
 *
 */

#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/times.h>
#include <limits.h>
#include <signal.h>
#include <dd_sys.h>
#include <dd_user.h>

#define TRUE 1
#define FALSE 0

int go_on;

void
sig_handler (int sig)
{
  go_on = 0;
  return;
}

main(int argc,char **argv)
{
  int i,i1,i2,i3;
  int *p;
  int j,len, dump, data_flag, error;
  int iprint;
  void show_sys();
  int status;
  char what2do[100];
  char what1[100],what2[100],what3[100], answer;
  char fname[100];
  int mode, req_fail_cnt, prescale, wait,ctl[4];
  int imax;
  struct fifo_entry fev, fev_example;
  struct tms stime, etime;
  time_t stime1, etime1;
  struct fifo_mode fmode;

  if (argc < 2) {
    printf("syntax: dd_test_c <fifo name>\n");
    exit(0);
  }

  strcpy(fname,argv[1]);

  fmode.mode = FMODE_ALL;
  fmode.wait = DD_WAIT_ASYNC;
  fmode.prescale = 1;
  fmode.suser = FMODE_SINGLE_USER;
  fmode.p2ctl = ctl;

  ctl[0] = -1;
  ctl[1] = -1;
  ctl[2] = -1;
  ctl[3] = -1;


  if ( (status = ddu_init(fname, fmode)) != 0 ) {
    printf("ddu_init: status returned %d\n",status);
    exit(1);
  }

  signal (SIGKILL, sig_handler);
  signal (SIGINT, sig_handler);

  ddu_start();
  printf("start done\n");
  go_on = 1;
  dump = 0;
  i=0;
  iprint = 100000;
  req_fail_cnt = 0;

  imax = 1000000;

  system("date");
  times(&stime);
  time(&stime1);
  while (go_on ){
    double t1, t2, t,r;

    if ( i == imax )
      go_on = FALSE;

    status = ddu_get_fev(&fev);
    if ( status < 0 ) {
      go_on = FALSE;
    }
    else if (status == 0){
      if ( (status = ddu_put_fev(fev)) != 0 ) {
	printf("ddu_put_fev: status returned %d\n",status);
	go_on = FALSE;
      }
      
      i++;

      if ( i%iprint == 0 ) {
	times(&etime);
	time(&etime1);

	t1 = etime1 - stime1;
        t = (etime.tms_utime + etime.tms_stime) - (stime.tms_utime + stime.tms_stime);
	r = 100.0 * (etime.tms_utime - stime.tms_utime) / t;
	t = t / ((double)CLK_TCK);
	printf("event: %d fail count: %d time: %6.2f Sec - CPU user/tot %6.1f rate1 %6.1f ev/sec  rate2 %6.1f \n",
	       i, req_fail_cnt, t,r,iprint/t,iprint/t1);
	stime = etime;
	stime1 = etime1;

/*	printf("%d %d %d %d\n",etime.time, etime.millitm, stime.time, stime.millitm); 
	t = (etime.time - stime.time) + (etime.millitm - stime.millitm)/1000.0;
	r = ((fev.len) * 4.0 * 10000.0)/t;
	printf("event %8d  %f Sec/10000 %f kB/S\n",i,t,r);
	bcopy(&etime,&stime,sizeof(struct timeb));
*/
      }
    }
    else{
      req_fail_cnt++;
      if ( req_fail_cnt < 10 )
	printf("ddu_get_fev: no event received %d\n",req_fail_cnt);
    }
  }
  ddu_stop();
  ddu_close();
  return;
}
       


