#ifndef DD_NETWORK_H
#define DD_NETWORK_H


/*
 * dd_network.h   :  Header file for the dd network calls
 * Author         :  C.Witzig
 * Date           :  May 11, 1992
 *
 * Mods           :  Updated Jan 6, 1996 (general network upgrade)
 */


#define DD_SERVER_TCP_PORT 6499


/*
 * commands between the client and the server 
 */

#define DDN_CMD_ATTACH            1
#define DDN_CMD_INIT              2
#define DDN_CMD_START             3
#define DDN_CMD_STOP              4
#define DDN_CMD_PUT_FEV           5
#define DDN_CMD_GET_FEV           6
#define DDN_CMD_INS_FEV           7
#define DDN_CMD_BRC_FEV           8
#define DDN_CMD_SET_BRC           9
#define DDN_CMD_SET_REQCNT       10
#define DDN_CMD_GET_FREE_BUFFERS 11
#define DDN_CMD_FIFO_EXIST       12
#define DDN_CMD_FIFO_ACTIVE      13
#define DDN_CMD_SET_PROTECTION   14
#define DDN_CMD_SET_DD_WAIT      15
#define DDN_CMD_SET_NETSWAP      16
#define DDN_CMD_CLOSE            17
#define DDN_CMD_TEST_TRF         18
#define DDN_CMD_EXIT             19
#define DDN_CMD_PUT_NFEV         20
#define DDN_CMD_GET_NFEV         21
#define DDN_CMD_EXISTS           22

#define DDSN_CMD_CREATE         32
#define DDSN_CMD_INIT           33
#define DDSN_CMD_WAIT4PROC      34
#define DDSN_CMD_WAKEUP         35
#define DDSN_CMD_PREPARE_SHUTDOWN 36
#define DDSN_CMD_RESET          37
#define DDSN_CMD_FLUSH          38
#define DDSN_CMD_CLOSE          39

/*
 * trf of char or longwords for byte swapping
 */
#define DDN_TRF_CHAR        0x0
#define DDN_TRF_LONG        0x1
#define DDN_TRF_DATA        0x1

#define DDN_TRF_SWAP        DDN_TRF_LONG
#define DDN_TRF_NOSWAP      DDN_TRF_CHAR 

#define DDN_HEADER          0x19696968
#define DDN_MAX_BLOCKSIZE    100000000
#define DDN_TRF_HEADER      0x12345678
#define DDN_TRF_MAXNFEV     20


/*
 * Communication between server and client are done 
 * by exchanging the following struture
 */
struct ddn_cmd {
  int header;
  int cmd;
  int len;
};

/*
 * the following names are for the hosts on which the system
 * resides:
 * dd_hostname: host on which the dd system resides
 * dd_peername: host on which the client resides (is "" if the programs 
 *              is no server).
 * my_hostname: host on which the program executes.
 *
 * We only take the first 10 characters of the names into account
 * (and have space for the additional "" end string character).
 */
#define HOSTNAME_LEN 21

/*
 * externals
 */
extern int dd_sockfd;
extern char dd_hostname[HOSTNAME_LEN];
extern char dd_peername[HOSTNAME_LEN];
extern char my_hostname[HOSTNAME_LEN];

extern int dd2tcp;
extern int i_am_dd2tcp_producer, i_am_dd2tcp_consumer;
extern int i_am_dd2tcp_server;
extern int ddn_trf_usrdata;
extern int ddn_set_hostnames(char *fifo_name);
extern int ddn_server_running();

/*
 * ddns are the ddn routines executed by the server
 * ddnc are the ddn routines executed by the client
 */

extern int ddnc_exists();
extern int ddnc_attach();
extern int ddnc_init(char *fname, struct fifo_mode fmode);
extern int ddnc_start();
extern int ddnc_stop();
extern int ddnc_put_fev();
extern int ddnc_block_trf(int nfev, struct fifo_entry *p_fev);
extern int ddnc_get_fev();
extern int ddnc_ins_fev();
extern int ddnc_brc_fev();
extern int ddnc_set_brc();
extern int ddnc_set_reqcnt(int req_cnt);
extern int ddnc_set_protection(int protection);
extern int ddnc_set_dd_wait(int mode);
extern int ddnc_set_netswap(int swap_flag);
extern int ddnc_get_free_buffers();
extern int ddnc_close();
extern void ddnc_exit();

/*
 * ddsns are the ddn routines executed by the server for dds calls
 * ddsnc are the ddn routines executed by the client for dds calls
 */
extern int ddsnc_create();
extern int ddsnc_init();
extern int ddsnc_wait4proc(int ntime_ms);
extern int ddsnc_wakeup();
extern int ddsnc_prepare_shutdown();
extern int ddsnc_reset();
extern int ddsnc_flush();
extern int ddsnc_close(int enforce);


/*
 * Test link routines by the client/server.
 */

#define TEST_DATA_LENGTH 256
extern int test_data_send[TEST_DATA_LENGTH];
extern int test_data_rec[TEST_DATA_LENGTH];


/*
 * read and write to the socket
 */
extern int readsocket( int fdes, void *p2dest, int nbytes);
extern int writesocket(int fdes, void *p2source, int nbytes, int data_type);
extern int ddn_send_fev(int fdes, struct fifo_entry fev);
extern int ddn_receive_fev(int fdes, struct fifo_entry *fev);
extern int ddn_set_dd_fp();
extern int ddn_set_byte_swapping();
extern int ddn_set_dataswap(int swap);
extern FILE *dd_fp;


#endif
