#ifndef DD_DCOM_H
#define DD_DCOM_H


/*
 *    Header for the dd_dcom communication shm
 *
 *    CW April 26, 1995
 */

#include <unistd.h>
#include <sys/types.h>
#include <time.h>
#include <db.h>

/*
 * Maximum number of processes and masters on the sytem (note this can 
 * be made smaller by the DD configuration file 
 */
#define DD_MAX_NPROC_ATT 50
#define DD_MAX_NMSTR     15

/*
 * DD shm and semaphore:
 * max_dd_sem depends on the number of processes attached
 */
#define DD_DCOM_SHM_KEY 2
#define DD_DCOM_SEM_KEY 2
#define DD_PROC_PER_SEM 10
#define MAX_DD_SEM 1 + (DD_MAX_NMSTR/DD_PROC_PER_SEM + 1) + (DD_MAX_NPROC_ATT/DD_PROC_PER_SEM + 1)

/* 
 * status of the DD system
 */
#define DD_STATUS_UNUSED  0
#define DD_STATUS_OK      1
#define DD_STATUS_WAIT    2
#define DD_STATUS_FLUSH   3
#define DD_STATUS_FKDUP   4

static char *dd_states[] = {
  "UNUSED  ",
  "ACTIVE  ",
  "WAIT    ",
  "FLUSHING",
  "FKDUP   "};

/*
 * status of processes attached to the DD system
 */
#define DD_PROC_STATE_UNUSED      0
#define DD_PROC_STATE_IDLE        1
#define DD_PROC_STATE_ACTIVE      2
#define DD_PROC_STATE_REQFEV      3
#define DD_PROC_STATE_PUTFEV      4
#define DD_PROC_STATE_BRCFEV      5
#define DD_PROC_STATE_GETFEV      6
#define DD_PROC_STATE_RELFEV      7
#define DD_PROC_STATE_DEBLOCKED   8
#define DD_PROC_STATE_EXIT        9

/*
 * DD read modes - are the same as the
 * fifo read modes
 */
#define DD_WAIT_SLEEP FWAIT_SLEEP
#define DD_WAIT_ASYNC FWAIT_ASYNC


/*
 * Broadcast flags
 */
#define DD_BRC_OFF    0
#define DD_BRC_SIGNAL 1
#define DD_BRC_USMAIL 2


/*
 * maximum wait period for dds_flush 
 * (units in sec = DD_FLUSH_WAIT_TICK*DD_FLUSH_MAXWAIT)
 */
#define DD_FLUSH_WAIT_TICK 0.1
#define DD_FLUSH_MAXWAIT 50

#define DD_BRCCMD_MAXCMD 10
typedef void (*DD_BRCCMD_FCN)(int w1, int b1);

/* size 98 bytes */
struct dd_proc{
  pid_t pid;
  char  pname[30];
  int   fifo;
  int   dd_wait;
  int   status;
  int   brc_flag;
  int   brc_ack;
  struct tm tstart;
  int   master_id;
  int   nputfev;
  int   ngetfev;
  int   dd_sem;
  int   dd_semval;
  DD_BRCCMD_FCN brc_cmd[DD_BRCCMD_MAXCMD];
};

struct dd_master{
  pid_t pid;
  int dd_sem;
  int dd_semval;
};

struct dd_config {
  int max_fifo_nb;
  int fifo_depth;
  int db_maxnbev;
  int db_maxevsize;
  int db_max_buf_vol;
};
 
struct dd_dcom_str {
  int   dd_status;
  pid_t   dd_error_proc;
  int dd_dcom_semid;
  int   dd_nmstr;
  struct dd_master dd_master[DD_MAX_NMSTR];
  int   brc_lock;
  struct dd_config dd_config;
  uid_t dd_garbage_d_uid;
  pid_t dd_garbage_d_pid;
  int   dd_nproc_att;
  struct dd_proc dd_proc[DD_MAX_NPROC_ATT];
  int   fifo_semid;
  int   fifo_lock_semid;
  int   fifo_shmid;
  int   fifo_max_in_use;
  int   db_shmid;
  int   db_ptr_offset[DB_MAXNBEV_MAX];
  unsigned int   nfev_req;
  unsigned int   nbuf_vol_made;
  unsigned int   db_nbuf_vol;
};


/*
 * dd_dcomlib contains the library with the
 * attach/detach etc calls
 */
#include <dd_dcomlib.h>


extern int my_own_ddpid;
extern void dd_dcom_clear();
extern int dd_dcom_init();
extern int dd_dcom_addmaster();
extern int dd_dcom_addproc(char *fname, int mode);
extern int dd_dcom_start();
extern int dd_dcom_stop();
extern int dd_dcom_remproc();
extern int dd_dcom_close();


#endif
