#!/bin/sh
#\
exec $CODA_BIN/dpwish -f "$0" ${1+"$@"}
#
#----------------------------------------------------------------------------*
#  copyright (c) 1991, 1992  southeastern universities research association,#
#                            continuous electron beam accelerator facility  #
#                                                                           #
#    this software was developed under a united states government license   #
#    described in the notice file included as part of this distribution.    #
#                                                                           #
# cebaf data acquisition group, 12000 jefferson ave., newport news, va 23606#
#      heyes@cebaf.gov   tel: (804) 249-7030    fax: (804) 249-7363         #
#----------------------------------------------------------------------------*
# discription: follows this header.
#
# author:
#	graham heyes
#	cebaf data acquisition group
#
# discription : lite version of RunControl to control one component only.
# revision history:
#      $Log: rclite.Tcl,v $
#      Revision 2.5  1998/05/27 13:45:08  heyes
#      add message Q to ROC, improve EB stability on EBD transition
#
#      Revision 2.3  1997/06/07 19:31:45  heyes
#      fix for linux
#
#      Revision 2.2  1997/02/28 16:08:25  abbottd
#      added ending state proceedure
#
#      Revision 2.1  1996/10/29 19:03:14  heyes
#      new rcServer
#
#      Revision 2.0  1996/09/03 13:38:09  heyes
#      add uid and gid to database
#
#      Revision 1.3  1996/08/30 13:29:26  heyes
#      final version of rclite
#
#      Revision 1.2  1996/08/30 11:52:27  heyes
#      Added Log to header
#
#----------------------------------------------------------------------------*/


set auto_path "$auto_path $env(CODA)/common/lib/daq"
source $env(CODA)/common/lib/daq/Dialog.tcl
DIALOG Dlog

proc draw_menu {} {
    global env session component
    
    set images_library $env(CODA)/common/images
    
    set coda_logo [image create photo -file $images_library/gif/RCLogo.gif]
    
    set w [frame .f1 -bd 2 -relief raised]
    
    label $w.logo -bg grey -padx 0 -pady 0 -image $coda_logo
    frame $w.info -relief flat
    label $w.info.t1 -bg grey -padx 0 -pady 0 -text "Session" -bd 2 -relief flat
    label $w.info.t2 -bg grey -padx 0 -pady 0 -text "$session" -bd 2  -relief sunken -fg blue 
    label $w.info.t3 -bg grey -padx 0 -pady 0 -text "Component" -bd 2  -relief flat
    label $w.info.t4 -bg grey -padx 0 -pady 0 -text "$component" -bd 2  -relief sunken -fg blue
    
    pack $w.info.t1 $w.info.t2 $w.info.t3 $w.info.t4 -in $w.info -side left
    
    menubutton $w.file -menu $w.file.m -text File -underline 0 \
	-takefocus 0
    
    menu $w.file.m
    $w.file.m add command -label "Exit     " -command {
      global env
      Dlog setscreen $env(DISPLAY)
      Dlog confirm .cmsglog "Do you really want to quit?" {quit cancel}
      switch [lindex [Dlog result confirm] 0] {
	    "cancel" {
		return
	    }
	    "quit" {
		exit
	    }
	}
    } -underline 1 -accelerator "Ctrl+X"
    
    # Accelerator bindings
    
    bind all <Control-x> {
      global env
      Dlog setscreen $env(DISPLAY)
      Dlog confirm .cmsglog "Do you really want to quit?" {quit cancel}
      switch [lindex [Dlog result confirm] 0] {
	    "cancel" {
		return
	    }
	    "quit" {
		exit
	    }
	}
    }
    pack $w.file -in $w -side left
    pack $w.logo -side left  -padx 6 -expand yes
    pack $w.info -side left  -padx 6 -expand yes
    pack $w -side top -fill x -expand yes
    
    return $w
}

set config "none"

proc configure {conf} {
    global config
    puts "here"
    set config $conf
    .f3.bbox.download config -state normal
}

proc get_config {} {
    global config
    return $config
}

proc draw_config {} {
    global env component
    
    set w [frame  .f2 -bd 2 -relief raised]
    
    tixComboBox $w.lbox -label Configuration -dropdown true \
	-command configure -editable false \
	-options {
	    listbox.height 6
	    label.width 14
	    label.anchor e
	}
    
    db query "select name from runTypes"
    set res [db get rest]
    puts "run types : $res"
    foreach conf $res {
	$w.lbox insert end $conf
    }
    pack $w.lbox -side right -fill both -expand yes
    pack $w -side top -fill both -expand yes
    return $w
}

proc booted {} {
    global config
    if { "$config" == "" } {
	.f3.bbox.download config -state disabled
    } else {
	.f3.bbox.download config -state normal
    }
    .f3.bbox.prestart config -state disabled
    .f3.bbox.go       config -state disabled
    .f3.bbox.end      config -state disabled
    .f3.bbox.pause    config -state disabled
}

proc configured {} {
    .f3.bbox.download config -state normal
    .f3.bbox.prestart config -state disabled
    .f3.bbox.go       config -state disabled
    .f3.bbox.end      config -state disabled
    .f3.bbox.pause    config -state disabled
}

proc downloaded {} {
    global component config
    .f3.bbox.download config -state normal
    .f3.bbox.prestart config -state normal
    .f3.bbox.go       config -state disabled
    .f3.bbox.end      config -state disabled
    .f3.bbox.pause    config -state disabled
    .f8.t2 config -text [DP_ask $component cget -output_type]
}

proc download {} {
    global component config

    .f4.t2 config -text [DP_ask $component download $config]

}

proc paused {} {
    global component config
    .f3.bbox.download config -state disabled
    .f3.bbox.prestart config -state disabled
    .f3.bbox.go       config -state normal
    .f3.bbox.end      config -state normal
    .f3.bbox.pause    config -state disabled
    .f9.t2 config -text [DP_ask $component cget -output_file]
}

proc prestart {} {
    global component config session oevents

    set oevents 0
    .f4.t2 config -text [DP_ask $component prestart]
    db query "select runNumber from sessions where name='$session'"
    set rn [db get next]
    .f5.t2 config -text $rn
    db query "update sessions set runNumber=[expr $rn + 1] where name='$session'"

}

proc active {} {
    global component config
    .f3.bbox.download config -state disabled
    .f3.bbox.prestart config -state disabled
    .f3.bbox.go       config -state disabled
    .f3.bbox.end      config -state normal
    .f3.bbox.pause    config -state normal
}

proc down {} {
    global component config
    .f3.bbox.download config -state disabled
    .f3.bbox.prestart config -state disabled
    .f3.bbox.go       config -state disabled
    .f3.bbox.end      config -state disabled
    .f3.bbox.pause    config -state disabled
}

proc alive {} {
    global component config
    .f3.bbox.download config -state disabled
    .f3.bbox.prestart config -state disabled
    .f3.bbox.go       config -state disabled
    .f3.bbox.end      config -state disabled
    .f3.bbox.pause    config -state disabled
}

proc ending {} {
    global component config
    .f3.bbox.download config -state disabled
    .f3.bbox.prestart config -state disabled
    .f3.bbox.go       config -state disabled
    .f3.bbox.end      config -state disabled
    .f3.bbox.pause    config -state disabled
}

proc go {} {
    global component config

    .f4.t2 config -text [DP_ask $component go]
}

proc pause {} {
    global component config

    .f4.t2 config -text [DP_ask $component pause]

    .f3.bbox.download config -state disabled
    .f3.bbox.prestart config -state disabled
    .f3.bbox.go       config -state normal
    .f3.bbox.end      config -state normal
    .f3.bbox.pause    config -state disabled
}

proc end {} {
    global component config

    .f4.t2 config -text [DP_ask $component end]
    .f3.bbox.download config -state normal
    .f3.bbox.prestart config -state disabled
    .f3.bbox.go       config -state disabled
    .f3.bbox.end      config -state disabled
    .f3.bbox.pause    config -state disabled
}


proc draw_buttons {} {
    set w [frame .f3 -bd 2 -relief raise]
    tixButtonBox $w.bbox -orientation horizontal
    
    $w.bbox config -relief flat
    
    $w.bbox add download -text "download" -command "download " -state disabled
    $w.bbox add prestart -text "prestart" -command "prestart"  -state disabled
    $w.bbox add go -text "go" -command "go"  -state disabled 
    $w.bbox add pause -text "pause" -command "pause" -state disabled
    $w.bbox add end -text "end" -command "end"  -state disabled

    pack $w.bbox -side right -fill both -expand yes
    pack $w -side top -fill both -expand yes
    return $w
}

proc draw_status {} {
    set w [frame .f4 -bd 2 -relief raise]
    label $w.t1 -bg grey -padx 0 -pady 0 -text "State" -bd 2 -relief flat -width 12
    label $w.t2 -bg grey -padx 0 -pady 0 -text "Unknown" -bd 2 -relief sunken -fg blue -width 10
    pack $w.t1 $w.t2  -in $w -side left -fill both -expand yes
    pack $w -side top -fill both -expand yes

    set w [frame .f5 -bd 2 -relief raise]
    label $w.t1 -bg grey -padx 0 -pady 0 -text "Run number" -bd 2 -relief flat -width 12
    label $w.t2 -bg grey -padx 0 -pady 0 -text "Unknown" -bd 2 -relief sunken -fg blue -width 10
    pack $w.t1 $w.t2  -in $w -side left -fill both -expand yes
    pack $w -side top -fill both -expand yes

    set w [frame .f6 -bd 2 -relief raise]
    label $w.t1 -bg grey -padx 0 -pady 0 -text "events" -bd 2 -relief flat -width 12
    label $w.t2 -bg grey -padx 0 -pady 0 -text "0" -bd 2 -relief sunken -fg blue -width 10
    pack $w.t1 $w.t2  -in $w -side left -fill both -expand yes
    pack $w -side top -fill both -expand yes

    set w [frame .f7 -bd 2 -relief raise]
    label $w.t1 -bg grey -padx 0 -pady 0 -text "event rate" -bd 2 -relief flat -width 12
    label $w.t2 -bg grey -padx 0 -pady 0 -text "0" -bd 2 -relief sunken -fg blue -width 10
    pack $w.t1 $w.t2  -in $w -side left -fill both -expand yes
    pack $w -side top -fill both -expand yes

    set w [frame .f8 -bd 2 -relief raise]
    label $w.t1 -bg grey -padx 0 -pady 0 -text "output type" -bd 2 -relief flat -width 12
    label $w.t2 -bg grey -padx 0 -pady 0 -text "unknown" -bd 2 -relief sunken -fg blue -width 10
    pack $w.t1 $w.t2  -in $w -side left -fill both -expand yes
    pack $w -side top -fill both -expand yes

    set w [frame .f9 -bd 2 -relief raise]
    label $w.t1 -bg grey -padx 0 -pady 0 -text "output file" -bd 2 -relief flat -width 12
    label $w.t2 -bg grey -padx 0 -pady 0 -text "------" -bd 2 -relief sunken -fg blue -width 10
    pack $w.t1 $w.t2  -in $w -side left -fill both -expand yes
    pack $w -side top -fill both -expand yes

    dp_after 1000 update_status

}

set oevents 0
proc update_status {} {
    global component oevents
    
    if {[catch "DP_ask $component status" status]} {
	.f4.t2 config -text down
	dp_after 1000 update_status
	return 
    }
    $status
    .f4.t2 config -text $status
    set nevents [DP_ask $component cget -nevents]
    .f6.t2 config -text $nevents
    .f7.t2 config -text [expr $nevents - $oevents]
    set oevents $nevents
    dp_after 1000 update_status
}

if {$argc == 2} {
  #draw_title
  msql connect db    
  db set database $env(EXPID)
  set session [lindex $argv 0]
  set component [lindex $argv 1]
  set w [draw_menu]
  set c [draw_config]
  set b [draw_buttons]
  draw_status
  catch {
      $c.lbox config -value [DP_ask $component cget -config]
      .f4.t2 config -text unknown
      db query "select runNumber from sessions where name='$session'"
      set rn [db get next]
      .f5.t2 config -text $rn
  }
  db query "update sessions set inuse='yes',owner='[exec uname -n] [exec whoami] [uid] [gid]' where name='$session'"

} else {
  puts "usage : $argv0 ?session? ?component_name?"
  exit
}