/* BeginSourceFile mq_code.h */

/*
 * Simple FIFO message queue.
 */
typedef void *msg_t;

struct mq_elt {
	struct mq_elt *next;							/* next elt towards the tail */
	struct mq_elt *prev;							/* next elt towards the head */
	msg_t msg;							/* the message */
};
struct mq {
	pthread_cond_t notempty;							/* messages exist */
	struct mq_elt *head;							/* first message */
	struct mq_elt *tail;							/* last message */
        int cnt;
};
typedef struct mq *mq_t;								/* opaque msg queue ptr */
extern pthread_mutex_t mq_lock;
/* EndSourceFile */
