/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, *
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *      heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * Discription: follows this header.
 *
 * Author:
 *	Graham Heyes
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *      $Log: deb_component.c,v $
 *      Revision 2.119  2003/10/15 14:18:55  abbottd
 *      Support for bank containing bank decoding
 *
 *      Revision 2.118  2000/02/22 20:37:28  rwm
 *      Trade-off b/w performance and real-time.
 *
 *      Revision 2.117  2000/02/07 19:05:18  abbottd
 *      Moved ET initalization to Prestart - Check EBs output options first.
 *
 *      Revision 2.116  2000/01/20 16:17:20  abbottd
 *      Force inputing of Prestart and Go Events into the ET system promptly
 *
 *      Revision 2.115  2000/01/14 21:51:48  abbottd
 *      Change daLogMsg Warnings for CODA_format.so
 *
 *      Revision 2.114  2000/01/14 15:57:43  rwm
 *      Fix bug in ET big event handling & bit of code tidying.
 *
 *      Revision 2.113  1999/12/15 20:29:21  abbottd
 *      Fixed bug with dumping unused ET events
 *
 *      Revision 2.112  1999/12/13 16:09:00  timmer
 *      release unused new events to ET after end event
 *
 *      Revision 2.111  1999/12/10 15:47:12  timmer
 *      reinit ET in prestart for Linux
 *
 *      Revision 2.110  1999/12/09 16:58:08  timmer
 *      reinitialize ET improvements and block getting of new events
 *
 *      Revision 2.109  1999/12/09 14:37:19  abbottd
 *      Increased forced end timeout from 20 to 60 seconds
 *
 *      Revision 2.108  1999/11/22 16:42:09  timmer
 *      new ET api changes
 *
 *      Revision 2.107  1999/10/25 17:21:49  abbottd
 *      Allow ET support for Linux
 *
 *      Revision 2.106  1999/08/27 14:22:17  timmer
 *      upgrade to new api for et_open
 *
 *      Revision 2.105  1999/07/19 19:10:30  timmer
 *      use latest ET with remote stuff
 *
 *      Revision 2.104  1999/05/20 18:31:42  rwm
 *      Previous assertion about length always in byte was wrong.
 *      In general, lengths are in nlongs except when dealing with
 *      ET, or Unix sockets or write calls. (And a few other places)
 *      This needs to be cleaned up...
 *      Confirmed that this works with ET/DD and CODA/Binary output files.
 *
 *      Revision 2.103  1999/05/13 16:49:09  rwm
 *      Fix cast to total_length.
 *
 *      Revision 2.102  1999/05/13 16:14:39  rwm
 *      Changed Event number mismatch from ERROR to FATAL.
 *      Fixed harmless bug with total_length declaration:
 *        was a pointer but used as an unsigned long.
 *      Added some comments.
 *
 *      Revision 2.101  1999/04/16 19:02:53  timmer
 *      new ET api/capabilities
 *
 *      Revision 2.100  1999/04/06 15:30:42  timmer
 *      detach and attach with every run
 *
 *      Revision 2.99  1999/03/02 15:45:56  rwm
 *      Rearranged logic to make sure that EB does not poll, commented out some verbose prints about not being superuser.
 *
 *      Revision 2.98  1999/02/08 14:59:10  timmer
 *      change to api
 *
 *      Revision 2.97  1999/02/01 20:25:25  timmer
 *      changed user interface to hide structs
 *
 *      Revision 2.96  1999/01/08 20:09:41  timmer
 *      upgrade to ET version 3.0
 *
 *      Revision 2.95  1998/11/20 16:23:12  abbottd
 *      fixed file name creation for output to a file
 *
 *      Revision 2.94  1998/11/20 15:39:10  rwm
 *      renamed cb_dont_block and made sure that build thread DOES NOT POLL!
 *
 *      Revision 2.93  1998/11/17 19:19:33  abbottd
 *      remove code for linking bigendian, declare new variable bigendian_in[]
 *
 *      Revision 2.92  1998/11/13 20:10:10  timmer
 *      endian awareness program
 *
 *      Revision 2.91  1998/11/09 15:14:06  timmer
 *      Linux port
 *
 *      Revision 2.90  1998/10/27 18:55:16  abbottd
 *      Cleaned up Event Type Checking - Modified daLogMsg Severities
 *
 *      Revision 2.89  1998/10/15 20:15:57  timmer
 *      small ET change
 *
 *      Revision 2.88  1998/10/15 15:02:12  abbottd
 *      Added Sync info to output descriptor for incorporation into the Event header
 *
 *      Revision 2.87  1998/10/13 15:20:19  abbottd
 *      Added checks for Sync, Ev Type mismatches during build and issue warnings
 *
 *      Revision 2.86  1998/09/11 20:53:01  timmer
 *      flush accumulated events after end event
 *
 *      Revision 2.84  1998/09/02 19:27:22  abbottd
 *      Fixed bugs with User Event handling, User/Control Event length calc., and calls to fast_memcpy replaced with memcpy (fast_memcpy don't work)
 *
 *      Revision 2.83  1998/08/25 19:20:06  rwm
 *      More fixing of messages.
 *
 *      Revision 2.82  1998/08/25 18:26:00  rwm
 *      Fixed up messages about mlock and rt-priority.
 *
 *      Revision 2.81  1998/08/17 20:07:22  timmer
 *      change NEWDD to WITH_ET
 *
 *      Revision 2.80  1998/08/06 20:23:22  timmer
 *      few more NEWDD changes
 *
 *      Revision 2.79  1998/08/06 17:02:42  rwm
 *      Fixed messages about go_rt. Make build thread block.
 *
 *      Revision 2.78  1998/08/05 18:44:01  timmer
 *      add NEWDD or ET system mods
 *
 *      Revision 2.77  1998/07/31 17:45:29  abbottd
 *      cleaned up printing in Control Event building
 *
 *      Revision 2.76  1998/07/31 12:44:31  heyes
 *      fix control events bug
 *
 *      Revision 2.75  1998/07/30 18:29:22  heyes
 *      whoknows who cares...
 *
 *      Revision 2.74  1998/07/30 13:26:17  heyes
 *      I should be committed too...
 *
 *      Revision 2.73  1998/07/30 13:06:34  heyes
 *      add more stuff to roc_dump and more tests in output_proc
 *
 *      Revision 2.72  1998/07/30 13:02:33  rwm
 *      Build thread does not poll and tell us who she is waiting for.
 *
 *      Revision 2.71  1998/07/29 14:17:33  heyes
 *      I fixed something but I'm not sure what
 *
 *      Revision 2.70  1998/07/27 19:17:51  heyes
 *      added support for xfrag.tcl, turned off evsize debugging in ROC
 *
 *      Revision 2.69  1998/07/21 14:44:18  heyes
 *      auto exit shell
 *
 *      Revision 2.68  1998/07/17 15:39:10  heyes
 *      control events were handled incorrectly in deb_component fixed that...
 *
 *      Revision 2.67  1998/07/15 19:13:47  heyes
 *      better thread handling at exit of EB or ROC
 *
 *      Revision 2.66  1998/07/13 15:35:48  heyes
 *      fix problem with Reset on unix ROC
 *
 *      Revision 2.65  1998/07/02 13:19:21  heyes
 *      tweak EB for speed improvements
 *
 *      Revision 2.64  1998/06/30 17:23:58  heyes
 *      tidy up a lot of handle_build...
 *
 *      Revision 2.63  1998/06/17 13:12:05  rwm
 *      Commented out buffer diagnostics.
 *
 *      Revision 2.62  1998/06/04 14:50:10  heyes
 *      send events in buffer to EB
 *
 *      Revision 2.61  1998/06/04 14:12:08  rwm
 *      Various msgQ fixes...
 *
 *      Revision 2.60  1998/06/03 17:47:02  heyes
 *      oops, forgot to change link_debug flag to 1 when on!
 *
 *      Revision 2.59  1998/06/03 17:15:21  rwm
 *      Tuning for faster rate. Only 2 send buffers.  Fix LINK_sized_read.
 *
 *      Revision 2.58  1998/05/27 13:45:04  heyes
 *      add message Q to ROC, improve EB stability on EBD transition
 *
 *      Revision 2.56  1998/05/04 17:26:01  heyes
 *      new ROC
 *
 *      Revision 2.55  1998/03/09 19:50:47  heyes
 *      tidy memory leaks etc
 *
 *      Revision 2.54  1998/03/06 15:05:16  heyes
 *      new faster multi-thread EB
 *
 *      Revision 2.52  1998/02/24 14:29:46  heyes
 *      incr current_limit by 1 not 4
 *
 *      Revision 2.51  1998/02/23 20:30:45  heyes
 *      add multi_mode to EB
 *
 *      Revision 2.50  1998/02/19 15:21:00  heyes
 *      add threads to LINK_support.c
 *
 *      Revision 2.49  1998/02/17 19:55:55  heyes
 *      add own qsort code 6.5 times faster than bultin!!
 *
 *      Revision 2.48  1998/02/04 14:45:08  abbottd
 *      Fix total_length calculation for Control events.
 *
 *      Revision 2.46  1998/01/26 13:17:30  heyes
 *      muliple input buffers added
 *
 *      Revision 2.44  1998/01/15 20:02:01  heyes
 *      ADD a branch called GHEXP
 *
 *      Revision 2.43  1997/12/03 14:04:28  heyes
 *      idle_method
 *
 *      Revision 2.40  1997/11/13 19:22:47  heyes
 *      add broadcast mode
 *
 *      Revision 2.38  1997/10/21 15:01:37  heyes
 *      look in *_class for unknown procs
 *
 *      Revision 2.37  1997/09/19 15:27:56  heyes
 *      with Hall B changes
 *
 *      Revision 2.36  1997/09/18 19:16:13  heyes
 *      final commit before France!
 *
 *      Revision 2.35  1997/09/12 18:26:31  heyes
 *      changed a lot of stuff
 *
 *      Revision 2.34  1997/09/05 12:06:55  heyes
 *      almost final
 *
 *      Revision 2.33  1997/08/28 19:18:38  heyes
 *      add nodelay
 *
 *      Revision 2.32  1997/08/18 14:36:51  heyes
 *      parenthesis in key
 *
 *      Revision 2.31  1997/07/31 13:38:22  abbottd
 *      Fixed bug with Force End feature.
 *
 *      Revision 2.30  1997/07/23 14:24:54  heyes
 *      add @ trick to filename parsing
 *
 *      Revision 2.29  1997/07/18 13:35:26  heyes
 *      timed end on EB
 *
 *      Revision 2.28  1997/07/16 13:27:42  heyes
 *      fix next ROC problem and closure problem on datalinks
 *
 *      Revision 2.27  1997/06/20 15:28:31  abbottd
 *      fixed User event handling/Suppressed printf messages
 *
 *      Revision 2.26  1997/06/17 13:10:36  heyes
 *      fix ending
 *
 *      Revision 2.25  1997/06/11 16:27:07  heyes
 *      oops
 *
 *      Revision 2.24  1997/06/10 18:58:02  heyes
 *      add DD to ROC
 *
 *      Revision 2.23  1997/06/04 01:01:15  heyes
 *      fix Make
 *
 *      Revision 2.21  1997/05/19 19:39:48  heyes
 *      fixed ER multi restart problem
 *
 *      Revision 2.20  1997/05/14 12:30:23  heyes
 *      fix user event problem
 *
 *      Revision 2.19  1997/05/05 18:54:47  heyes
 *      purification
 *
 *      Revision 2.18  1997/04/24 16:02:36  heyes
 *      add header length calculation to deb_component.c
 *
 *      Revision 2.17  1997/04/23 17:33:53  heyes
 *      cmlog added and libmsg removed
 *
 *      Revision 2.16  1997/03/13 16:58:22  heyes
 *      trying to get this stuff in cvs
 *
 *      Revision 2.15  1997/02/28 19:40:13  heyes
 *      roc_mask added to BE
 *
 *      Revision 2.14  1997/02/25 18:49:16  heyes
 *      add error recovery to ROC and EB ./coda_roc -s ghtest -t ROC -n ROC2 -i -r
 *
 *      Revision 2.13  1997/02/13 20:33:41  heyes
 *      help text
 *
 *      Revision 2.12  1997/02/13 15:57:44  heyes
 *      zero data descriptor to fix BOS problem
 *
 *      Revision 2.11  1997/02/12 15:32:08  heyes
 *      add version method
 *
 *      Revision 2.10  1997/02/12 14:31:28  heyes
 *      tcl_modules variable
 *
 *      Revision 2.9  1997/02/11 20:14:38  heyes
 *      error in coda_component.c
 *
 *      Revision 2.8  1997/02/11 20:02:06  heyes
 *      tedious isn't it...
 *
 *      Revision 2.6  1997/01/16 15:30:39  heyes
 *      Increase speed of EB, inc. changes after Dec run.
 *
 *      Revision 2.5  1996/11/01 13:38:05  heyes
 *      Event Recorder
 *
 *      Revision 2.4  1996/10/29 19:03:11  heyes
 *      new rcServer
 *
 *      Revision 2.3  1996/10/17 14:30:05  heyes
 *      fix EB end problem
 *
 *      Revision 2.2  1996/10/08 17:59:00  heyes
 *      working threaded eb
 *
 *      Revision 2.1  1996/09/19 17:25:42  heyes
 *      Support for CODA file format
 *
 *      Revision 2.0  1996/09/19 12:30:03  heyes
 *      Made dummy event builder into a real event builder...
 *
 *      Revision 1.2  1996/08/29 17:03:58  heyes
 *      move include mempart.h to rc.h
 *
 *      Revision 1.1.1.1  1996/08/21 19:19:17  heyes
 *      Imported sources
 *
 *	  Initial revision
 *
 *
 *----------------------------------------------------------------------------*/

/*#define DEBUG*/
/* Largest event in "NONE" mode */

#define LARGEST_EVENT 200000
#define MAX_NODES 300

/* INCLUDES */

#include "da.h"
#include "rc.h"
#include "pthread.h"
#include "./circ_fifo.h"

#ifdef ALOG_DIAG
#include "alog.h"
#endif

#include <dlfcn.h>
#include <sys/mman.h>

#ifdef __sun
  #include <sys/processor.h>
  #include <sys/procset.h>
  #include <sys/lwp.h>
  #include <sys/priocntl.h>
  #include <sys/rtpriocntl.h>
  #include <sys/tspriocntl.h>
  int go_rt(int pri, int tp, int id);
#endif

#include "CODA_format.h"

#define NOTRASH
#define TCL_PROC(name) int name (objClass object, Tcl_Interp *interp, int argc, char **argv)
#define eprintf printf
#define LIST_WAIT_TO 4

extern int polling_routine ();
extern int polling_routine_wrapper ();
extern void *handle_build();
extern void *handle_buffer();
extern int bigendian;
int bigendian_in[32] = {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                        1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}; 

int token_interval = 2;
static int broadcast_mode = 0;
static int broadcast_mode2 = 0;
static int multi_mode = 0;
static int got_go = 0;
typedef struct thread_args *trArg;

int         roc_queue_ix;
circ_buf_t *roc_queues[64];

int roc_queue_evsize[64];

typedef struct thread_args {
  objClass object;
  Tcl_Interp *interp;
  ROL_MEM_ID input;
  int *thread_exit;
  int id;
} TRARGS;

typedef struct EBpriv *EBp;

typedef struct EBpriv {
  int token_count;
  int current_limit;
  int new_limit;
  int current_id;
  int last_id;
  int token_interval;
  int first;
  int last;
  int nrocs;
  int starting;
  int last_bufnb;
  int codaid;
  ROL_MEM_ID frag_hdr_pool;
  circ_buf_t **roc_stream[32];
  int roc_id[32];
  int roc_nb[32];
  int buffer_count;
  int active_buffers;
  int send_tokens;
  int active;
  int ended;
  int ending;
  pthread_mutex_t active_mutex;
  pthread_cond_t active_cond;
  pthread_mutex_t data_mutex;
  pthread_cond_t data_cond;
  int wait_data;
  Tcl_Interp *interp;
  char *current_link;
  char *next_eb;
  char *first_eb;
  pthread_mutex_t mutex;
  pthread_t build_thread;

  unsigned long buf_mask;
  unsigned long roc_mask;
  unsigned long ctl_mask;
  unsigned long ignore_mask;
  unsigned long cur_cntl;

  char *output_type;
  char *filename;
  char *current_file;
  unsigned int output_switch;
  
  unsigned long buffer_mask;
  int primefd;
  int force_end;
  void *in_id;
  void *out_id;
  char in_name[200];
  char out_name[200];
  int nlinks;
  int eventsPerToken;
} eb_priv;

typedef struct bank_part *bankPART;

typedef struct bank_part {
  int bank;
  int length;
  unsigned long *data;
  evDesc desc;
} BANKPART;

typedef int (*IFUNCPTR) ();

#define EVENT_RESERV_FRAG 0
#define EVENT_RESERV_HEAD 1
#define EVENT_RESERV_DESC 2
#define EVENT_ENCODE_FRAG 3
#define EVENT_ENCODE_HEAD 4
#define EVENT_ENCODE_DESC 5
#define EVENT_ENCODE_SPEC 6
#define EVENT_DECODE_FRAG 7
#define EVENT_DECODE_HEAD 8
#define EVENT_DECODE_DESC 9
#define EVENT_DECODE_SPEC 10

static IFUNCPTR in_procs[11];
static IFUNCPTR out_procs[11];

/* for msql and perhaps others. */
static int debugLevel = 0; /* Off */

#ifdef WITH_ET

  #include <et_private.h>
  #include <time.h>
  #define ET_EVENT_ARRAY_SIZE_MAX 50
  extern char	et_name[ET_FILENAME_LENGTH];
  et_sys_id	et_sys;
  et_att_id	et_attach;
  et_event	**etevents=NULL, **etevents_dump=NULL;
  int		et_locality, et_events_chunk, et_eventsize;
  int		et_init = 0, et_reinit = 0;

/* ET Initialization */    
int et_initialize(void) {
  et_openconfig   openconfig;
  struct timespec timeout;
  int    events_total;

  timeout.tv_sec  = 2;
  timeout.tv_nsec = 0;

  /* Normally, initialization is done only once. However, if the ET
   * system dies and is restarted, and we're running on a Linux or
   * Linux-like operating system, then we need to re-initalize in
   * order to reestablish the tcp connection for communication etc.
   * Thus, we must undo some of the previous initialization before
   * we do it again.
   */
  if (et_init > 0) {
    /* unmap shared mem, detach attachment, close socket, free et_sys */
    et_forcedclose(et_sys);
    /* free previous allocation of event pointers */
    free(etevents);
    free(etevents_dump);
  }

  if (et_open_config_init(&openconfig) != ET_OK) {
    printf("deb ET init: cannot allocate mem to open ET system\n");
    daLogMsg ("ERROR", "deb ET init: cannot allocate mem to open ET system");
    return TCL_ERROR;
  }
  et_open_config_setwait(openconfig, ET_OPEN_WAIT);
  et_open_config_settimeout(openconfig, timeout);
  if (et_open(&et_sys, et_name, openconfig) != ET_OK) {
    printf("deb ET init: cannot open ET system\n");
    daLogMsg ("ERROR", "deb ET init: cannot open ET system");
    return TCL_ERROR;
  }
  et_open_config_destroy(openconfig);

  /* set level of debug output */
  et_system_setdebug(et_sys, ET_DEBUG_ERROR);

  /* where am I relative to the ET system? */
  et_system_getlocality(et_sys, &et_locality);

  if(et_station_attach(et_sys, ET_GRANDCENTRAL, &et_attach) < 0) {
    et_close(et_sys);
    printf("deb ET init: cannot attach to ET station\n");
    daLogMsg ("ERROR", "deb ET init: cannot attach to ET station");
    return TCL_ERROR;
  }

  /* find out how many events in this ET system */
  if (et_system_getnumevents(et_sys, &events_total) != ET_OK) {
    et_close(et_sys);
    printf("deb ET init: can't find # events in ET system\n");
    daLogMsg ("ERROR", "deb ET init: cannot find # events in ET system");
    return TCL_ERROR;
  }

  /* find out event size in this ET system */
  if (et_system_geteventsize(et_sys, &et_eventsize) != ET_OK) {
    et_close(et_sys);
    printf("deb ET init: can't find event size in ET system\n");
    daLogMsg ("ERROR", "deb ET init: cannot find event size in ET system");
    return TCL_ERROR;
  }

  /* Allocate an array of event pointers. Set how many. */
  if (events_total < 5) {
    /* if less than 5 events total, be nice and use only 1 at a time */
    et_events_chunk = 1;
  }
  else if (events_total > 2.5*ET_EVENT_ARRAY_SIZE_MAX) {
    /* if 40% of events > ET_EVENT_ARRAY_SIZE_MAX, then still only
     * use an array of size ET_EVENT_ARRAY_SIZE_MAX
     */
    et_events_chunk = ET_EVENT_ARRAY_SIZE_MAX;
  }
  else {
    /* use up only 40% of events at a time to transfer in one chunk */
    et_events_chunk = .4*events_total;
  }

  /* allocate arrays of event pointers used in handle_build thread */
  if ( (etevents = (et_event **) calloc(et_events_chunk, sizeof(et_event *))) == NULL) {
    et_close(et_sys);
    printf("deb ET init: no mem left");
    daLogMsg ("ERROR", "deb ET init: no mem left");
    return TCL_ERROR;
  }
  if ( (etevents_dump = (et_event **) calloc(et_events_chunk, sizeof(et_event *))) == NULL) {
    et_close(et_sys);
    free(etevents);
    printf("deb ET init: no mem left");
    daLogMsg ("ERROR", "deb ET init: no mem left");
    return TCL_ERROR;
  }

  et_init++;
  et_reinit = 0;
  printf("deb ET init: ET fully initialized\n");
  return TCL_OK;
}
#endif    



TCL_PROC(deb_destructor)
{
  EBp ebp = (void *) object->private;
  void *status;
 
  ebp->active = 0;
#ifdef ALOG_DIAG
  ALOG_OUTPUT;
#endif
  if (ebp->build_thread != -1) {
    printf("cancel thread\n");
    if (ebp->build_thread) {
        pthread_t build_thread = ebp->build_thread;
	ebp->build_thread = 0;
	pthread_cancel(build_thread);
    
	pthread_join(ebp->build_thread,&status);
    }
    free(status);
    ebp->build_thread = -1;
  }
  
  Tcl_UnlinkVar (interp, "CDEB::private");    
  Tcl_UnlinkVar (interp, "CDEB::current_limit");
  Tcl_UnlinkVar (interp, "CDEB::output_type");
  Tcl_UnlinkVar (interp, "CDEB::output_switch");
  Tcl_UnlinkVar (interp, "CDEB::output_file");
  Tcl_UnlinkVar (interp, "CDEB::current_file");
  Tcl_UnlinkVar (interp, "CDEB::first_eb");
  Tcl_UnlinkVar (interp, "CDEB::next");
  Tcl_UnlinkVar (interp, "CDEB::current_link");
  Tcl_UnlinkVar (interp, "CDEB::new_limit");
  Tcl_UnlinkVar (interp, "CDEB::last_id");
  Tcl_UnlinkVar (interp, "CDEB::current_id");
  Tcl_UnlinkVar (interp, "CDEB::first");
  Tcl_UnlinkVar (interp, "CDEB::last");
  Tcl_UnlinkVar (interp, "CDEB::nrocs");
  Tcl_UnlinkVar (interp, "CDEB::last_bufnb");
  Tcl_UnlinkVar (interp, "CDEB::token_count");
  Tcl_UnlinkVar (interp, "CDEB::token_interval");
  Tcl_UnlinkVar (interp, "CDEB::frag_hdr_pool");
  Tcl_UnlinkVar (interp, "CDEB::nlinks");
  Tcl_UnlinkVar (interp, "CDEB::eventsPerToken");
  Tcl_UnlinkVar (interp, "CDEB::debugLevel");
  Tcl_UnlinkVar (interp, "CDEB::munti_mode");

  /*ckfree(object->private);*/

  return TCL_OK;
}

#define wait_active(ebp) { \
  pthread_mutex_lock(&(ebp)->active_mutex); \
  while ((ebp)->active == 0) pthread_cond_wait(&(ebp)->active_cond,&(ebp)->active_mutex); \
  pthread_mutex_unlock(&(ebp)->active_mutex); \
}

#define wake_active(ebp) { \
  pthread_mutex_lock(&(ebp)->active_mutex); \
  (ebp)->active = 1; \
  pthread_mutex_unlock(&(ebp)->active_mutex); \
  pthread_cond_signal(&(ebp)->active_cond); \
}

#define sleep_active(ebp) { \
  pthread_mutex_lock(&(ebp)->active_mutex); \
  (ebp)->active = 0; \
  pthread_mutex_unlock(&(ebp)->active_mutex); \
}

#define wait_data(ebp) { \
  pthread_mutex_lock(&(ebp)->data_mutex); \
  while ((ebp)->wait_data == 0) pthread_cond_wait(&(ebp)->data_cond,&(ebp)->data_mutex); \
  pthread_mutex_unlock(&(ebp)->data_mutex); \
}

#define wake_data(ebp) { \
  pthread_mutex_lock(&(ebp)->data_mutex); \
  (ebp)->wait_data = 1; \
  pthread_mutex_unlock(&(ebp)->data_mutex); \
  pthread_cond_signal(&(ebp)->data_cond); \
}

#define sleep_data(ebp) { \
  pthread_mutex_lock(&(ebp)->data_mutex); \
  (ebp)->wait_data = 0; \
  pthread_mutex_unlock(&(ebp)->data_mutex); \
}

TCL_PROC(deb_constructor)
{
  char fname[100],tmp[1000];

  int i;
  EBp ebp,*ebh;
  /* tell anyone watching */
  {
    char tmp[400];

    sprintf(tmp,"%s {%s} %s {%s}",
	    __FILE__,
	    DAYTIME,
	    CODA_USER,
	    "$Id: deb_component.c,v 2.119 2003/10/15 14:18:55 abbottd Exp $");
    Tcl_SetVar (interp, "tcl_modules",tmp,TCL_LIST_ELEMENT|TCL_APPEND_VALUE|TCL_GLOBAL_ONLY);
  }
  
  {
    ebp = object->private = (void *) ckalloc(sizeof (eb_priv));
    bzero((char *) ebp, sizeof (eb_priv));
    ebh = (EBp *) ckalloc(sizeof(EBp));

    ebp->build_thread = -1;

    for (i=0;i<32;i++) {
      char temp[100];
      sprintf(temp,"stream%d",i);

      roc_queues[i] = new_cb(temp);

      ebp->roc_stream[i] = &roc_queues[i];
    }

    roc_queue_ix = 0;

    pthread_mutex_init (&ebp->active_mutex,NULL);
    pthread_cond_init (&ebp->active_cond,NULL);
    pthread_mutex_init (&ebp->data_mutex,NULL);
    pthread_cond_init (&ebp->data_cond,NULL);

    sleep_active(ebp);

    *ebh = ebp;

    Tcl_LinkVar (interp, "CDEB::private",
		 (char *) ebh,
		 TCL_LINK_INT);  
    Tcl_LinkVar (interp, "CDEB::output_file",
		 (char *) &ebp->filename,
		 TCL_LINK_STRING);
    Tcl_LinkVar (interp, "CDEB::current_file",
		 (char *) &ebp->current_file,
		 TCL_LINK_STRING);
    Tcl_LinkVar (interp, "CDEB::output_switch",
		 (char *) &ebp->output_switch,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::output_type",
		 (char *) &ebp->output_type,
		 TCL_LINK_STRING);
    Tcl_LinkVar (interp, "CDEB::current_limit",
		 (char *) &ebp->current_limit,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::first_eb",
		 (char *) &ebp->first_eb,
		 TCL_LINK_STRING);
    Tcl_LinkVar (interp, "CDEB::next",
		 (char *) &ebp->next_eb,
		 TCL_LINK_STRING);
    Tcl_LinkVar (interp, "CDEB::current_link",
		 (char *) &ebp->current_link,
		 TCL_LINK_STRING);
    Tcl_LinkVar (interp, "CDEB::new_limit",
		 (char *) &ebp->new_limit,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::last_id",
		 (char *) &ebp->last_id,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::current_id",
		 (char *) &ebp->current_id,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::first",
		 (char *) &ebp->first,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::last",
		 (char *) &ebp->last,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::nrocs",
		 (char *) &ebp->nrocs,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::last_bufnb",
		 (char *) &ebp->last_bufnb,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::token_count",
		 (char *) &ebp->token_count,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::token_interval",
		 (char *) &ebp->token_interval,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::frag_hdr_pool",
		 (char *) &ebp->frag_hdr_pool,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::send_tokens",
		 (char *) &ebp->send_tokens,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::nlinks",
		 (char *) &ebp->nlinks,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::eventsPerToken",
		 (char *) &ebp->eventsPerToken,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::debugLevel",
		 (char *) &debugLevel,
		 TCL_LINK_INT);
    Tcl_LinkVar (interp, "CDEB::multi_mode",
		 (char *) &multi_mode,
		 TCL_LINK_INT);

    ebp->last_bufnb = -2;
    ebp->codaid = object->codaid;
    ebp->interp = interp;
  }

  if (Tcl_Eval (interp, "set output_type DD;set output_file none") != TCL_OK)
    return TCL_ERROR;

  if( Tcl_VarEval(interp, "set session ",argv[1], NULL) != TCL_OK)
    return TCL_ERROR;

  if (getuid() == 0) {
    printf("Trying to lock EB in memory.\n");
    i = mlockall(MCL_CURRENT|MCL_FUTURE);
    if (i) {
      printf("NOT locked in memory. \n");
      printf("This is okay but the EB might run slower. \nThe error was:\n");
      perror("ERROR: mlockall :");
    } else {
      printf("Now locked in memory.\n");
    }
  }

#ifdef ALOG_DIAG

  ALOG_SETUP(1,ALOG_TRUNCATE);
  
  ALOG_DEFINE(1,"get first fragment","fardle");
  ALOG_DEFINE(2,"start sorting","fardle");
  ALOG_DEFINE(3,"end sorting","fardle");
  ALOG_DEFINE(4,"end of event","fardle");
#endif

  if (getuid() != 0) {
    ; /* Placeholder. */
    /*     printf("You are not the super user.\n" */
    /* 	   "Coda_eb will NOT be locked into memory and \n" */
    /* 	   "will NOT run as a real-time process.\n" */
    /* 	   "If coda_eb slows down and the system is heavily loaded,\n" */
    /* 	   "running as root may help.\n\n"); */
  } else {
    printf("Congratulations you are the super user.\n"
	   "Coda_eb will be locked into memory and \n"
	   "will run as a real-time process.\n"
	   "This will insure that the DAQ speed does not drop under heavy load.\n\n");
  }
  
  Tk_CreateTimerHandler (500, (Tk_TimerProc *) polling_routine_wrapper, (ClientData) object);

  if ( Tcl_Eval(interp, "status booted") != TCL_OK) {
    return TCL_ERROR;
  }
/*   printf("eb constructor: status = booted\n"); */

  return TCL_OK;
}

#ifdef __sun
int
go_rt(int pri, int tp, int id)
{
    pcinfo_t            pcinfo;
    pcparms_t           pcparms;
    
    int stat;
/*     printf("attempt to lock process in core\n"); */
    stat = mlockall(MCL_CURRENT|MCL_FUTURE);
    if (stat) {
      if (errno != EPERM) {
	perror("ERROR: mlockall:");
      }
    } else {
      printf("   Process locked in memory.\n");
    }

    strcpy(pcinfo.pc_clname, "RT");
    if (priocntl(0, 0, PC_GETCID, (caddr_t)&pcinfo) == -1) {
        perror("ERROR: get RT class ID");
        return(-2);
    }
    pcparms.pc_cid = pcinfo.pc_cid;
    ((rtparms_t *)pcparms.pc_clparms)->rt_pri = pri;
    ((rtparms_t *)pcparms.pc_clparms)->rt_tqsecs = 0;
    ((rtparms_t *)pcparms.pc_clparms)->rt_tqnsecs = RT_TQINF;
    if (priocntl(tp,id,PC_SETPARMS,(caddr_t)&pcparms) == -1) {
      if (errno != EPERM) {
        perror("ERROR: Set RT Parms");
      }
      return(-1);
    } else {
      printf("Thread id %d is now a REAL TIME thread!!\n",id);
    }
    return(0);
}
#endif

TCL_PROC(masks_cmd)
{
  char temp[200];
  int ix,jx;
  EBp ebp = (EBp) object->private;

  bzero(temp,200);
  sprintf (temp, "Mask of active ROC links          ");
  
  for (jx=strlen(temp),ix=0;ix<32;ix++,jx++)
    temp[jx] = ((1<<(31 - ix)) & ebp->roc_mask)?'1':'0';
  temp[jx] = '\n';
  
  Tcl_AppendResult (interp, temp, (char *) NULL);

  bzero(temp,200);
  sprintf (temp, "Mask of ROCs we have fragment for ");
  
  for (jx=strlen(temp),ix=0;ix<32;ix++,jx++)
    temp[jx] = ((1<<(31 - ix)) & ebp->ignore_mask)?'1':'0';
  temp[jx] = '\n';

  Tcl_AppendResult (interp, temp, (char *) NULL);

  bzero(temp,200);
  sprintf (temp, "Mask of ROCs we have buffers for  ");
  
  for (jx=strlen(temp),ix=0;ix<32;ix++,jx++)
    temp[jx] = ((1<<(31 - ix)) & ebp->buf_mask)?'1':'0';
  temp[jx] = '\n';
  
  Tcl_AppendResult (interp, temp, (char *) NULL);
  
  return TCL_OK;
}

/* Because we are building events (etc) from threads and Tcl is not
 * thread safe we must have a handler which will be run from the
 * main process thread.
 */
int
polling_routine_wrapper (objClass object)
{
  polling_routine(object);
  Tk_CreateTimerHandler (500, (Tk_TimerProc *) polling_routine_wrapper, (ClientData) object);

  return TCL_OK;
}

int
polling_routine (objClass object)
{
  EBp ebp = (EBp) object->private;
  char token[20], command[1024];
  int temp;
  
  if (ebp->ended == 1) {
    printf("INFO: ended\n");
      
    ebp->ended = 0;
    ebp->ending = 0;

    sleep_active(ebp);
    
    ckfree(object->state);
    object->state = ckalloc(12);
    Tcl_VarEval(ebp->interp,object->name," status downloaded",NULL);
    if (ebp->output_switch == 1) {
      printf("state is now %s close data file\n",object->state);
      close(ebp->primefd);
    } else if (ebp->output_switch == 4){
      printf("state is now %s close data file\n",object->state);
      evClose(ebp->primefd);
    }
  }

  return TCL_OK;
}

TCL_PROC(token_handler)
{
  EBp ebp = (void *) object->private;

   if( Tcl_VarEval(interp, 
		  "set first_eb ",
		  argv[1],
		  NULL) != TCL_OK)
    return TCL_ERROR; 

  if (ebp->last) {
    if( Tcl_VarEval(interp, 
		    "set next $first_eb ",
		    NULL) != TCL_OK)
      return TCL_ERROR; 

  }

  /* next token request will be for this value */

  ebp->current_limit = 1 + atoi(argv[2]);

  /* if the last token sent out requested the buffer that just came 
     in then we can send out a request for more buffers */

  ebp->send_tokens |= 2;

  polling_routine(object);
  return TCL_OK;
}

void 
handle_control_events(objClass object,unsigned long *soe,EBp ebp,evDesc desc)
{
  char *ctype,*dtype;
  
  if (desc->type > 31) {
    ctype = "User event";
  } else if (desc->type == 17) {
    ctype = "prestart";
  } else if (desc->type == 18) {
    ctype = "go";
  } else if (desc->type == 19) {
    ctype = "pause";
  } else if (desc->type == 20) {
    ctype = "end";
  } 
  
  if (ebp->ctl_mask == 0) {
    ebp->cur_cntl = desc->type;
    printf("Build control event: %s(%s",ctype,(*ebp->roc_stream[ebp->roc_nb[desc->rocid]])->name);
  } else {
    if (ebp->cur_cntl != desc->type) {
      if (ebp->cur_cntl > 31) {
	dtype = "User";
      } else if (ebp->cur_cntl == 17) {
	dtype = "prestart";
      } else if (ebp->cur_cntl == 18) {
	dtype = "go";
      } else if (ebp->cur_cntl == 19) {
	dtype = "pause";
      } else if (ebp->cur_cntl == 20) {
	dtype = "end";
      } 
  
      printf(", %s %s != %s ",
	     (*ebp->roc_stream[ebp->roc_nb[desc->rocid]])->name,
	     ctype,
	     dtype);
    } else {
      printf(", %s",(*ebp->roc_stream[ebp->roc_nb[desc->rocid]])->name);
    }
  }
  fflush(stdout);
  ebp->ctl_mask |= (1<<(desc->rocid));
  /* printf("       control mask %08x, roc mask %08x\n",ebp->ctl_mask, ebp->roc_mask);*/
  if (ebp->ctl_mask == ebp->roc_mask) {
    unsigned long *dabufp;
    printf(")\n-- Got all fragments of %s\n",ctype);
    ebp->ctl_mask = 0;
    desc->time = time(NULL);
    desc->rocs[0] = ebp->roc_mask;
    desc->evnb = object->nevents;

    desc->runty = object->runType;
    desc->runnb = object->runNumber;

    dabufp = soe;

    (*out_procs[EVENT_ENCODE_SPEC])(&dabufp,desc);

    if (desc->type == 20) {
      ebp->ended = 1;
      got_go = 0;
    }

    if (desc->type == 18) {
      if (!multi_mode)
	broadcast_mode = broadcast_mode2;
      got_go = 1;
    }
  }
}  

void handle_user_event(EBp ebp,evDesc desc)
{
  /* User event type, we do not build these. Also we
     assume only that there are no fragmented banks
     */
  
  switch (ebp->output_switch) {
  default:
  case 0:
    {
#ifdef WITH_ET
      int status;
      et_event   *pevent;
      
      status = et_event_new(et_sys, et_attach, &pevent, ET_SLEEP,
				NULL, (int)(desc->length + 8) );
      if (status != ET_OK) {
        return;
      }
      pevent->control[0] = desc->type;
      pevent->control[1] = ebp->roc_mask;
      pevent->control[3] = desc->user[1];
      pevent->length     = (int)(desc->length + 8);

      memcpy((char *) pevent->pdata, (char *) desc->soe, (desc->length + 8));
      et_event_put(et_sys, et_attach, pevent);
#else
      struct fifo_entry fev;

      /* boy: length of DD buffer have to be in long words !!! */

      ddu_req_fev((desc->length>>2) + 2, &fev);
      fev.ctlw1 = desc->type;
      fev.ctlb1 = ebp->roc_mask;
      fev.ctlb2 = desc->user[1];
      fev.len = (desc->length>>2) + 2;
      memcpy((char *) fev.p2da,(char *) desc->soe, (desc->length + 8));
      ddu_put_fev(fev);
#endif
    }
  break;
  case 1:
    /* binary file output */
    write(ebp->primefd, (char *) desc->soe, (int) (desc->length + 8));
    break;
  case 4:
    /* coda file output */
    evWrite(ebp->primefd, (char *) (desc->soe));
    break;
  case 2:
    /* debug output */
    {
      int ix,len;
      len = desc->length + 8;
      printf("USER event type %d length %d (bytes)\n",
	     desc->type,len);
      if (len > 256) len = 256;
      for (ix=0;ix<(len>>2);ix++) {
	if ((ix % 8) == 0 ) printf("\n%3d : ",ix);
	printf("%08x ",desc->soe[ix]);
      }
    }
    printf("\n\n");
    break;
  case 3:
    /* no output */
    break;    
  }  
}

#define CONT_EV 0
#define PHYS_EV 1
#define USER_EV 2
#define SYNC_EV 3

/* 
   requeue_event: This function takes the current event and discards it
   by "bumping" the pointers to the start of the event to point to the 
   next event (desc->buf). If this event is the last one in the buffer
   then desc->buf is set to NULL.

   This is implemented as a function call which is theoretically slow 
   but we assume here that our C compiler is "smart" enough to inline 
   the function so that there is no speed hit.
   */

void requeue_event(EBp ebp,evDesc desc)
{
  int len, roc_id, nb_in_buffer = 0;
  unsigned long *buf ;
  unsigned long *temp, *data;
  
  /* Id of the current ROC */
  roc_id = desc->rocid;
    
  /* Decode the event */

  /* First get a pointer to the start of the event by adding the length 
     of the current event to the current event start. (not this is the 
     length of the data desc->length + the header 2 words).
     */

  temp = data = desc->soe + (desc->length>>2) + 2;

  buf = desc->buf;

  /* printf("%d ",buf[3]); /* print events countdown */
  if (buf[3]== 0) {
    /* This is the last event in the buffer so we can free the whole thing */
    ckfree(desc->buf);
    desc->buf = NULL;
  } else {
    /* note this routine returns with "temp" pointing to
       the first data word AFTER the header, note also that if there is
       no data from this ROC EVENT_DECODE_FRAG should still behave itself
       and return a descriptor, DECODE_FRAG can set user[0] equal to the
       event header length if it makes sense to do so. */

    buf[3]--;

    desc->user[0] = 0;
    desc->soe = data;
    
  }
  return;
}

void *
fast_memcpy(void *dest, const void *src, register int len)
{
    register unsigned long long *p1 = (unsigned long long *) dest;
    register unsigned long long *p2 = (unsigned long long *) src;
    register int len16;

    if (len <= 0 || p1 == p2)
	return dest;

    len >>= 3;
    len16 = len >> 5;
    len -= len16 <<5;

    if (len16){
#pragma MP taskloop reduction(p1,p2)
      do {
	p1[0] = p2[0];
	p1[1] = p2[1];
	p1[2] = p2[2];
	p1[3] = p2[3];
	p1[4] = p2[4];
	p1[5] = p2[5];
	p1[6] = p2[6];
	p1[7] = p2[7];
	p1[8] = p2[8];
	p1[9] = p2[9];
	p1[10] = p2[10];
	p1[11] = p2[11];
	p1[12] = p2[12];
	p1[13] = p2[13];
	p1[14] = p2[14];
	p1[15] = p2[15];

	p1[16] = p2[16];
	p1[17] = p2[17];
	p1[18] = p2[18];
	p1[19] = p2[19];
	p1[20] = p2[20];
	p1[21] = p2[21];
	p1[22] = p2[22];
	p1[23] = p2[23];
	p1[24] = p2[24];
	p1[25] = p2[25];
	p1[26] = p2[26];
	p1[27] = p2[27];
	p1[28] = p2[28];
	p1[29] = p2[29];
	p1[30] = p2[30];
	p1[31] = p2[31];
	p1+=32;
	p2+=32;
      } while (--len16 > 0);
    }
    
    if (len) {
      do
	*p1++ = *p2++;
      while (--len > 0);
    }
    return dest;
}

void dumpDesc(evDesc desc)
{
  int ix;
  printf ("_____________________________________________\n");
  printf ("Dump of descriptor for event %d type %d\n",desc->evnb,desc->type);

  printf ("length      = %d\n",desc->length);
  printf ("rocid       = %d\n",desc->rocid);
  printf ("bankCount   = %d\n",desc->bankCount);
  printf ("\n");
  for (ix=0;ix<desc->bankCount;ix++) {
    printf ("  bank frag %d has id = %d,len = %d,addr = %08x\n",
	    ix,
	    desc->bankTag[ix],
	    desc->fragLen[ix],
	    desc->fragments[ix]);
  }
  printf("user0 %d user1 %d user2 %d\n",
	 desc->user[0],
	 desc->user[1],
	 desc->user[2]);

  printf ("\n");
}

void handle_build_cleanup(EBp ebp)
{
  int i,roc;
  printf ("build_thread cleanup\n"
          "--------------------\n"
	  "First remove mutex locks...\n");

  roc_queue_ix = 0;
  printf("then shutdown fifos\n");
  for (i=0;i<32;i++) {
    circ_buf_t *f = roc_queues[i];
    void *buf;
    
    f->deleting = 1;
    if (pthread_mutex_trylock(&f->buf_lock)) {
      printf("Mutex for %s was locked so unlock it\n",get_cb_name(f));
      f->wait_get = 0;
      pthread_cond_signal(&f->empty);      
    }
    pthread_mutex_unlock(&f->buf_lock);
    do {
      printf("count for %s = %d\n",get_cb_name(f),get_cb_count(&f));
      if (get_cb_count(&f) <= 0) 
	break;
      buf = get_cb_data(&f);
      if (buf != (void *)-1) {
	ckfree(buf);
      } 
    } while (buf != (void *)-1);

  }

  printf("Build thread canceled and cleaned\n");
}

/* handle_build : This is the main routine of the "Build thread" it is 
   executed as a detached thread.
   */

void *handle_build(trArg arg)
{
  static objClass object;
  EBp ebp;
  int node_ix;
  evDesc desc;
  static DATA_DESC descriptors[32];
  DATA_DESC desc2;
  long types[32];
  unsigned long fragment_mask, skip_mask, sync_mask, type_mask;
  long current_evnb;
  long current_evty;
  long current_sync;
  unsigned long current_syncerr, current_evtyerr;

  /* WARNING: total_length is used is used in two ways:
   * - it is initially set to NULL and then incremented
   *   by the number of long words in the event, and then
   * - it is the event length in bytes.
   */
  unsigned long *total_length;

  int build_length = LARGEST_EVENT;
  static unsigned long build_buf[LARGEST_EVENT];

  int in_error = 0, res = 0;
  int i, j, k, ix, got_dd_buffer=0;

  static BANKPART *build_node[MAX_NODES];
  static BANKPART build_nodes[MAX_NODES];
  
#ifdef WITH_ET
  int nevents2put=0, nevents2dump=0, neventsfree=0, neventsnew = 0;
  et_event *bigevent;
  et_event *cevent = NULL;
#else
  struct fifo_entry fev;
#endif

#ifdef __sun
  go_rt(57,P_LWPID,lwp_self());
#endif

  pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, &ix);
  pthread_setcanceltype (PTHREAD_CANCEL_ASYNCHRONOUS, &ix);

  object = arg->object;
  ebp = (void *) object->private;

  /* Initialise queues */
  for (i=0;i<32;i++) {
    roc_queues[i]->deleting = 0;
    types[i] = -1;
  }
  
  for (i=0; i< MAX_NODES; i++) {
    build_node[i] = &build_nodes[i];
  }

  fragment_mask = 0;
  sync_mask = 0;
  type_mask = 0;
  skip_mask = 0;

  current_evty = -1;
  current_evnb = -1;
  current_sync =  0;
  current_syncerr = 0;
  current_evtyerr = 0;

  total_length = NULL;
  node_ix = 0;

  /* start out with nothing in descriptors */
  bzero((void *) descriptors,sizeof(descriptors));

  /* On our SMP why not bind a thread to a CPU ? */
#if YOU_ARE_DESPERATE
#ifdef __sun
  if (processor_bind(P_LWPID,_lwp_self(),arg->id,NULL) != 0) {
    perror("build thread bind: ");
  } else { 
    printf("build thread bound to processor %d, lwp %d\n",arg->id,_lwp_self());
  }
  {
    processorid_t p,p1;
    
    processor_bind(P_LWPID,_lwp_self(),PBIND_QUERY,&p1);
    
    printf("we really are bound to processor %d\n",p1);
  }
#endif
#endif

  /* In theory we can come here if there is a problem. */
  pthread_cleanup_push(handle_build_cleanup,(void *) ebp);
  recoverContext("EVENT BUILD THREAD",res);

  if (res) {
    printf("recover...\n");
    ebp->force_end = 1;
  }

  /* this is the main loop of the thread.
     each time around we test the "wait_active" flag. This flag is set
     when the EB is active for data taking. This allows us to play with
     memory allocation etc from the main process without worrying about 
     the handle_build thread.
     */

  do {
    int  cb_block, roc,bank, subBank, typ, issync;
    unsigned long *soe, *dabufp, *data, *temp;
    unsigned long roc_mask = ebp->roc_mask;
    
    /* If we are not active pend here */
  top:

    /* If we need to end in a hurry (force_end)
       we still need to output the "end event".
       */
    if (ebp->force_end)
      {

	printf("ROC mask %d force_end %d\n",ebp->roc_mask,ebp->force_end);
	if (ebp->output_switch == 0)
	  {
#ifdef WITH_ET
	    /* length of ET buffer has to be in bytes !!! */
	    if (neventsfree < 1) {
	      in_error = et_event_new(et_sys, et_attach, &etevents[0], ET_SLEEP, NULL, 120);      
	      nevents2put = 0;
	      neventsfree = 1;
	    }
	    
	    /* if ET system is dead or can't get event, don't put it */
	    if (in_error != ET_OK) {
	      /* need to reinit ET system since something's wrong */
	      et_reinit = 1;
	      break;
	    }
	    
	    soe = dabufp = (unsigned long *) etevents[nevents2put]->pdata;
	    nevents2put++;
	    neventsfree--;
#else
	    /* boy: length of DD buffer has to be in long words !!! */
	    if (got_dd_buffer == 0) {
	      ddu_req_fev(30, &fev);
	    }
	    got_dd_buffer = 1;
	    soe = dabufp = (unsigned long *) fev.p2da;
#endif
	  }
	else
	  {
	    soe = dabufp = build_buf;
	  }
	desc2.type = 20;
	desc2.time = time(NULL);
	desc2.rocs[0] = 0;
	desc2.evnb = object->nevents;
	desc2.runty = object->runType;
	desc2.runnb = object->runNumber;

	(*out_procs[EVENT_ENCODE_SPEC])(&dabufp,desc2);
	ebp->ended = 1;
	bzero((void *) descriptors,sizeof(descriptors));
	node_ix = 0;

	goto output_event;
      }

    /* This loop collects fragments from each input stream until there is a 
       complete event, i.e. fragment_mask == roc_mask
       */

    /* polling does not seem to help now that we have balanced the ROCs. */
    /* So cb will block. LEAVE THIS AS TRUE! RWM Nov 1998. */
    cb_block = TRUE; 

    roc = 0;

#ifdef ALOG_DIAG
    
    if (object->nevents < 5000)
      ALOG_LOG(1,3,0,"g");
#endif

  retry:
    /* Since we know we need one fragment from each ROC loop over all ROCs.
     */
    while (roc_mask != 0 && (fragment_mask != roc_mask)) {   
      if (roc == ebp->nrocs) {
	cb_block = TRUE; /* Second time around block on each queue */
	roc = 0;
      }
      /* already got fragment from this ROC 
       */
      if ((1<<roc) & skip_mask) {
	roc++;
	if (ebp->force_end) {
	  goto top;
	}
	goto retry;
      }
      
      /* If the last event taken was at the end of a buffer (or this is the first
	 event of all we need to "dequeue" a buffer.
      */
      desc = &descriptors[roc];	
      
      if (desc->buf == NULL) {
	unsigned long *buf;
	/*unsigned char typ;*/
	
	/* Get a pointer to the buffer */
	if (( get_cb_count(ebp->roc_stream[roc]) == 0) &&
	    ( cb_block == FALSE )) {
	  /* Break out to bottom of while to avoid 
	   * blocking at get_cb_data below. */
	  continue;
	} 

	buf = data = (unsigned long *) get_cb_data(ebp->roc_stream[roc]);

	if (buf == (unsigned long *) -1) {
	  ebp->roc_mask &= ~ (1<<roc);
	  printf("get_cb_data returned end of file\n");
	  ebp->force_end = 2;
	  
	  goto top;
	}

	if (data[3]) {
	  roc_queue_evsize[roc] = data[0]/data[3];
	}
	
	/* buf[3] is a count of events left in buffer... */
	buf[3]--; 
	
	/* As sent by the ROC the first word of a buffer
	   is the length of data, the second is the ID number
	   of the ROC sending the data */
	
	desc->rocid = data[2];

	/* Bump over the header to point to the start of the first
	   event (length, buffer, # ROC ID, last_event*/
	
	data += 4;
	  	  
	desc->buf  = buf;
	desc->soe = data;
	desc->user[0] = 0;
      }

      /* Decode the event */
      
      /* note this routine returns with "temp" pointing to
	 the first data word AFTER the header, note also that if there is
	 no data from this ROC EVENT_DECODE_FRAG should still behave itself
	 and return a descriptor */
      temp = data = desc->soe;
      typ = (data[1] >> 16) & 0xff;       /* Temp storage of type info */
      issync = (data[1] >> 24) & 0x01;    /* Temp storage of sync info */


      if (typ < 16) {
	(*in_procs[EVENT_DECODE_FRAG])(&temp,desc);
      } else if((typ > 15) && (typ <32)){
	(*in_procs[EVENT_DECODE_SPEC])(&temp,desc);
	desc->evnb = -1;	/* to be sure!! */
	desc->bankCount = 1;    /* Control events have one Bank */
      } else {
	desc->length = (data[0] - 1) << 2; 
	desc->type = typ;
	desc->evnb = -1;
	handle_user_event(ebp,desc);
	requeue_event(ebp,&descriptors[roc]); 

	goto retry;

      } /* end of user event handler */

      /* event type -1 is impossible, use it to mark new event */

      if (current_evty == -1) {
	current_evty = typ;
	current_evnb = desc->evnb;
      } else {
	/* we are already building so we can check some things... */
	if ((current_evnb != desc->evnb) && (in_error == 0)) {
	  in_error = 1;
	  daLogMsg("FATAL","Event (Num %d type %d) NUMBER mismatch -- %s (rocid %d) sent %d (type %d)", 
		 current_evnb,
		 current_evty,
		 (get_cb_name(*ebp->roc_stream[ebp->roc_nb[desc->rocid]])), 
		 desc->rocid,desc->evnb, desc->type);
	  daLogMsg("ERROR","Discard data until next control event");
	  fragment_mask = 0;
	  skip_mask = 0;
	} else if((current_evty != desc->type) && (in_error == 0)) {
	  current_evtyerr++;               /* Count type mismatches from first fragment */
	  type_mask |= (1<<desc->rocid);   /* Get mask of ROC IDs with mismatched types */
	  types[desc->rocid] = desc->type; /* Store type for each ROC */
	}
      } /* End of sequence error checks */
      
      if (in_error) {
	if ((typ >15) && (typ <32)) {
	  daLogMsg("WARN","Found sync point %d for ROC %s",
		 desc->type,(get_cb_name(*ebp->roc_stream[ebp->roc_nb[desc->rocid]])));
	  skip_mask |= (1 << roc);
	  
	  fragment_mask |= (1<< desc->rocid);
	  {
	    register BANKPART *bn = build_node[node_ix];
	    bn->desc = desc;
	  }
	  node_ix++;
	  
	  if (fragment_mask == roc_mask) {
	    in_error = 0;
	    skip_mask = 0;
	    daLogMsg("WARN","Resyncronised via control event");
	    if (desc->type == 20) {
	      printf("got all end events!!!!\n");
	      ebp->force_end = 3;
	    }
	    goto top;
	  }

	  goto retry;
	} else {
	  requeue_event(ebp,&descriptors[roc]); 
	}
      } else {
	/* OK there were no errors so come to this point */
	int ix;
	fragment_mask |= (1<< desc->rocid);
	skip_mask |= (1 << roc);
	if (issync) {
	  sync_mask |= (1<< desc->rocid);
	}
	types[desc->rocid] = desc->type; /* Store type for each ROC */
	
	/* If there was no data from this ROC we need worry no more... 
	   this next "if" takes care of the situation where there was a
	   CODA header from a ROC but no actual data. */
#ifdef DEBUG
	dumpDesc(desc);
#endif
	if (desc->length > 0) {
	  register BANKPART *bn;

	  /* loop over the banks from this ROC to reserve space in the buffer...  
	     Bug Bug, if the buffers were always big enough we could ignore this??
	  */
#ifdef DEBUG
	  printf("reserve fragment, rocid %d type %d nb %d\n",
		 desc->rocid,
		 desc->type,
		 desc->evnb);
#endif

	  (*out_procs[EVENT_RESERV_FRAG])(&total_length);
	  /* convert from bytes to 32 bit long words. */
	  /* Here desc->length is in bytes, convert to long words
	   *  and then increment the total_length pointer by this number. */
	  total_length += (desc->length >> 2);
	    
	  for (ix=0;ix<desc->bankCount;ix++) {
#ifdef DEBUG
	    printf("  bankTag=%d len=%d \n",
		   desc->bankTag[ix],
		   desc->fragLen[ix]);
#endif

	      
	    bn = build_node[node_ix];
	    bn->bank = desc->bankTag[ix];
	    bn->length = desc->fragLen[ix];
	    bn->data = desc->fragments[ix];
	    bn->desc = desc;	      
	    node_ix++;
	  }
	}
      } /* End of if (in_error) */
      
      roc++; /* look at the next ROC */
      
    } /* If we get here we have one fragment for each ROC and fragment_mask == ebp->roc_mask */

    /* First check for Event Type mismatches */
    if (current_evtyerr) {
      daLogMsg("ERROR","Event (Num %d) TYPE mismatch -- %d ROC Banks (ID Mask =0x%08x) differ from selected build type = %d", 
	       current_evnb, current_evtyerr, type_mask, current_evty);

      printf("WARN: Event Type Mismatch info\n");
      for(ix=0;ix<32;ix++) {
	if(fragment_mask&(1<<ix)) {
	  printf("    ROC ID = %d   Type = %d\n", ix, types[ix]);
	}
      }
    }
    /* Now Check for SYNC Mismatches */
    if(sync_mask){
      current_sync = 1;
      if(sync_mask != fragment_mask) {
	  daLogMsg("ERROR","Event (Num %d type %d) SYNC mismatch -- ROC mask = 0x%08x , SYNC mask = 0x%08x", 
		 current_evnb, current_evty, fragment_mask, sync_mask);
	  current_syncerr = fragment_mask&(~sync_mask); /* Keep info on which ROCs missed the Sync Event */
	}
    }
    fragment_mask = skip_mask = 0;
    type_mask = sync_mask = 0;

    (*out_procs[EVENT_RESERV_HEAD])(&total_length);
    (*out_procs[EVENT_RESERV_DESC])(&total_length);
    /*
     * Get a DD buffer of correct size
     */

    if (ebp->output_switch == 0)
      {
#ifdef WITH_ET
	/* length of ET buffer is in bytes !!! */
	
	/* if we've run out of available events, ask for more */
	if (neventsfree < 1) {
	  neventsnew = 0;
	  /* asking for a chunk of normal sized events */
	  in_error = et_events_new(et_sys, et_attach, etevents,
				   ET_SLEEP, NULL, et_eventsize,
				   et_events_chunk, &neventsnew);
/* 	  printf("DEBUG: et_events_new got %d new events.\n", neventsnew); */
	  /* if ET system error ... */
	  if (in_error != ET_OK) {
	    printf("et_events_new: cannot get new events, length = %d bytes, status = %d\n",
		   (int) total_length,in_error);
	    /* break out of do loop and end, since can't put end event */
	    ebp->force_end = 4;
	    et_reinit = 1;
	    break;
	  } else {
	    neventsfree = neventsnew;
	  }
	    
/* 	  printf("DEBUG: At new: nevents2put = %d, nevents2dump = %d, neventsfree = %d.\n", */
/* 		 nevents2put, nevents2dump, neventsfree); */
	  
	}


	/* Check if this is a Control (Prestart or Go) Event.
	   If so we need to get a new seperate event buffer. */
	if( (current_evty == EV_PRESTART) || (current_evty == EV_GO)) {
	  in_error = et_event_new(et_sys, et_attach, &cevent,
				  ET_SLEEP, NULL, (int)total_length);
	  /* if ET system error ... */
	  if (in_error != ET_OK) {
	    printf("et_event_new: cannot get event, length = %d bytes, status = %d\n",
	           (int) total_length,in_error);
            /* break out of do loop and end, since can't put end event */
 	    ebp->force_end = 4;
	    et_reinit = 1;
	    break;
	  }

	}

	/* Check if this is an Extra Large event
	   If so then get a temporary event from et to handle it */
	if ((int) total_length > et_eventsize) {
	  /* ask for a single temp/large event */
	  in_error = et_event_new(et_sys, et_attach, &bigevent,
				  ET_SLEEP, NULL, (int)total_length);
	  /* if ET system error ... */
	  if (in_error != ET_OK) {
	    printf("et_event_new: cannot get temp event, length = %d bytes, status = %d\n",
	           (int) total_length,in_error);
            /* break out of do loop and end, since can't put end event */
 	    ebp->force_end = 4;
	    et_reinit = 1;
	    break;
	  }
	  
	  etevents_dump[nevents2dump] = etevents[nevents2put];

	  nevents2dump++;
/* 	  printf("DEBUG: got big ev: nevents2dump now = %d .\n", nevents2dump); */

	  etevents[nevents2put] = bigevent;
	}
	
	if (cevent != NULL) {
	  soe = dabufp = (unsigned long *) cevent->pdata;
	}else{
	  soe = dabufp = (unsigned long *) etevents[nevents2put]->pdata;
	  nevents2put++;
	  neventsfree--;
	}
#else
	/* length of DD buffer is in long words !!! */
	got_dd_buffer = 0;
	in_error=ddu_req_fev( (int)total_length>>2, &fev);

	if (in_error) {
	  int indx;

	  printf("ddu_req_fev failure, requested length %d\n",total_length);
	  
	  for (indx=0;indx<node_ix;indx++) {
	    printf("bank at index %d has bank tag %d length %d \n",
		   indx,
		   build_node[indx]->bank,
		   build_node[indx]->length);
	    
	  }
	  printf("ddu_req_fev: status returned %d,force end!!! \n",in_error);	
	  ebp->force_end = 4;
	  goto top;
	}
	got_dd_buffer = 1;
	soe = dabufp = (unsigned long *) fev.p2da;
#endif
      }
    else
      {
	if (build_length < (int)total_length)
	  {
	    printf("deep shit mode\n");
	    exit(0);
	  }
	soe = dabufp = build_buf;
      }


    /*
      Loop over all the ROCs in the order they were placed by
      codaedit
      */
    if (current_evty < 16) {
      (*out_procs[EVENT_RESERV_HEAD])(&dabufp);    /* Reserve event header to be filled in later */
      (*out_procs[EVENT_RESERV_DESC])(&dabufp);    /* Reserve event "ID bank" to be filled in later */
 
      object->nevents++;
      desc2.evnb = object->nevents;
      desc2.type = current_evty;
      desc2.syncev = current_sync;
      desc2.err[1] = current_syncerr;
    } 

    bank = -1;
      
    {
      register unsigned long indx,indx2;
      register BANKPART *prev_val, *cur_val,*temp_val, **This;

      if (current_evty < 16) {
	
	/* Do the sort */
	if (node_ix > 1) {
	  This = build_node ;
	  prev_val = build_node[0];
	  
	  for (indx = 1; indx < node_ix; ++indx) {
	    cur_val = This[indx];
	    if (prev_val->bank > cur_val->bank) {
	      /* out of order */
	      This[indx] = prev_val;
	      
	      for (indx2 = indx - 1; indx2 > 0; --indx2) {
		temp_val = This[indx2 - 1];
		if (temp_val->bank > cur_val->bank) {
		  This[indx2] = temp_val;
		} else
		  break;
	      }
	      This[indx2] = cur_val;
	    } else {
	      prev_val = cur_val;
	    }
	  }
	}

	/* Do the build */
	for (indx=0;indx<node_ix;indx++) {
	  cur_val = build_node[indx];
	  
	  desc = cur_val->desc;
	  
	  if (bank != cur_val->bank) {
	    /* new bank */
	    (*out_procs[EVENT_RESERV_FRAG])(&dabufp);
	    bank = cur_val->bank;
	    desc2.length = cur_val->length;
	    memcpy((char *) dabufp,
			cur_val->data,
			cur_val->length
			); 
	    dabufp += (cur_val->length >> 2);
	    desc2.rocid = bank;
	    desc2.bankTag[0] = desc->bankTag[0];
	    desc2.bankSubTag[0] = desc->bankSubTag[0];
	  } else {
	    cur_val->length -= (desc->user[0]<<2);
	    desc2.length += cur_val->length ;
	    memcpy((char *) dabufp,
			cur_val->data + desc->user[0],
			cur_val->length
			);
	    dabufp += (cur_val->length >> 2);
	  }
	  
	  (*out_procs[EVENT_ENCODE_FRAG])(&dabufp, &desc2);
	}
      } else if ((current_evty > 15) && (current_evty < 32)) {
	/* Control events need no building */
	printf("Got control event fragments type = %d  node_ix=%d\n",current_evty,node_ix);
	for (indx=0;indx<node_ix;indx++) {
	  cur_val = build_node[indx];
	  desc = cur_val->desc;
	  if(desc) {
	      handle_control_events(object, soe, ebp, desc);
	      memcpy(&desc2,desc,sizeof(DATA_DESC));
	    }
	}
	/* Fix total_length for Control Events */
	total_length = (unsigned long *) desc->length;
      }
    }
  resync:
    node_ix = 0;
    
    if (current_evty < 16) {
      static int cnt = 0;
      desc2.user[1] = 0;
      (*out_procs[EVENT_ENCODE_DESC])(&dabufp, &desc2);
      (*out_procs[EVENT_ENCODE_HEAD])(&dabufp, &desc2);
    }

    for(roc=0;roc<ebp->nrocs;roc++) {
      desc = &descriptors[roc]; 
      
      /* First get a pointer to the start of the event by adding the length 
	 of the current event to the current event start. (not this is the 
	 length of the data desc->length + the header 2 words).
      */
      
      desc->soe = desc->soe + (desc->length>>2) + 2;
      
      if (desc->buf[3]== 0) {
	/* This is the last event in the buffer so we can free the whole thing */
	ckfree(desc->buf);
	desc->buf = NULL;
      } else {

	desc->buf[3]--;
	desc->user[0] = 0;
      }
    }
    
  output_event:
    switch (ebp->output_switch) {
    default:
    case 0: 
#ifdef WITH_ET
      /* if nothing wrong with ET system, output events */
      if (et_reinit == 0) {
	/* Check for Prestart or Go Event. Pass these events through immediately */
	if( (cevent != NULL) && (current_evty == EV_PRESTART)||(current_evty == EV_GO) ) {
	  cevent->control[0] = desc2.type;
	  cevent->control[1] = ebp->roc_mask;
	  cevent->control[3] = desc2.user[1];
	  cevent->length     = (int) total_length;

	  in_error = et_event_put(et_sys, et_attach, cevent);
	  if (in_error != ET_OK) {
	    et_reinit = 1;
	    ebp->force_end = 4;
	  }else{
	    cevent = NULL;
	  }

	}else{
	  etevents[nevents2put-1]->control[0] = desc2.type;
	  etevents[nevents2put-1]->control[1] = ebp->roc_mask;
	  etevents[nevents2put-1]->control[3] = desc2.user[1];
	  etevents[nevents2put-1]->length     = (int) total_length;
	}

        /* put events back if no free events left or we're forced to end */
        if ((neventsfree < 1) || (ebp->force_end || ebp->ended))  {
          /* put events into ET system */
	  if (nevents2put > 0) {
	    in_error = et_events_put(et_sys, et_attach, etevents, nevents2put);
            if (in_error != ET_OK) {
	      et_reinit = 1;
 	      ebp->force_end = 4;
	    }
	  }
	  
	  /* dump events we're not going to use */
	  if (nevents2dump > 0) {
/* 	    printf("DEBUG: AAA: nevents2dump = %d.\n", nevents2dump); */
	    in_error = et_events_dump(et_sys, et_attach, etevents_dump, nevents2dump);
            if (in_error != ET_OK) {
/* 	      printf("DEBUG: et_events_dump failed..\n"); */
	      et_reinit = 1;
 	      ebp->force_end = 4;
	    }
	  }
	  /* reset variables */
	  nevents2put  = 0;
	  nevents2dump  = 0;

	  if (neventsfree < 1) {
	    neventsfree = 0;
	  }
/* 	  printf("DEBUG: nevents2put = %d, nevents2dump = %d, neventsfree = %d.\n", */
/* 		 nevents2put, nevents2dump, neventsfree); */

        }
      }
#else
      fev.ctlw1 = desc2.type;
      fev.ctlb1 = ebp->roc_mask;
      fev.ctlb2 = desc2.user[1];
      /* boy: change following line */
      /*      fev.len = (int)total_length; */
      fev.len = ((int)total_length)>>2;
      in_error = ddu_put_fev(fev);
#endif
      got_dd_buffer = 0;

      break;
    case 1:
      /* binary file output */
      write(ebp->primefd, (char *) soe, (int) total_length);
      break;
    case 4:
      /* coda file output */
      evWrite(ebp->primefd, (char *) soe);
      break;
    case 2:
      /* debug output */
      {
	int ix,len;
	len = desc2.length;
	printf("event %d type %d length %d (bytes) total_length = %d\n",
	       desc2.evnb, desc2.type, desc2.length, (int)total_length);
	if (len > 256) len = 256;
	for (ix=0;ix<(len>>2);ix++) {
	  if ((ix % 8) == 0 ) printf("\n%3d : ",ix);
	  printf("%08x ",soe[ix]);
	}
      }
      printf("\n\n");
      break;
    case 3:
      /* no output */
      break;    
    } 

    /* bzero((char *) bank_fragment, sizeof(bank_fragment)); */

    current_evty = -1;
    current_sync = 0;
    current_syncerr = 0;
    current_evtyerr = 0;

    total_length = 0;

#ifdef ALOG_DIAG
    if (arg->object->nevents < 5000)
      ALOG_LOG(1,4,0,"g");
#endif

  } while (!(ebp->force_end || ebp->ended));
  
#ifdef WITH_ET
  /* May still be events not written to ET system - flush */
  if ((ebp->output_switch == 0) && (et_reinit == 0)) {
    /* real events to be put into the system */
    if (nevents2put > 0) {
      et_events_put(et_sys, et_attach, etevents, nevents2put);
    }
    /* events that won't be used and will be dumped */
    if (nevents2dump > 0) {
/*       printf("DEBUG: nevents2dump = %d.\n", nevents2dump); */
      et_events_dump(et_sys, et_attach, etevents_dump, nevents2dump);
    }
    /* new events left over after end event */
    if (neventsfree > 0) {
      et_events_dump(et_sys, et_attach, &etevents[(neventsnew-neventsfree)], neventsfree);
/*       printf("DEBUG: Put back %d unused ET buffers\n",neventsfree); */
    }
  }
#endif

  pthread_cleanup_pop(0);
  printf("build thread exiting\n");

  ebp->force_end = 0;
  
  if (got_dd_buffer) {
    printf("WARNING cleanup while got DD buffer!!!!!!\n");
  }
  
  roc_queue_ix = 0;
  {
    int i;
    for (i=0;i<32;i++) {
      circ_buf_t *f = roc_queues[i];
      void *buf;
      
      f->deleting = 1;
	  
      do {
	buf = get_cb_data(&f);
	if (buf != (void *)-1) {
	  ckfree(buf);
	}
      } while (buf != (void *)-1);
      
    }
  }
  ebp->build_thread = -1;
  pthread_detach(pthread_self());
  printf("BUILD thread done\n");
  pthread_exit(NULL);

}

TCL_PROC(force_end)
{
  EBp ebp = (void *) object->private;
  if (ebp->ending) {
    printf("Force end, close datalinks...\n");

    /*Tcl_Eval(interp, "close_links");*/

    ebp->force_end = 99;
  }
  return TCL_OK;
}

TCL_PROC(deb_prestart)
{
  int ix;
  EBp ebp = (void *) object->private;
  
  daLogMsg("INFO","Prestarting (C)");
  /*
    _part_time__.tv_sec = LIST_WAIT_TO;
    _part_time__.tv_nsec = 0 ;
  */
  ebp->buf_mask = 0;

#ifdef WITH_ET
  if ((ebp->output_switch == 0)) {
    int waitforET = 2*(ET_MON_SEC + 1);
    
    /* If we need to initialize, reinitialize */
    if ((et_init == 0) || (et_reinit == 1)) {
      if (et_initialize() != TCL_OK) {
	daLogMsg ("ERROR", "deb prestart: cannot initialize ET system");
	return TCL_ERROR;
      }
    }
    
    /* If this is a Linux system check server */
    if ((!et_alive(et_sys)) && (et_locality == ET_LOCAL_NOSHARE)) {	
      if (et_initialize() != TCL_OK) {
	daLogMsg ("ERROR", "deb prestart: cannot initialize ET system");
	return TCL_ERROR;
      }
    } else if ((!et_alive(et_sys))) {
      if (waitforET < 5) waitforET = 5;
      sleep(waitforET);
      if (!et_alive(et_sys)) {
	daLogMsg("ERROR","deb prestart: ET system is not responding");
	return TCL_ERROR;
      }
    } else {
      daLogMsg("INFO","deb prestart: ET is alive - EB attached");
    }
  }
    
#else
  if ((ebp->output_switch == 0) && (!ddu_attached())) {  /* GHGHGH */
    struct fifo_mode fmode;
    int i,status,ctl[4];
    char fname[20];
    
    strcpy(fname,"INPUT");
    
    fmode.mode = FMODE_ALL;
    fmode.wait = FWAIT_SLEEP;
    fmode.prescale = 1;
    fmode.suser = FMODE_MULTI_USER;
    fmode.p2ctl = ctl;
    
    for (i=0;i<4;i++)
      ctl[i] = -1;
    
    if ( (status = dds_create()) != 0 ) {
      printf("dds_create: status returned %d\n",status);
      return TCL_ERROR;
    }
    
    if ( (status = ddu_init(fname,fmode)) != 0 ) {
	printf("ddu_init status %d \n",status);
	fflush(stdout);
        return TCL_ERROR;
    }
  }  
#endif
  
  /* Setup the ROC masks */
  ebp->roc_mask = 0;
  for (ix=0;ix<32;ix++) {
    if (ebp->roc_id[ix] != -1) {
      ebp->roc_mask |= (1<<ebp->roc_id[ix]);
    }
  }
  {
    char temp[255];
    sprintf(temp,"set_roc_mask %d",ebp->roc_mask);
    if (Tcl_Eval(interp, temp) != TCL_OK)
      daLogMsg("WARN","Failed to set rocMask in database");
  }

  {
    int ix,id;
    trArg args;
    pthread_t thread1;
    pthread_attr_t detached_attr;
    char tmp[100];
    int policy;
    void *status;
    
    pthread_attr_init(&detached_attr);

    /* bugbug: should this be # network interfaces used + 1 build thread ? rwm */
    /* perhaps min (above, # cpus) */
#ifdef __sun
    thr_setconcurrency(20);
#endif

    args = (trArg) ckalloc(sizeof(TRARGS));
    args->object = object;
    args->interp = interp;
 
    args->id = 1;

    pthread_attr_setscope(&detached_attr,
			  PTHREAD_SCOPE_SYSTEM);

    pthread_create( &ebp->build_thread, &detached_attr,
		    (void *(*)(void *)) handle_build, (void *) args);

  }

  
  /*
   * Get the run number.
   */
  
  if (Tcl_Eval (interp, "database query \"select runNumber from sessions where name='$session'\"") != TCL_OK)
    return TCL_ERROR;
  
  if (Tcl_Eval (interp, "database get next") != TCL_OK)
    return TCL_ERROR;
  
  if (Tcl_GetInt (interp, interp->result, &object->runNumber) == TCL_ERROR) {
    return TCL_ERROR;
  }
  
  if (Tcl_Eval (interp, "database query \"select id from runTypes where name='$config'\"") != TCL_OK)
    return TCL_ERROR;
  
  if (Tcl_Eval (interp, "database get next") != TCL_OK)
    return TCL_ERROR;
  
  if (Tcl_GetInt (interp, interp->result, &object->runType) == TCL_ERROR) {
    return TCL_ERROR;
  }

  if (Tcl_Eval (interp, "database query \"select value from ${config}_option where name='tokenInterval'\"") != TCL_OK)
    return TCL_ERROR;

  if (Tcl_Eval (interp, "database get next") != TCL_OK)
    return TCL_ERROR;

  if (Tcl_GetInt (interp, interp->result, &ebp->eventsPerToken) == TCL_ERROR)
    ebp->eventsPerToken = 64;

  if (ebp->eventsPerToken <= 0)
    ebp->eventsPerToken = 64;

  printf("events per token %d\n",ebp->eventsPerToken);

  daLogMsg ("INFO", "prestarting,run %d, type %d", object->runNumber, object->runType);
  
  object->nevents = 0;
  object->nlongs = 0;

  {
    int ix, async;
    static char temp[100];
    
    for (ix=0;ix<32;ix++) {
      if (ebp->roc_id[ix] != -1) {
	sprintf(temp,"%d",ix);
	if (Tcl_VarEval(interp,"DP_ask [lindex $links ",temp,"] cget -async_roc",NULL) != TCL_OK) {
	  printf("ERROR: %s\n",interp->result);
	} else {
	  async = atoi(interp->result);
	}
	
	if (async == 0) {	  
	  ebp->roc_mask |= (1<<ebp->roc_id[ix]);
	} else {
	  ebp->roc_mask &= ~(1<<ebp->roc_id[ix]);
	}
      }
    }
  }
  
  ebp->current_limit = 1;
  ebp->last_bufnb = -2;
  ebp->token_count = ebp->buffer_count = 0;
  
  if (ebp->first) {
    /* if send_tokens == 7 we send first token */
    int ix;

    ebp->nlinks = 1;

    ebp->send_tokens = 7;
    /* polling_routine(object); */

  } else {
    ebp->starting = 1;
  }
  
  if ((ebp->output_switch == 1)||(ebp->output_switch == 4)) {
    if (ebp->filename[0] == '@') {
      char temp[500];
      printf("Executing file : %s\n",ebp->filename);
      sprintf(temp,"%s %d %d $config 0",&ebp->filename[1],object->runNumber, object->runType);
      if (Tcl_VarEval(interp,temp,NULL) != TCL_OK) {
	daLogMsg ("ERROR", "Filename generation script %s failed",ebp->filename);
	return TCL_ERROR;
      }
      if (ebp->current_file)
	ckfree(ebp->current_file);
      ebp->current_file = strdup(interp->result);
    } else {
      if (ebp->current_file)
	ckfree(ebp->current_file);
      ebp->current_file = ckalloc((strlen(ebp->filename)+100));
      sprintf(ebp->current_file, ebp->filename, object->runNumber);
    }
    
    printf("Opening file : %s\n",ebp->current_file);

    if (ebp->output_switch == 1) {
      ebp->primefd = open(ebp->current_file, O_WRONLY | O_CREAT | O_TRUNC, 0666);
    } else {
      evOpen(ebp->current_file,"w",&ebp->primefd);
    }

    if (ebp->primefd == -1) {
      perror("error opening file");
      Tcl_AppendResult (interp,
			"ERROR", "Unable to open output file : ",
			ebp->current_file,"::",
			strerror(errno),
			(char *) NULL);
      
      return TCL_ERROR;
    }
  }
  
  wake_active(ebp);
  wake_active(ebp);

  if( Tcl_Eval(interp, "status paused") != TCL_OK)
    return TCL_ERROR; 
  
  return TCL_OK;
}  

TCL_PROC(deb_go)
{
  EBp ebp = (void *) object->private;
  daLogMsg("INFO","Activating (C)");

  ebp->ended = 0;

  if( Tcl_Eval(interp, "status active") != TCL_OK)
    return TCL_ERROR; 

  return TCL_OK;
}  

TCL_PROC(deb_end)
{
  EBp ebp = (void *) object->private;
  printf("state is %s\n",object->state);
  if (strcmp(object->state,"downloaded") == 0 ) { 
    daLogMsg("INFO","already ended, got all end(s) from ROC(s)");
    if( Tcl_Eval(interp, "status downloaded") != TCL_OK)
      return TCL_ERROR; 
  } else {
    daLogMsg("INFO","Ending (C)");
    if( Tcl_Eval(interp, "status ending") != TCL_OK)
      return TCL_ERROR; 
    ebp->ending = 1;
    Tcl_Eval(interp, "dp_after 60000 $this force_end");
  }
  return TCL_OK;
}  

TCL_PROC(shutdown_build)
{
  EBp ebp = (void *) object->private;
  void *status;
  if (ebp->build_thread != -1) {
    printf("cancel thread\n");
    if (ebp->build_thread) {
        pthread_t build_thread = ebp->build_thread;
	ebp->build_thread = 0;
	pthread_cancel(build_thread);
    
	pthread_join(ebp->build_thread,&status);
    }
    printf("status is %08x\n",status);
    if (status)
      free(status);
    ebp->build_thread = -1;
  }
  
  return TCL_OK;
}

TCL_PROC(deb_download)
{
  EBp ebp = (void *) object->private;
  int deflt = 0;
  char tmp[1000];
  char tmp2[1000];
  int  listArgc,ix;
  char **listArgv;  

  ebp->force_end = 0;

  sleep_active(ebp);
  broadcast_mode = 0;

  /*
    _part_time__.tv_sec = LIST_WAIT_TO;
    _part_time__.tv_nsec = 0 ;
  */

  if (ebp->build_thread != -1) {
    daLogMsg ("WARN", "Can't download while build thread (%d) active, END first.", ebp->build_thread);
    return TCL_ERROR;
  }

  if (ebp->in_id) {
    daLogMsg ("INFO", "Unloading event decode module %x ", ebp->in_id);

#if defined(__sun) || defined(LINUX)
    if (dlclose ((void *) ebp->in_id) != 0) {
      Tcl_AppendResult (interp, "failed to unload module to decode ", ebp->in_name, "format",(char *) NULL);
      return TCL_ERROR;
    }
#else
    daLogMsg ("WARN", "dynamic loading not yet supported on this platform\n");
#endif
  }

  if (ebp->out_id) {
    daLogMsg ("INFO", "Unloading event encode module %x ", ebp->out_id);

#if defined(__sun) || defined(LINUX)
    if (dlclose ((void *) ebp->out_id) != 0) {
      Tcl_AppendResult (interp, "failed to unload module to encode ", ebp->out_name, "format",(char *) NULL);
      return TCL_ERROR;
    }
#else
    daLogMsg ("WARN", "dynamic loading not yet supported on this platform\n");
#endif
  }

  daLogMsg ("INFO", "Downloading configuration \"%s\"", argv[1]);

  strcpy(ebp->in_name,"CODA");
  strcpy(ebp->out_name,"CODA");

  /*
   * Get the list of readout-lists from the database.
   */
  sprintf (tmp,
	   "database query {select code from %s where name='%s'}",
	   argv[1],
	   object->name);
  
  if (Tcl_Eval (interp, tmp) != TCL_OK)
    return TCL_ERROR;
  
  if (Tcl_Eval (interp, "database get next") != TCL_OK)
    return TCL_ERROR;
  
  strcpy (tmp, interp->result);
  
  /*
   * Decode configuration string...
   */
  listArgc = 0;

  if (strcmp (tmp, "{}") != 0) {
    /* Get rid of leading and trailing Braces */
    strncpy ((char *) &tmp2[0], (char *) &tmp[1], (strlen (tmp) - 2));
    tmp2[(strlen (tmp) - 2)] = '\0';
    
    if (Tcl_SplitList (interp, tmp2, &listArgc, &listArgv) != TCL_OK) {
      Tcl_AppendResult (interp, "failed to split list ", tmp2, (char *) NULL);
      return TCL_ERROR;
    }
    
  }
  /*
   * Get object filename in order to find the ROLs __init
   * routine
   */
  if (listArgc == 2) {
    strcpy(ebp->in_name,listArgv[0]);
    /*
     * Load the decode module
     */
    sprintf(tmp,"%s/%s_format.so",getenv("CODA_LIB"),listArgv[0]);
#if defined(__sun) || defined(LINUX)
    ebp->in_id = dlopen ((char *) tmp, RTLD_NOW | RTLD_GLOBAL);
    if (ebp->in_id == 0) {
      daLogMsg ("WARN", "dlopen failed on Input file %s\n",tmp);
      daLogMsg ("WARN", "%s \n",dlerror());
      deflt = 1;
    } else {
      daLogMsg ("INFO", "file %s loaded\n",tmp);
    }
#else
    daLogMsg ("WARN", "dynamic loading not supported\n");
    deflt = 1;
#endif
    
    strcpy(ebp->out_name,listArgv[1]);
    /*
     * Load the encode module
     */
    sprintf(tmp,"%s/%s_format.so",getenv("CODA_LIB"),listArgv[1]);
#if defined(__sun) || defined(LINUX)
    ebp->out_id = dlopen ((char *) tmp, RTLD_NOW | RTLD_GLOBAL);
    if (ebp->out_id == 0) {
      daLogMsg ("WARN", "dlopen failed on Output file %s\n",tmp);
      daLogMsg ("WARN", "%s \n",dlerror());
      deflt = 1;
    }
#else
    daLogMsg ("WARN", "dynamic loading not supported\n");
    deflt = 1;
#endif
  } else {
    deflt = 1;
    daLogMsg ("WARN", "row %s table %s no code entry CODA fmt is deflt.\n", object->name,argv[1]);
  }
  
  /*
   * Now look up the routines in the library and fill in the tables
   *
   */
  if (deflt) {
    /*
     * tedious default to CODA format
     */
    daLogMsg ("INFO", "Using inbuilt (CODA) format\n");
    in_procs[EVENT_RESERV_FRAG] = 
      out_procs[EVENT_RESERV_FRAG] = CODA_reserv_frag;
    
    in_procs[EVENT_RESERV_HEAD] = 
      out_procs[EVENT_RESERV_HEAD] = CODA_reserv_head;
    
    in_procs[EVENT_RESERV_DESC] = 
      out_procs[EVENT_RESERV_DESC] = CODA_reserv_desc;
    
    in_procs[EVENT_ENCODE_FRAG] = 
      out_procs[EVENT_ENCODE_FRAG] = CODA_encode_frag;
    in_procs[EVENT_ENCODE_HEAD] = 
      out_procs[EVENT_ENCODE_HEAD] = CODA_encode_head;
    in_procs[EVENT_ENCODE_DESC] = 
      out_procs[EVENT_ENCODE_DESC] = CODA_encode_desc;
    in_procs[EVENT_ENCODE_SPEC] = 
      out_procs[EVENT_ENCODE_SPEC] = CODA_encode_spec;
    
    in_procs[EVENT_DECODE_FRAG] = 
      out_procs[EVENT_DECODE_FRAG] = CODA_decode_frag;
    in_procs[EVENT_DECODE_HEAD] = 
      out_procs[EVENT_DECODE_HEAD] = CODA_decode_head;
    in_procs[EVENT_DECODE_DESC] = 
      out_procs[EVENT_DECODE_DESC] = CODA_decode_desc;
    in_procs[EVENT_DECODE_SPEC] = 
      out_procs[EVENT_DECODE_SPEC] = CODA_decode_spec;
    
  } else {
    IFUNCPTR proc;
    /* even more tedious find input formatting procs */
    sprintf(tmp,"%s_reserv_frag",ebp->in_name);
    proc = (IFUNCPTR) dlsym (ebp->in_id, tmp);
    in_procs[EVENT_RESERV_FRAG] = proc;
    sprintf(tmp,"%s_reserv_head",ebp->in_name);
    proc = (IFUNCPTR) dlsym (ebp->in_id, tmp);
    in_procs[EVENT_RESERV_HEAD] = proc;
    sprintf(tmp,"%s_reserv_desc",ebp->in_name);
    proc = (IFUNCPTR) dlsym (ebp->in_id, tmp);
    in_procs[EVENT_RESERV_DESC] = proc;
    sprintf(tmp,"%s_encode_frag",ebp->in_name);
    proc = (IFUNCPTR) dlsym (ebp->in_id, tmp);
    in_procs[EVENT_ENCODE_FRAG] = proc;
    sprintf(tmp,"%s_encode_head",ebp->in_name);
    proc = (IFUNCPTR) dlsym (ebp->in_id, tmp);
    in_procs[EVENT_ENCODE_HEAD] = proc;
    sprintf(tmp,"%s_encode_desc",ebp->in_name);
    proc = (IFUNCPTR) dlsym (ebp->in_id, tmp);
    in_procs[EVENT_ENCODE_DESC] = proc;
    sprintf(tmp,"%s_encode_spec",ebp->in_name);
    proc = (IFUNCPTR) dlsym (ebp->in_id, tmp);
    in_procs[EVENT_ENCODE_SPEC] = proc;
    sprintf(tmp,"%s_decode_frag",ebp->in_name);
    proc = (IFUNCPTR) dlsym (ebp->in_id, tmp);
    in_procs[EVENT_DECODE_FRAG] = proc;
    sprintf(tmp,"%s_decode_head",ebp->in_name);
    proc = (IFUNCPTR) dlsym (ebp->in_id, tmp);
    in_procs[EVENT_DECODE_HEAD] = proc;
    sprintf(tmp,"%s_decode_desc",ebp->in_name);
    proc = (IFUNCPTR) dlsym (ebp->in_id, tmp);
    in_procs[EVENT_DECODE_DESC] = proc;
    sprintf(tmp,"%s_decode_spec",ebp->in_name);
    proc = (IFUNCPTR) dlsym (ebp->in_id, tmp);
    in_procs[EVENT_DECODE_SPEC] = proc;
    
    /* even more tedious find outp formatting procs */

    sprintf(tmp,"%s_reserv_frag",ebp->out_name);
    proc = (IFUNCPTR) dlsym (ebp->out_id, tmp);
    out_procs[EVENT_RESERV_FRAG] = proc;
    sprintf(tmp,"%s_reserv_head",ebp->out_name);
    proc = (IFUNCPTR) dlsym (ebp->out_id, tmp);
    out_procs[EVENT_RESERV_HEAD] = proc;
    sprintf(tmp,"%s_reserv_desc",ebp->out_name);
    proc = (IFUNCPTR) dlsym (ebp->out_id, tmp);
    out_procs[EVENT_RESERV_DESC] = proc;
    sprintf(tmp,"%s_encode_frag",ebp->out_name);
    proc = (IFUNCPTR) dlsym (ebp->out_id, tmp);
    out_procs[EVENT_ENCODE_FRAG] = proc;
    sprintf(tmp,"%s_encode_head",ebp->out_name);
    proc = (IFUNCPTR) dlsym (ebp->out_id, tmp);
    out_procs[EVENT_ENCODE_HEAD] = proc;
    sprintf(tmp,"%s_encode_desc",ebp->out_name);
    proc = (IFUNCPTR) dlsym (ebp->out_id, tmp);
    out_procs[EVENT_ENCODE_DESC] = proc;
    sprintf(tmp,"%s_encode_spec",ebp->out_name);
    proc = (IFUNCPTR) dlsym (ebp->out_id, tmp);
    out_procs[EVENT_ENCODE_SPEC] = proc;
    sprintf(tmp,"%s_decode_frag",ebp->out_name);
    proc = (IFUNCPTR) dlsym (ebp->out_id, tmp);
    out_procs[EVENT_DECODE_FRAG] = proc;
    sprintf(tmp,"%s_decode_head",ebp->out_name);
    proc = (IFUNCPTR) dlsym (ebp->out_id, tmp);
    out_procs[EVENT_DECODE_HEAD] = proc;
    sprintf(tmp,"%s_decode_desc",ebp->out_name);
    proc = (IFUNCPTR) dlsym (ebp->out_id, tmp);
    out_procs[EVENT_DECODE_DESC] = proc;
    sprintf(tmp,"%s_decode_spec",ebp->out_name);
    proc = (IFUNCPTR) dlsym (ebp->out_id, tmp);
    out_procs[EVENT_DECODE_SPEC] = proc;
    daLogMsg ("INFO", "Loaded in format %s out format %s\n",ebp->in_name,ebp->out_name);
    
  }

  return TCL_OK;
}

TCL_PROC(CDEB_init_thread)
{
  /*return LINK_thread_init(interp,object,argv[1],handle_buffer);*/
}

TCL_PROC(CDEB_fragment_sizes)
{
  
  int i;
  char tmp[100];
  for (i=0;i<roc_queue_ix;i++) { 
    sprintf(tmp, "{%s %s %d} ",roc_queues[i]->parent,roc_queues[i]->name,roc_queue_evsize[i]);
    Tcl_AppendResult(interp,tmp,NULL);
  }
  return TCL_OK;
}
